/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.booter;

import java.nio.charset.StandardCharsets;

public enum ForkedProcessEventType {
    BOOTERCODE_SYSPROPS("sys-prop"),
    BOOTERCODE_TESTSET_STARTING("testset-starting"),
    BOOTERCODE_TESTSET_COMPLETED("testset-completed"),
    BOOTERCODE_TEST_STARTING("test-starting"),
    BOOTERCODE_TEST_SUCCEEDED("test-succeeded"),
    BOOTERCODE_TEST_FAILED("test-failed"),
    BOOTERCODE_TEST_SKIPPED("test-skipped"),
    BOOTERCODE_TEST_ERROR("test-error"),
    BOOTERCODE_TEST_ASSUMPTIONFAILURE("test-assumption-failure"),
    BOOTERCODE_STDOUT("std-out-stream"),
    BOOTERCODE_STDOUT_NEW_LINE("std-out-stream-new-line"),
    BOOTERCODE_STDERR("std-err-stream"),
    BOOTERCODE_STDERR_NEW_LINE("std-err-stream-new-line"),
    BOOTERCODE_CONSOLE_INFO("console-info-log"),
    BOOTERCODE_CONSOLE_DEBUG("console-debug-log"),
    BOOTERCODE_CONSOLE_WARNING("console-warning-log"),
    BOOTERCODE_CONSOLE_ERROR("console-error-log"),
    BOOTERCODE_BYE("bye"),
    BOOTERCODE_STOP_ON_NEXT_TEST("stop-on-next-test"),
    BOOTERCODE_NEXT_TEST("next-test"),
    BOOTERCODE_JVM_EXIT_ERROR("jvm-exit-error");

    private final String opcode;
    private final byte[] opcodeBinary;

    private ForkedProcessEventType(String opcode) {
        this.opcode = opcode;
        this.opcodeBinary = opcode.getBytes(StandardCharsets.US_ASCII);
    }

    public String getOpcode() {
        return this.opcode;
    }

    public byte[] getOpcodeBinary() {
        return this.opcodeBinary;
    }

    public boolean isSysPropCategory() {
        return this == BOOTERCODE_SYSPROPS;
    }

    public boolean isTestCategory() {
        return this == BOOTERCODE_TESTSET_STARTING || this == BOOTERCODE_TESTSET_COMPLETED || this == BOOTERCODE_TEST_STARTING || this == BOOTERCODE_TEST_SUCCEEDED || this == BOOTERCODE_TEST_FAILED || this == BOOTERCODE_TEST_SKIPPED || this == BOOTERCODE_TEST_ERROR || this == BOOTERCODE_TEST_ASSUMPTIONFAILURE;
    }

    public boolean isStandardStreamCategory() {
        return this == BOOTERCODE_STDOUT || this == BOOTERCODE_STDOUT_NEW_LINE || this == BOOTERCODE_STDERR || this == BOOTERCODE_STDERR_NEW_LINE;
    }

    public boolean isConsoleCategory() {
        return this == BOOTERCODE_CONSOLE_INFO || this == BOOTERCODE_CONSOLE_DEBUG || this == BOOTERCODE_CONSOLE_WARNING;
    }

    public boolean isConsoleErrorCategory() {
        return this == BOOTERCODE_CONSOLE_ERROR;
    }

    public boolean isControlCategory() {
        return this == BOOTERCODE_BYE || this == BOOTERCODE_STOP_ON_NEXT_TEST || this == BOOTERCODE_NEXT_TEST;
    }

    public boolean isJvmExitError() {
        return this == BOOTERCODE_JVM_EXIT_ERROR;
    }
}

