/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSPrototypeData;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.JSSharedData;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;

public final class JSObjectUtil {
    private static final HiddenKey PROTOTYPE_DATA = new HiddenKey("PROTOTYPE_DATA");

    private JSObjectUtil() {
    }

    public static Location createConstantLocation(Object value) {
        return JSObject.LAYOUT.createAllocator().constantLocation(value);
    }

    private static LocationFactory declaredLocationFactory() {
        return (shape, val) -> shape.allocator().declaredLocation(val);
    }

    public static Shape shapeDefineDataProperty(JSContext context, Shape shape, Object key, Object value, int flags) {
        CompilerAsserts.neverPartOfCompilation();
        return shape.defineProperty(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), value, flags);
    }

    public static Shape shapeDefineDeclaredDataProperty(JSContext context, Shape shape, Object key, Object value, int flags) {
        CompilerAsserts.neverPartOfCompilation();
        return shape.defineProperty(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), value, flags, JSObjectUtil.declaredLocationFactory());
    }

    @CompilerDirectives.TruffleBoundary
    public static void putDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        thisObj.define(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), value, flags);
    }

    public static void putDataProperty(DynamicObject thisObj, Object name, Object value, int flags) {
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.putDataProperty(context, thisObj, name, value, flags);
    }

    public static void defineDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        thisObj.define(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), value, flags);
    }

    public static void defineDataProperty(DynamicObject thisObj, Object key, Object value, int flags) {
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.defineDataProperty(context, thisObj, key, value, flags);
    }

    public static void putOrSetDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        if (!JSObject.hasOwnProperty(thisObj, key)) {
            JSObjectUtil.putDataProperty(context, thisObj, key, value, flags);
        } else {
            JSObject.set(thisObj, key, value);
        }
    }

    public static Property makeDataProperty(Object key, Location location, int flags) {
        assert (JSRuntime.isPropertyKey(key));
        return Property.create((Object)key, (Location)location, (int)flags);
    }

    public static Property makeAccessorProperty(String name, Location location, int flags) {
        return Property.create((Object)name, (Location)location, (int)(flags | 8));
    }

    public static Property makeProxyProperty(String name, PropertyProxy proxy, int flags) {
        return JSObjectUtil.makeProxyProperty(name, JSObjectUtil.createConstantLocation(proxy), flags);
    }

    public static Property makeProxyProperty(String name, Location location, int flags) {
        return Property.create((Object)name, (Location)location, (int)(flags | 0x10));
    }

    public static Property makeHiddenProperty(HiddenKey id, Location location) {
        return JSObjectUtil.makeHiddenProperty(id, location, false);
    }

    public static Property makeHiddenProperty(HiddenKey id, Location location, boolean relocatable) {
        return Property.create((Object)id, (Location)location, (int)0).copyWithRelocatable(relocatable);
    }

    public static void defineAccessorProperty(DynamicObject thisObj, Object key, Accessor accessor, int flags) {
        int finalFlags = flags | 8;
        JSContext context = JSObject.getJSContext(thisObj);
        thisObj.define(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), (Object)accessor, finalFlags);
    }

    public static void defineProxyProperty(DynamicObject thisObj, Object key, PropertyProxy proxy, int flags) {
        int finalFlags = flags | 0x10;
        JSContext context = JSObject.getJSContext(thisObj);
        thisObj.define(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), (Object)proxy, finalFlags);
    }

    public static void changeFlags(DynamicObject thisObj, Object key, int flags) {
        assert (flags == (flags & 7));
        JSObjectUtil.changeFlags(thisObj, key, attr -> attr & 0xFFFFFFF8 | flags);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean changeFlags(DynamicObject obj, Object key, IntUnaryOperator flagsOp) {
        Shape oldShape = obj.getShape();
        Property existing = oldShape.getProperty(key);
        if (existing != null) {
            int newFlags = flagsOp.applyAsInt(existing.getFlags());
            if (existing.getFlags() != newFlags) {
                Property newProperty = existing.copyWithFlags(newFlags);
                Shape newShape = oldShape.replaceProperty(existing, newProperty);
                obj.setShapeAndGrow(oldShape, newShape);
            }
            return true;
        }
        return false;
    }

    public static void putDataProperty(JSContext context, DynamicObject thisObj, Property dataProperty, Object value) {
        assert (JSProperty.isData(dataProperty));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, dataProperty.getKey()));
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, dataProperty.getKey());
        JSObjectUtil.defineProperty(thisObj, dataProperty, value);
    }

    private static void defineProperty(DynamicObject thisObj, Property property, Object value) {
        thisObj.define(property.getKey(), value, property.getFlags(), (shape, val) -> property.getLocation());
    }

    public static void putDataProperty(JSContext context, DynamicObject thisObj, String name, Object value) {
        assert (JSObjectUtil.checkForExistingProperty(thisObj, name));
        JSObjectUtil.putDataProperty(context, thisObj, name, value, JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    @CompilerDirectives.TruffleBoundary
    public static void putDeclaredDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        thisObj.define(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), value, flags, JSObjectUtil.declaredLocationFactory());
    }

    public static void putConstructorProperty(JSContext context, DynamicObject prototype, DynamicObject constructor) {
        JSObjectUtil.putDataProperty(context, prototype, "constructor", constructor, JSAttributes.configurableNotEnumerableWritable());
    }

    public static void putConstructorPrototypeProperty(JSContext ctx, DynamicObject constructor, DynamicObject prototype) {
        JSObjectUtil.putDataProperty(ctx, constructor, "prototype", prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    public static void putAccessorProperty(JSContext context, DynamicObject thisObj, Object key, DynamicObject getter, DynamicObject setter, int flags) {
        Accessor accessor = new Accessor(getter, setter);
        JSObjectUtil.putAccessorProperty(context, thisObj, key, accessor, flags);
    }

    public static void putAccessorProperty(JSContext context, DynamicObject thisObj, Object key, Accessor accessor, int flags) {
        assert (JSRuntime.isPropertyKey(key));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        thisObj.define(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), (Object)accessor, flags | 8);
    }

    public static void putConstantAccessorProperty(JSContext context, DynamicObject thisObj, Object key, DynamicObject getter, DynamicObject setter) {
        JSObjectUtil.putConstantAccessorProperty(context, thisObj, key, getter, setter, JSAttributes.configurableNotEnumerable());
    }

    public static void putConstantAccessorProperty(JSContext context, DynamicObject thisObj, Object key, DynamicObject getter, DynamicObject setter, int flags) {
        JSObjectUtil.putAccessorProperty(context, thisObj, key, getter, setter, flags);
    }

    public static void putProxyProperty(DynamicObject thisObj, Property proxyProperty) {
        assert (JSProperty.isProxy(proxyProperty));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, proxyProperty.getKey()));
        JSObjectUtil.defineProperty(thisObj, proxyProperty, JSProperty.getConstantProxy(proxyProperty));
    }

    private static boolean checkForExistingProperty(DynamicObject thisObj, Object key) {
        assert (!thisObj.getShape().hasProperty(key)) : "Don't put a property that already exists. Use the setters.";
        return true;
    }

    public static void putHiddenProperty(DynamicObject thisObj, Property property, Object value) {
        assert (property.isHidden());
        JSObjectUtil.defineProperty(thisObj, property, value);
    }

    public static Shape getProtoChildShape(DynamicObject obj, JSClass jsclass, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        if (obj == null) {
            return context.makeEmptyShapeWithPrototypeInObject(jsclass, JSObject.PROTO_PROPERTY);
        }
        assert (JSRuntime.isObject(obj));
        Shape protoChild = JSObjectUtil.getProtoChildShapeMaybe(obj, jsclass);
        if (protoChild != null) {
            return protoChild;
        }
        return JSObjectUtil.getProtoChildShapeSlowPath(obj, jsclass, context);
    }

    public static Shape getProtoChildShape(DynamicObject obj, JSClass jsclass, JSContext context, BranchProfile branchProfile) {
        Shape protoChild = JSObjectUtil.getProtoChildShapeMaybe(obj, jsclass);
        if (protoChild != null) {
            return protoChild;
        }
        branchProfile.enter();
        return JSObjectUtil.getProtoChildShapeSlowPath(obj, jsclass, context);
    }

    private static Shape getProtoChildShapeMaybe(DynamicObject obj, JSClass jsclass) {
        Shape protoChild = JSShape.getProtoChildTree(obj, jsclass);
        assert (protoChild == null || JSShape.getJSClassNoCast(protoChild) == jsclass);
        return protoChild;
    }

    @CompilerDirectives.TruffleBoundary
    private static Shape getProtoChildShapeSlowPath(DynamicObject obj, JSClass jsclass, JSContext context) {
        JSPrototypeData prototypeData = JSObjectUtil.getPrototypeData(obj);
        if (prototypeData == null) {
            prototypeData = JSObjectUtil.putPrototypeData(obj);
        }
        return prototypeData.getOrAddProtoChildTree(jsclass, JSObjectUtil.createChildRootShape(obj, jsclass, context));
    }

    private static Shape createChildRootShape(DynamicObject obj, JSClass jsclass, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        return JSShape.makeRootShape(JSObject.LAYOUT, new JSSharedData(context, JSShape.makePrototypeProperty(obj)), jsclass);
    }

    public static JSPrototypeData putPrototypeData(DynamicObject obj) {
        CompilerAsserts.neverPartOfCompilation();
        assert (JSObjectUtil.getPrototypeData(obj) == null);
        JSPrototypeData prototypeData = new JSPrototypeData();
        JSObjectUtil.putPrototypeData(obj, prototypeData);
        return prototypeData;
    }

    private static void putPrototypeData(DynamicObject obj, JSPrototypeData prototypeData) {
        boolean wasNotExtensible = !JSShape.isExtensible(obj.getShape());
        obj.define((Object)PROTOTYPE_DATA, (Object)prototypeData);
        if (wasNotExtensible && JSObject.isExtensible(obj)) {
            obj.delete((Object)JSShape.NOT_EXTENSIBLE_KEY);
            JSObject.preventExtensions(obj);
            assert (!JSObject.isExtensible(obj));
        }
    }

    static JSPrototypeData getPrototypeData(DynamicObject obj) {
        return (JSPrototypeData)obj.get((Object)PROTOTYPE_DATA);
    }

    public static Map<Object, Object> archive(DynamicObject obj) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Shape shape = obj.getShape();
        for (Property prop : shape.getPropertyListInternal(false)) {
            if (prop.getLocation().isValue() || ret.containsKey(prop.getKey())) continue;
            ret.put(prop.getKey(), prop.get(obj, false));
        }
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setPrototype(DynamicObject object, DynamicObject newPrototype) {
        Shape newRootShape;
        CompilerAsserts.neverPartOfCompilation((String)"do not set object prototype from compiled code");
        JSContext context = JSObject.getJSContext(object);
        Shape oldShape = object.getShape();
        JSShape.invalidatePrototypeAssumption(oldShape);
        if (newPrototype == Null.instance) {
            newRootShape = context.makeEmptyShapeWithNullPrototype(JSShape.getJSClass(oldShape));
        } else {
            assert (JSRuntime.isObject(newPrototype)) : newPrototype;
            newRootShape = JSObjectUtil.getProtoChildShape(newPrototype, JSShape.getJSClass(oldShape), context);
        }
        Map<Object, Object> archive = JSObjectUtil.archive(object);
        object.setShapeAndResize(oldShape, newRootShape);
        Shape newShape = newRootShape;
        boolean sameLocations = true;
        for (Property p : oldShape.getPropertyListInternal(true)) {
            Object key = p.getKey();
            if (newRootShape.hasProperty(key)) continue;
            if (p.getLocation().isValue()) {
                newShape = newShape.addProperty(p);
                object.setShapeAndGrow(newShape.getParent(), newShape);
                continue;
            }
            if (p.isHidden() && sameLocations) {
                newShape = newShape.addProperty(p);
                newShape.getLastProperty().setSafe(object, archive.get(key), newShape.getParent(), newShape);
                continue;
            }
            sameLocations = false;
            JSShape.invalidatePropertyAssumption(oldShape, key);
            Object value = archive.get(key);
            newShape = newShape.defineProperty(key, value, p.getFlags());
            newShape.getLastProperty().setSafe(object, value, newShape.getParent(), newShape);
        }
    }

    public static <T> T checkForNoSuchPropertyOrMethod(JSContext context, T key) {
        if (context != null && key != null && context.isOptionNashornCompatibilityMode()) {
            if (context.getNoSuchPropertyUnusedAssumption().isValid() && key.equals("__noSuchProperty__")) {
                context.getNoSuchPropertyUnusedAssumption().invalidate("NoSuchProperty is used");
            }
            if (context.getNoSuchMethodUnusedAssumption().isValid() && key.equals("__noSuchMethod__")) {
                context.getNoSuchMethodUnusedAssumption().invalidate("NoSuchMethod is used");
            }
        }
        return key;
    }

    public static void putFunctionsFromContainer(final JSRealm realm, final DynamicObject thisObj, JSBuiltinsContainer container) {
        final JSContext context = realm.getContext();
        container.forEachBuiltin((Consumer<? super JSBuiltin>)new Consumer<Builtin>(){

            @Override
            public void accept(Builtin builtin) {
                if (builtin.getECMAScriptVersion() > context.getEcmaScriptVersion()) {
                    return;
                }
                if (builtin.isAnnexB() && !context.isOptionAnnexB()) {
                    return;
                }
                JSFunctionData functionData = builtin.createFunctionData(context);
                JSObjectUtil.putDataProperty(context, thisObj, builtin.getKey(), JSFunction.create(realm, functionData), builtin.getAttributeFlags());
            }
        });
    }
}

