/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;

abstract class GuestToHostRootNode
extends RootNode {
    protected static final int ARGUMENT_OFFSET = 2;
    private final String boundaryName;
    static final Accessor.CallInlined CALL_INLINED = EngineAccessor.ACCESSOR.getCallInlined();

    protected GuestToHostRootNode(Class<?> targetType, String methodName) {
        super(null);
        this.boundaryName = targetType.getName() + "." + methodName;
        EngineAccessor.NODES.clearPolyglotEngine(this);
    }

    @Override
    protected boolean isInstrumentable() {
        return false;
    }

    @Override
    public boolean isCloningAllowed() {
        return false;
    }

    @Override
    public final String getName() {
        return this.boundaryName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        try {
            return this.executeImpl(arguments[1], arguments);
        }
        catch (InteropException e) {
            throw GuestToHostRootNode.silenceException(RuntimeException.class, e);
        }
        catch (Throwable e) {
            throw PolyglotImpl.hostToGuestException((PolyglotLanguageContext)arguments[0], e);
        }
    }

    static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    protected abstract Object executeImpl(Object var1, Object[] var2) throws InteropException;

    static CallTarget createGuestToHost(GuestToHostRootNode rootNode) {
        return Truffle.getRuntime().createCallTarget(rootNode);
    }

    static Object guestToHostCall(Node node, CallTarget target, Object ... arguments) {
        Node encapsulatingNode = node.isAdoptable() ? node : NodeUtil.getCurrentEncapsulatingNode();
        return CALL_INLINED.call(encapsulatingNode, target, arguments);
    }
}

