/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRealm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSForeignToJSTypeNode.class)
public final class JSForeignToJSTypeNodeGen
extends JSForeignToJSTypeNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;

    private JSForeignToJSTypeNodeGen() {
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitString((state & 0x3C000) >>> 14, arg0Value)) {
            String arg0Value_ = JSTypesGen.asImplicitString((state & 0x3C000) >>> 14, arg0Value);
            return this.fromString(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            return this.fromBigInt(arg0Value_);
        }
        if ((state & 0x30) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            if ((state & 0x10) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                return this.fromLongToInt(arg0Value_);
            }
            if ((state & 0x20) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                return this.fromLong(arg0Value_);
            }
        }
        if ((state & 0x40) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0000) >>> 18, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state & 0x3C0000) >>> 18, arg0Value);
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromNumber(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromNumber(arg0Value_);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromNumber(arg0Value_);
        }
        if ((state & 0x400) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 0x800) != 0 && JSGuards.isJavaNull(arg0Value)) {
            return this.isNull(arg0Value);
        }
        if ((state & 0x1000) != 0 && arg0Value instanceof TruffleObject) {
            TruffleObject arg0Value_ = (TruffleObject)arg0Value;
            return this.fromTruffleJavaObject(arg0Value_, this.javaScriptLanguageContextReference_);
        }
        if ((state & 0x2000) != 0 && JSForeignToJSTypeNodeGen.fallbackGuard_(state, arg0Value)) {
            return this.fallbackCase(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            int n;
            if (arg0Value instanceof Integer) {
                int n2 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n3 = this.fromInt(n2);
                return n3;
            }
            int n4 = JSTypesGen.specializeImplicitString(arg0Value);
            if (n4 != 0) {
                String arg0Value_3 = JSTypesGen.asImplicitString(n4, arg0Value);
                state |= n4 << 14;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.fromString(arg0Value_3);
                return string;
            }
            if (arg0Value instanceof Boolean) {
                boolean bl = (Boolean)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Boolean arg0Value_3 = this.fromBoolean(bl);
                return arg0Value_3;
            }
            if (arg0Value instanceof BigInt) {
                BigInt bigInt = (BigInt)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                BigInt arg0Value_3 = this.fromBigInt(bigInt);
                return arg0Value_3;
            }
            if (arg0Value instanceof Long) {
                long l = (Long)arg0Value;
                if (JSGuards.isLongRepresentableAsInt32(l)) {
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Integer n5 = this.fromLongToInt(l);
                    return n5;
                }
                if (!JSGuards.isLongRepresentableAsInt32(l)) {
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Long l2 = this.fromLong(l);
                    return l2;
                }
            }
            if ((n = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_7 = JSTypesGen.asImplicitDouble(n, arg0Value);
                state |= n << 18;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Double d = this.fromDouble(arg0Value_7);
                return d;
            }
            if (arg0Value instanceof Byte) {
                byte by = (Byte)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Integer arg0Value_7 = this.fromNumber(by);
                return arg0Value_7;
            }
            if (arg0Value instanceof Short) {
                short s = (Short)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Integer arg0Value_7 = this.fromNumber(s);
                return arg0Value_7;
            }
            if (arg0Value instanceof Float) {
                float object = ((Float)arg0Value).floatValue();
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Double arg0Value_7 = this.fromNumber(object);
                return arg0Value_7;
            }
            if (arg0Value instanceof Character) {
                char c = ((Character)arg0Value).charValue();
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                String arg0Value_7 = this.fromChar(c);
                return arg0Value_7;
            }
            if (JSGuards.isJavaNull(arg0Value)) {
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                Object object = this.isNull(arg0Value);
                return object;
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject truffleObject = (TruffleObject)arg0Value;
                TruffleLanguage.ContextReference javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                if (javaScriptLanguageContextReference__ == null) {
                    this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                }
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                Object object = this.fromTruffleJavaObject(truffleObject, (TruffleLanguage.ContextReference<JSRealm>)javaScriptLanguageContextReference__);
                return object;
            }
            this.state_ = state |= 0x2000;
            lock.unlock();
            hasLock = false;
            Object object = this.fallbackCase(arg0Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FFF & (state & 0x3FFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[15];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "fromInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "fromString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "fromBoolean";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "fromBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "fromLongToInt";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "fromLong";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "fromDouble";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "fromChar";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "isNull";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "fromTruffleJavaObject";
        if ((state & 0x1000) != 0) {
            s[1] = (byte)1;
            ArrayList<List<TruffleLanguage.ContextReference>> cached = new ArrayList<List<TruffleLanguage.ContextReference>>();
            cached.add(Arrays.asList(this.javaScriptLanguageContextReference_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "fallbackCase";
        s[1] = (state & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        if (JSTypesGen.isImplicitString(arg0Value)) {
            return false;
        }
        if ((state & 4) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state & 0x80) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state & 0x100) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state & 0x200) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state & 0x400) == 0 && arg0Value instanceof Character) {
            return false;
        }
        if ((state & 0x800) == 0 && JSGuards.isJavaNull(arg0Value)) {
            return false;
        }
        return (state & 0x1000) != 0 || !(arg0Value instanceof TruffleObject);
    }

    public static JSForeignToJSTypeNode create() {
        return new JSForeignToJSTypeNodeGen();
    }

    public static JSForeignToJSTypeNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JSForeignToJSTypeNode.class)
    private static final class Uncached
    extends JSForeignToJSTypeNode {
        private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return this.fromInt(arg0Value_);
            }
            if (JSTypesGen.isImplicitString(arg0Value)) {
                String arg0Value_ = JSTypesGen.asImplicitString(arg0Value);
                return this.fromString(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                return this.fromBigInt(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if (JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                    return this.fromLongToInt(arg0Value_);
                }
                if (!JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                    return this.fromLong(arg0Value_);
                }
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return this.fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return this.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return this.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                return this.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                return this.fromChar(arg0Value_);
            }
            if (JSGuards.isJavaNull(arg0Value)) {
                return this.isNull(arg0Value);
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject)arg0Value;
                return this.fromTruffleJavaObject(arg0Value_, this.javaScriptLanguageContextReference_);
            }
            return this.fallbackCase(arg0Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

