/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.CompileRegexNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.RegexCompilerInterface;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

@ImportStatic(value={JSConfig.class})
@ReportPolymorphism
public abstract class CompileRegexNode
extends JavaScriptBaseNode {
    @Node.Child
    private TRegexUtil.CompileRegexNode executeCompilerNode = TRegexUtil.CompileRegexNode.create();
    private final JSContext context;

    protected CompileRegexNode(JSContext context) {
        this.context = context;
    }

    public static CompileRegexNode create(JSContext context) {
        return CompileRegexNodeGen.create(context);
    }

    public final Object compile(String pattern) {
        return this.compile(pattern, "");
    }

    public final Object compile(CharSequence pattern, String flags) {
        return this.executeCompile(pattern, flags);
    }

    protected abstract Object executeCompile(CharSequence var1, String var2);

    @Specialization(guards={"stringEquals(pattern, cachedPattern)", "stringEquals(flags, cachedFlags)"}, limit="MaxCompiledRegexCacheLength")
    protected Object getCached(String pattern, String flags, @Cached(value="pattern") String cachedPattern, @Cached(value="flags") String cachedFlags, @Cached(value="doCompile(pattern, flags)") Object cachedCompiledRegex) {
        return cachedCompiledRegex;
    }

    protected static boolean stringEquals(String a, String b) {
        return a.equals(b);
    }

    @Specialization(guards={"!TrimCompiledRegexCache"})
    protected Object doCompileNoTrimCache(String pattern, String flags) {
        return this.doCompile(pattern, flags);
    }

    @Specialization(replaces={"getCached"})
    protected Object doCompile(String pattern, String flags) {
        return RegexCompilerInterface.compile(pattern, flags, this.context, this.executeCompilerNode);
    }
}

