/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.regex.RegexCompiler;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;

public class ForeignRegexCompiler
implements RegexCompiler {
    private final TruffleObject foreignCompiler;

    public ForeignRegexCompiler(TruffleObject foreignCompiler) {
        this.foreignCompiler = foreignCompiler;
    }

    public static RegexCompiler importRegexCompiler(TruffleObject regexCompiler) {
        return regexCompiler instanceof RegexCompiler ? (RegexCompiler)regexCompiler : new ForeignRegexCompiler(regexCompiler);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleObject compile(RegexSource source) throws RegexSyntaxException, UnsupportedRegexException {
        try {
            return (TruffleObject)((InteropLibrary)InteropLibrary.getFactory().getUncached()).execute((Object)this.foreignCompiler, new Object[]{source.getPattern(), source.getFlags()});
        }
        catch (InteropException ex) {
            throw new RuntimeException(ex);
        }
    }
}

