/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.stream.AbstractStreamDecoder;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.EventHandler;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;
import org.apache.maven.surefire.stream.EventDecoder;

public class EventConsumerThread
extends CloseableDaemonThread {
    private final ReadableByteChannel channel;
    private final EventHandler<Event> eventHandler;
    private final CountdownCloseable countdownCloseable;
    private final EventDecoder decoder;
    private final ForkNodeArguments arguments;
    private volatile boolean disabled;

    public EventConsumerThread(@Nonnull String threadName, @Nonnull ReadableByteChannel channel, @Nonnull EventHandler<Event> eventHandler, @Nonnull CountdownCloseable countdownCloseable, @Nonnull ForkNodeArguments arguments) {
        super(threadName);
        this.decoder = new EventDecoder(channel, arguments);
        this.channel = channel;
        this.eventHandler = eventHandler;
        this.countdownCloseable = countdownCloseable;
        this.arguments = arguments;
    }

    public void run() {
        try {
            ReadableByteChannel stream = this.channel;
            try {
                CountdownCloseable c = this.countdownCloseable;
                try {
                    EventDecoder eventDecoder = this.decoder;
                    try {
                        AbstractStreamDecoder.Memento memento = new AbstractStreamDecoder.Memento((AbstractStreamDecoder)eventDecoder);
                        while (true) {
                            Event event;
                            if ((event = eventDecoder.decode(memento)) == null || this.disabled) {
                                continue;
                            }
                            this.eventHandler.handleEvent((Object)event);
                        }
                    }
                    catch (Throwable throwable) {
                        if (eventDecoder != null) {
                            try {
                                eventDecoder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                }
                throw throwable;
            }
        }
        catch (EOFException | ClosedChannelException stream) {
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException || e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.arguments.dumpStreamException((Throwable)e);
        }
    }

    public void disable() {
        this.disabled = true;
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

