/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.ShapeImpl;
import java.util.EnumSet;
import java.util.Objects;

public abstract class LayoutImpl
extends Layout {
    private static final int INT_TO_DOUBLE_FLAG = 1;
    private static final int INT_TO_LONG_FLAG = 2;
    protected final LayoutStrategy strategy;
    protected final Class<? extends DynamicObject> clazz;
    private final int allowedImplicitCasts;
    static final CoreAccess ACCESS = new CoreAccess();

    protected LayoutImpl(EnumSet<Layout.ImplicitCast> allowedImplicitCasts, Class<? extends DynamicObject> clazz, LayoutStrategy strategy) {
        this.strategy = strategy;
        this.clazz = Objects.requireNonNull(clazz);
        this.allowedImplicitCasts = LayoutImpl.implicitCastFlags(allowedImplicitCasts);
    }

    static int implicitCastFlags(EnumSet<Layout.ImplicitCast> allowedImplicitCasts) {
        return (allowedImplicitCasts.contains((Object)Layout.ImplicitCast.IntToDouble) ? 1 : 0) | (allowedImplicitCasts.contains((Object)Layout.ImplicitCast.IntToLong) ? 2 : 0);
    }

    @Override
    public abstract DynamicObject newInstance(Shape var1);

    @Override
    public Class<? extends DynamicObject> getType() {
        return this.clazz;
    }

    @Override
    public final Shape createShape(ObjectType objectType, Object sharedData) {
        return this.createShape(objectType, sharedData, 0);
    }

    @Override
    public final Shape createShape(ObjectType objectType, Object sharedData, int flags) {
        return this.newShape(objectType, sharedData, ShapeImpl.checkObjectFlags(flags));
    }

    @Override
    public final Shape createShape(ObjectType objectType) {
        return this.createShape(objectType, null);
    }

    protected abstract Shape newShape(Object var1, Object var2, int var3);

    public boolean isAllowedIntToDouble() {
        return (this.allowedImplicitCasts & 1) != 0;
    }

    public boolean isAllowedIntToLong() {
        return (this.allowedImplicitCasts & 2) != 0;
    }

    protected abstract boolean hasObjectExtensionArray();

    protected abstract boolean hasPrimitiveExtensionArray();

    protected abstract int getObjectFieldCount();

    protected abstract int getPrimitiveFieldCount();

    protected abstract Location getObjectArrayLocation();

    protected abstract Location getPrimitiveArrayLocation();

    @Override
    public abstract Shape.Allocator createAllocator();

    public LayoutStrategy getStrategy() {
        return this.strategy;
    }

    public String toString() {
        return "Layout[" + this.clazz.getName() + "]";
    }

    static final class CoreAccess
    extends Layout.Access {
        private CoreAccess() {
        }
    }
}

