/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html.ui;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.HtmlFormattingAppendableBase;
import com.vladsch.flexmark.util.html.ui.BackgroundColor;
import com.vladsch.flexmark.util.html.ui.Color;
import com.vladsch.flexmark.util.html.ui.ColorStyler;
import com.vladsch.flexmark.util.html.ui.FontStyle;
import com.vladsch.flexmark.util.html.ui.FontStyleStyler;
import com.vladsch.flexmark.util.html.ui.FontStyler;
import com.vladsch.flexmark.util.html.ui.HtmlStyler;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.plaf.FontUIResource;

public class HtmlBuilder
extends HtmlFormattingAppendableBase<HtmlBuilder> {
    private final Appendable myBuilder = this.getAppendable();
    public static final HashMap<Class, HtmlStyler> stylerMap = new HashMap();

    public HtmlBuilder() {
        super(new StringBuilder(), 0, 16);
    }

    public HtmlBuilder(int indentSize, int formatOptions) {
        super(new StringBuilder(), indentSize, formatOptions);
    }

    public HtmlBuilder closeAllTags() {
        while (!this.getOpenTags().isEmpty()) {
            CharSequence tag = this.getOpenTags().peek();
            this.closeTag(tag);
        }
        return this;
    }

    public String toFinalizedString() {
        this.closeAllTags();
        this.flush();
        return this.myBuilder.toString();
    }

    public String toString() {
        return this.myBuilder.toString();
    }

    public HtmlBuilder attr(Object ... convertible) {
        for (Object convert : convertible) {
            if (convert instanceof Attribute) {
                super.attr(new Attribute[]{(Attribute)convert});
                super.withAttr();
                continue;
            }
            HtmlStyler styler = HtmlBuilder.getHtmlStyler(convert);
            if (styler == null) {
                throw new IllegalStateException("Don't know how to style " + convert.getClass().getSimpleName());
            }
            String value = styler.getStyle(styler.getStyleable(convert));
            if (value == null || value.isEmpty()) continue;
            AttributeImpl style = AttributeImpl.of("style", value);
            super.attr(new Attribute[]{style});
            super.withAttr();
        }
        return this;
    }

    @Override
    public HtmlBuilder attr(CharSequence name, CharSequence value) {
        super.withAttr();
        return (HtmlBuilder)super.attr(name, value);
    }

    public HtmlBuilder style(CharSequence value) {
        super.withAttr();
        return (HtmlBuilder)super.attr("style", value);
    }

    @Override
    public HtmlBuilder attr(Attribute ... attribute) {
        super.withAttr();
        return (HtmlBuilder)super.attr(attribute);
    }

    @Override
    public HtmlBuilder attr(Attributes attributes) {
        super.withAttr();
        return (HtmlBuilder)super.attr(attributes);
    }

    public HtmlBuilder span() {
        return (HtmlBuilder)this.tag("span", false);
    }

    public HtmlBuilder span(CharSequence text) {
        this.tag("span", false);
        this.text(text);
        return this.closeSpan();
    }

    public HtmlBuilder span(boolean withLine, Runnable runnable) {
        return (HtmlBuilder)this.tag("span", false, withLine, runnable);
    }

    public HtmlBuilder span(Runnable runnable) {
        return this.span(false, runnable);
    }

    public HtmlBuilder spanLine(Runnable runnable) {
        return this.span(true, runnable);
    }

    public HtmlBuilder closeSpan() {
        return (HtmlBuilder)this.closeTag("span");
    }

    public static void addColorStylerClass(Class clazz) {
        HtmlStyler styler = stylerMap.get(Color.class);
        stylerMap.put(clazz, styler);
    }

    public static HtmlStyler getHtmlStyler(Object item) {
        HtmlStyler styler = stylerMap.get(item.getClass());
        if (styler != null) {
            return styler;
        }
        for (Class value : stylerMap.keySet()) {
            if (!value.isAssignableFrom(item.getClass())) continue;
            styler = stylerMap.get(value);
            break;
        }
        if (styler != null) {
            stylerMap.put(item.getClass(), styler);
        }
        return styler;
    }

    public static Attribute getAttribute(Object item) {
        String value;
        HtmlStyler styler = HtmlBuilder.getHtmlStyler(item);
        if (styler != null && (value = styler.getStyle(styler.getStyleable(item))) != null && !value.isEmpty()) {
            return AttributeImpl.of("style", value);
        }
        return null;
    }

    public HtmlBuilder append(Object obj) {
        return (HtmlBuilder)super.append(String.valueOf(obj));
    }

    public HtmlBuilder append(String str) {
        return (HtmlBuilder)super.append(str);
    }

    public HtmlBuilder append(StringBuffer sb) {
        return (HtmlBuilder)super.append(sb.toString());
    }

    @Override
    public HtmlBuilder append(CharSequence s) {
        return (HtmlBuilder)super.append(s);
    }

    @Override
    public HtmlBuilder append(CharSequence s, int start, int end) {
        return (HtmlBuilder)super.append(s, start, end);
    }

    public HtmlBuilder append(char[] str) {
        return (HtmlBuilder)super.append(CharSubSequence.of(str, 0, str.length));
    }

    public HtmlBuilder append(char[] str, int offset, int len) {
        return (HtmlBuilder)super.append(CharSubSequence.of(str, offset, offset + len));
    }

    public HtmlBuilder append(boolean b) {
        return (HtmlBuilder)super.append(b ? "true" : "false");
    }

    @Override
    public HtmlBuilder append(char c) {
        return (HtmlBuilder)super.append(c);
    }

    public HtmlBuilder append(int i) {
        return (HtmlBuilder)super.append(String.valueOf(i));
    }

    public HtmlBuilder append(long l) {
        return (HtmlBuilder)super.append(String.valueOf(l));
    }

    public HtmlBuilder append(float f) {
        return (HtmlBuilder)super.append(String.valueOf(f));
    }

    public HtmlBuilder append(double d) {
        return (HtmlBuilder)super.append(String.valueOf(d));
    }

    static {
        ColorStyler colorStyler = new ColorStyler();
        stylerMap.put(BackgroundColor.class, colorStyler);
        stylerMap.put(Color.class, colorStyler);
        stylerMap.put(java.awt.Color.class, colorStyler);
        FontStyler fontStyler = new FontStyler();
        stylerMap.put(Font.class, fontStyler);
        stylerMap.put(FontUIResource.class, fontStyler);
        stylerMap.put(FontStyle.class, new FontStyleStyler());
    }
}

