/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.runtime.JSContext;
import org.graalvm.collections.EconomicMap;

public class GlobalEnvironment
extends Environment {
    private final FunctionEnvironment functionEnvironment;
    private final EconomicMap<String, Boolean> lexicalDeclarations;
    private final EconomicMap<String, Boolean> varDeclarations;

    public GlobalEnvironment(Environment parent, NodeFactory factory, JSContext context) {
        super(parent, factory, context);
        this.functionEnvironment = parent.function();
        this.lexicalDeclarations = EconomicMap.create();
        this.varDeclarations = EconomicMap.create();
    }

    @Override
    public FunctionEnvironment function() {
        return this.functionEnvironment;
    }

    @Override
    public FrameSlot findBlockFrameSlot(String name) {
        return null;
    }

    @Override
    public FrameDescriptor getBlockFrameDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FrameSlot[] getParentSlots() {
        return ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY;
    }

    public boolean addLexicalDeclaration(String name, boolean isConst) {
        return this.lexicalDeclarations.put((Object)name, (Object)isConst) == null;
    }

    public boolean hasLexicalDeclaration(String name) {
        return this.lexicalDeclarations.containsKey((Object)name);
    }

    public boolean hasConstDeclaration(String name) {
        return (Boolean)this.lexicalDeclarations.get((Object)name, (Object)Boolean.FALSE);
    }

    public boolean addVarDeclaration(String name) {
        return this.varDeclarations.put((Object)name, (Object)Boolean.FALSE) == null;
    }

    public boolean hasVarDeclaration(String name) {
        return this.varDeclarations.containsKey((Object)name);
    }

    public static boolean isGlobalObjectConstant(String name) {
        switch (name) {
            case "undefined": 
            case "NaN": 
            case "Infinity": {
                return true;
            }
        }
        return false;
    }
}

