/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.BreakTarget;
import com.oracle.truffle.js.nodes.control.ContinueTarget;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class FunctionEnvironment
extends Environment {
    private static final String RETURN_SLOT_IDENTIFIER = "<return>";
    static final String ARGUMENTS_SLOT_IDENTIFIER = "<arguments>";
    static final String THIS_SLOT_IDENTIFIER = "<this>";
    static final String SUPER_SLOT_IDENTIFIER = "<super>";
    static final String NEW_TARGET_SLOT_IDENTIFIER = "<new.target>";
    static final String YIELD_VALUE_SLOT_IDENTIFIER = "<yieldvalue>";
    static final String ASYNC_CONTEXT_SLOT_IDENTIFIER = "<asynccontext>";
    static final String ASYNC_RESULT_SLOT_IDENTIFIER = "<asyncresult>";
    private static final String YIELD_RESULT_SLOT_IDENTIFIER = "<yieldresult>";
    static final String DYNAMIC_SCOPE_IDENTIFIER = "<evalscope>";
    private final FunctionEnvironment parent;
    private final FrameDescriptor frameDescriptor;
    private final List<FrameSlot> parameters;
    private final boolean isStrictMode;
    private FrameSlot argumentsSlot;
    private FrameSlot returnSlot;
    private FrameSlot thisSlot;
    private FrameSlot superSlot;
    private FrameSlot newTargetSlot;
    private FrameSlot dynamicScopeSlot;
    private String functionName = "";
    private String internalFunctionName = "";
    private boolean isNamedExpression;
    private boolean needsParentFrame;
    private boolean frozen;
    private int breakNodeCount;
    private int continueNodeCount;
    private boolean hasReturn;
    private boolean hasYield;
    private boolean hasAwait;
    private List<BreakTarget> jumpTargetStack;
    private boolean directArgumentsAccess;
    private final boolean isGlobal;
    private final boolean isEval;
    private final boolean isDirectEval;
    private final boolean isArrowFunction;
    private final boolean isGeneratorFunction;
    private final boolean isDerivedConstructor;
    private final boolean isAsyncFunction;
    private boolean hasRestParameter;
    private boolean simpleParameterList = true;
    private boolean isDynamicallyScoped;
    private final boolean inDirectEval;

    public FunctionEnvironment(Environment parent, NodeFactory factory, JSContext context, boolean isStrictMode, boolean isEval, boolean isDirectEval, boolean isArrowFunction, boolean isGeneratorFunction, boolean isDerivedConstructor, boolean isAsyncFunction, boolean isGlobal) {
        super(parent, factory, context);
        this.isDirectEval = isDirectEval;
        this.isAsyncFunction = isAsyncFunction;
        this.isStrictMode = isStrictMode;
        this.isEval = isEval;
        this.isArrowFunction = isArrowFunction;
        this.isGeneratorFunction = isGeneratorFunction;
        this.isDerivedConstructor = isDerivedConstructor;
        this.isGlobal = isGlobal;
        this.parent = parent == null ? null : parent.function();
        this.frameDescriptor = factory.createFrameDescriptor();
        this.parameters = new ArrayList<FrameSlot>();
        this.inDirectEval = isDirectEval || parent != null && parent.function() != null && parent.function().inDirectEval();
    }

    @Override
    public FunctionEnvironment function() {
        return this;
    }

    @Override
    public FrameSlot declareLocalVar(Object name) {
        return this.getFunctionFrameDescriptor().findOrAddFrameSlot(name, FrameSlotKind.Illegal);
    }

    @Override
    public FrameSlot declareVar(Object name) {
        if (this.isCallerContextEval()) {
            return this.getParentFunction().declareVar(name);
        }
        if (this.frozen && this.getFunctionFrameDescriptor().findFrameSlot(name) == null) {
            throw FunctionEnvironment.errorFrozenEnv();
        }
        return this.declareLocalVar(name);
    }

    public FrameSlot reserveArgumentsSlot() {
        if (this.argumentsSlot == null) {
            this.argumentsSlot = this.declareVar(ARGUMENTS_SLOT_IDENTIFIER);
        }
        return this.argumentsSlot;
    }

    public FrameSlot getReturnSlot() {
        if (this.returnSlot == null) {
            this.returnSlot = this.declareLocalVar(RETURN_SLOT_IDENTIFIER);
        }
        return this.returnSlot;
    }

    public void reserveThisSlot() {
        if (this.thisSlot == null) {
            this.thisSlot = this.declareVar(THIS_SLOT_IDENTIFIER);
        }
    }

    public void reserveNewTargetSlot() {
        if (this.newTargetSlot == null) {
            this.newTargetSlot = this.declareVar(NEW_TARGET_SLOT_IDENTIFIER);
        }
    }

    public FrameSlot getAsyncResultSlot() {
        return this.declareLocalVar(ASYNC_RESULT_SLOT_IDENTIFIER);
    }

    public FrameSlot getAsyncContextSlot() {
        return this.declareLocalVar(ASYNC_CONTEXT_SLOT_IDENTIFIER);
    }

    public FrameSlot getYieldResultSlot() {
        return this.declareLocalVar(YIELD_RESULT_SLOT_IDENTIFIER);
    }

    public FrameSlot getThisSlot() {
        return this.thisSlot;
    }

    public FrameSlot reserveDynamicScopeSlot() {
        if (this.dynamicScopeSlot == null) {
            this.dynamicScopeSlot = this.declareLocalVar(DYNAMIC_SCOPE_IDENTIFIER);
        }
        return this.dynamicScopeSlot;
    }

    public boolean isEval() {
        return this.isEval;
    }

    public boolean isArrowFunction() {
        return this.isArrowFunction;
    }

    public boolean isGeneratorFunction() {
        return this.isGeneratorFunction;
    }

    @Override
    protected FrameSlot findBlockFrameSlot(String name) {
        return this.getFunctionFrameDescriptor().findFrameSlot((Object)name);
    }

    @Override
    public boolean hasLocalVar(String name) {
        return this.getFunctionFrameDescriptor().getIdentifiers().contains(name);
    }

    private <T extends BreakTarget> T pushJumpTarget(T target) {
        if (this.jumpTargetStack == null) {
            this.jumpTargetStack = new ArrayList<BreakTarget>(4);
        }
        this.jumpTargetStack.add(target);
        return target;
    }

    private void popJumpTarget(BreakTarget target) {
        assert (this.jumpTargetStack != null && this.jumpTargetStack.get(this.jumpTargetStack.size() - 1) == target);
        this.jumpTargetStack.remove(this.jumpTargetStack.size() - 1);
    }

    public JumpTargetCloseable<ContinueTarget> pushContinueTarget(Object label) {
        ContinueTarget target = ContinueTarget.forLoop(label, -1);
        this.pushJumpTarget(target);
        return new JumpTargetCloseable(this, (BreakTarget)target);
    }

    public JumpTargetCloseable<BreakTarget> pushBreakTarget(Object label) {
        BreakTarget target = label == null ? BreakTarget.forSwitch() : BreakTarget.forLabel(label, -1);
        this.pushJumpTarget(target);
        return new JumpTargetCloseable(this, target);
    }

    public BreakTarget findBreakTarget(Object label) {
        ++this.breakNodeCount;
        return this.findJumpTarget(label, BreakTarget.class, true);
    }

    public ContinueTarget findContinueTarget(Object label) {
        ++this.continueNodeCount;
        return this.findJumpTarget(label, ContinueTarget.class, false);
    }

    private <T extends BreakTarget> T findJumpTarget(Object label, Class<T> targetClass, boolean direct) {
        BreakTarget applicableTarget = null;
        ListIterator<BreakTarget> iterator = this.jumpTargetStack.listIterator(this.jumpTargetStack.size());
        while (iterator.hasPrevious()) {
            BreakTarget target = iterator.previous();
            if (direct || label == null) {
                if (label != null && !label.equals(target.getLabel()) || !targetClass.isInstance(target)) continue;
                return (T)((BreakTarget)targetClass.cast(target));
            }
            assert (!direct);
            if (targetClass.isInstance(target)) {
                applicableTarget = (BreakTarget)targetClass.cast(target);
            }
            if (!label.equals(target.getLabel())) continue;
            assert (applicableTarget != null) : "Illegal or duplicate label";
            return (T)applicableTarget;
        }
        throw new NoSuchElementException("jump target not found");
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public void addReturn() {
        this.hasReturn = true;
    }

    public boolean hasAwait() {
        return this.hasAwait;
    }

    public void addAwait() {
        this.hasAwait = true;
    }

    public boolean hasYield() {
        return this.hasYield;
    }

    public void addYield() {
        this.hasYield = true;
    }

    public void setDirectArgumentsAccess(boolean directArgumentsAccess) {
        this.directArgumentsAccess = directArgumentsAccess;
    }

    public boolean isDirectArgumentsAccess() {
        return this.directArgumentsAccess;
    }

    public final int getParameterCount() {
        return this.parameters.size();
    }

    public final List<FrameSlot> getParameters() {
        return this.parameters;
    }

    public final void declareParameter(String name) {
        this.parameters.add(this.declareLocalVar(name));
    }

    protected final boolean isParam(FrameSlot slot) {
        return this.parameters.contains(slot);
    }

    protected final int getParameterIndex(FrameSlot slot) {
        for (int i = this.parameters.size() - 1; i >= 0; --i) {
            if (this.parameters.get(i) != slot) continue;
            return i;
        }
        return -1;
    }

    public final boolean isParameter(String name) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!name.equals(this.parameters.get(i).getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public final String getFunctionName() {
        return this.functionName;
    }

    public final void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public final String getInternalFunctionName() {
        return this.internalFunctionName;
    }

    public final void setInternalFunctionName(String internalFunctionName) {
        this.internalFunctionName = internalFunctionName;
    }

    public final void setNamedFunctionExpression(boolean isNamedExpression) {
        this.isNamedExpression = isNamedExpression;
    }

    protected final boolean isNamedFunctionExpression() {
        return this.isNamedExpression;
    }

    public final boolean needsParentFrame() {
        return this.needsParentFrame;
    }

    public final void setNeedsParentFrame(boolean needsParentFrame) {
        if (this.frozen && needsParentFrame != this.needsParentFrame) {
            throw FunctionEnvironment.errorFrozenEnv();
        }
        this.needsParentFrame = needsParentFrame;
    }

    private static RuntimeException errorFrozenEnv() {
        return new IllegalStateException("frozen function environment cannot be mutated");
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isDeepFrozen() {
        return this.isFrozen() && (this.getParentFunction() == null || this.getParentFunction().isDeepFrozen());
    }

    public final boolean hasArgumentsSlot() {
        return this.argumentsSlot != null;
    }

    protected final FrameSlot getArgumentsSlot() {
        return this.argumentsSlot;
    }

    @Override
    public final FrameDescriptor getFunctionFrameDescriptor() {
        return this.frameDescriptor;
    }

    @Override
    public final boolean isStrictMode() {
        return this.isStrictMode;
    }

    public final FunctionEnvironment getParentFunction() {
        return this.parent;
    }

    public final FunctionEnvironment getParentFunction(int level) {
        assert (level >= 0);
        if (level == 0) {
            return this;
        }
        return this.parent.getParentFunction(level - 1);
    }

    public final FunctionEnvironment getNonArrowParentFunction() {
        if (this.isArrowFunction() || this.isDirectEval()) {
            return this.getParentFunction().getNonArrowParentFunction();
        }
        return this;
    }

    @Override
    public FrameSlot[] getParentSlots() {
        return ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean returnsLastStatementResult() {
        return this.isGlobal() || this.isDirectEval();
    }

    public void setIsDynamicallyScoped(boolean isDynamicallyScoped) {
        this.isDynamicallyScoped = isDynamicallyScoped;
    }

    @Override
    public boolean isDynamicallyScoped() {
        return this.isDynamicallyScoped;
    }

    @Override
    public boolean isDynamicScopeContext() {
        return this.isDynamicallyScoped() || this.isCallerContextEval() || super.isDynamicScopeContext();
    }

    @Override
    public Environment getVariableEnvironment() {
        if (this.isCallerContextEval()) {
            return this.getParentFunction().getVariableEnvironment();
        }
        return this;
    }

    public boolean isDirectEval() {
        return this.isDirectEval;
    }

    public boolean isIndirectEval() {
        return this.isEval() && !this.isDirectEval();
    }

    public boolean isCallerContextEval() {
        return this.isDirectEval() && !this.isStrictMode() && !this.isGlobal();
    }

    public boolean inDirectEval() {
        return this.inDirectEval;
    }

    public void reserveSuperSlot() {
        if (this.superSlot == null) {
            this.superSlot = this.declareVar(SUPER_SLOT_IDENTIFIER);
        }
    }

    public FrameSlot getSuperSlot() {
        return this.superSlot;
    }

    public FrameSlot getNewTargetSlot() {
        return this.newTargetSlot;
    }

    public void setRestParameter(boolean restParameter) {
        this.hasRestParameter = restParameter;
    }

    public boolean hasRestParameter() {
        return this.hasRestParameter;
    }

    public void setSimpleParameterList(boolean simpleParameterList) {
        this.simpleParameterList = simpleParameterList;
    }

    public boolean hasSimpleParameterList() {
        return this.simpleParameterList;
    }

    public int getLeadingArgumentCount() {
        return this.getNewTargetSlot() != null ? 1 : 0;
    }

    public int getTrailingArgumentCount() {
        return 0;
    }

    public boolean isDerivedConstructor() {
        return this.isDerivedConstructor;
    }

    public int getThisFunctionLevel() {
        int level = 0;
        FunctionEnvironment currentFunction = this;
        while (currentFunction.isArrowFunction() || currentFunction.isDirectEval()) {
            currentFunction.setNeedsParentFrame(true);
            currentFunction = currentFunction.getParentFunction();
            ++level;
        }
        return level;
    }

    public int getOutermostFunctionLevel() {
        int level = 0;
        FunctionEnvironment currentFunction = this;
        while (currentFunction.getParentFunction() != null) {
            currentFunction.setNeedsParentFrame(true);
            currentFunction = currentFunction.getParentFunction();
            ++level;
        }
        return level;
    }

    public boolean isAsyncFunction() {
        return this.isAsyncFunction;
    }

    public boolean isAsyncGeneratorFunction() {
        return this.isAsyncFunction && this.isGeneratorFunction;
    }

    public static class JumpTargetCloseable<T extends BreakTarget>
    implements AutoCloseable {
        private final T target;
        private final int prevBreakCount;
        private final int prevContinueCount;
        final /* synthetic */ FunctionEnvironment this$0;

        protected JumpTargetCloseable(T target) {
            this.this$0 = this$0;
            this.prevBreakCount = this.this$0.breakNodeCount;
            this.prevContinueCount = this.this$0.continueNodeCount;
            this.target = target;
        }

        public T getTarget() {
            return this.target;
        }

        @Override
        public void close() {
            this.this$0.popJumpTarget(this.target);
        }

        private boolean hasBreak() {
            return this.this$0.breakNodeCount != this.prevBreakCount;
        }

        private boolean hasContinue() {
            return this.this$0.continueNodeCount != this.prevContinueCount;
        }

        public JavaScriptNode wrapContinueTargetNode(JavaScriptNode child) {
            boolean hasContinue = this.hasContinue();
            return hasContinue ? this.this$0.factory.createContinueTarget(child, (ContinueTarget)this.target) : child;
        }

        public JavaScriptNode wrapBreakTargetNode(JavaScriptNode child) {
            assert (((BreakTarget)this.target).getLabel() == null);
            boolean hasBreak = this.hasBreak();
            return hasBreak ? this.this$0.factory.createDirectBreakTarget(child) : child;
        }

        public JavaScriptNode wrapLabelBreakTargetNode(JavaScriptNode child) {
            assert (((BreakTarget)this.target).getLabel() != null);
            boolean hasBreak = this.hasBreak();
            return hasBreak ? this.this$0.factory.createLabel(child, (BreakTarget)this.target) : child;
        }
    }
}

