/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import java.util.Objects;

public abstract class ExportResolution {
    private static final ExportResolution NULL = new Null();
    private static final ExportResolution AMBIGUOUS = new Ambiguous();

    private ExportResolution() {
    }

    public boolean isNull() {
        return false;
    }

    public boolean isAmbiguous() {
        return false;
    }

    public boolean isNamespace() {
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord getModule() {
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public String getBindingName() {
        throw new UnsupportedOperationException();
    }

    public static ExportResolution resolved(JSModuleRecord module, String bindingName) {
        return new Resolved(module, bindingName);
    }

    public static ExportResolution notFound() {
        return NULL;
    }

    public static ExportResolution ambiguous() {
        return AMBIGUOUS;
    }

    private static class Ambiguous
    extends ExportResolution {
        private Ambiguous() {
        }

        @Override
        public boolean isAmbiguous() {
            return true;
        }
    }

    private static class Null
    extends ExportResolution {
        private Null() {
        }

        @Override
        public boolean isNull() {
            return true;
        }
    }

    private static class Resolved
    extends ExportResolution {
        private final JSModuleRecord module;
        private final String bindingName;

        Resolved(JSModuleRecord module, String bindingName) {
            this.module = module;
            this.bindingName = bindingName;
        }

        @Override
        public JSModuleRecord getModule() {
            return this.module;
        }

        @Override
        public String getBindingName() {
            return this.bindingName;
        }

        @Override
        public boolean isNamespace() {
            return this.bindingName.equals("*namespace*");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bindingName == null ? 0 : this.bindingName.hashCode());
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resolved other = (Resolved)obj;
            return Objects.equals(this.module, other.module) && Objects.equals(this.bindingName, other.bindingName);
        }
    }
}

