<?php
/*------------------------------------------------------------------------------
Copyright (c) 2004, 2005 thaler

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$Id$

You may retrieve the latest version of this file at the tsWebEditor home page,
located at http://tswebeditor.tigris.org

Known Issues:
------------------------------------------------------------------------------*/

// Exit Status Code
// 0 - No Errors
// 1 - Hints
// 2 - Errors

error_reporting(E_ALL);

if(version_compare(PHP_VERSION, '5.0.4', '<')) {
  print "- You need PHP Version 5.0.4 or newer.\n";
  exit(2);
}

if($argc < 3) {
  print "- Not enought parameters.\n";
  exit(2);
}


$action = strtolower($argv[1]);
$dbsys = strtolower($argv[2]);

if(!file_exists($dbsys . '.db.class.php')) {
  print '- Library for Database ' . $dbsys . ' not found !';
  exit(2);
}

$properties = array();

for($i = 3; $i < $argc; $i++) {
  $p = strpos($argv[$i], '=');
  
  if($p === false) {
    print $argv[$i] . ' is not a valid parameter';
    continue;
  }
  
  $properties[substr($argv[$i], 0, $p)] = substr($argv[$i], $p + 1);
}

include 'base.class.php';

try
{
  include $dbsys . '.db.class.php';
  $db = new $dbsys($properties);

  switch($action) {
    case 'test':
      $db->testConnection();
      break;
    case 'import':
      $ObjList = new ObjList();
      $db->ImportDB($ObjList, null);

      $xml = new DOMDocument('1.0', 'iso-8859-1');
      $root = $xml->appendChild(new DOMElement('sqldesigner'));

      $ObjList->SaveToXml($root);
    
      $xml->save($db->getProp('file'));

      break;
    case 'genddl':
      print '  Loading new Database Model ...' . "\n";

      $xml = new DOMDocument('1.0', 'iso-8859-1');
      $xml->preserveWhiteSpace = false;
      $xml->load($db->getProp('file'));
      $root = $xml->getElementsByTagName('sqldesigner')->item(0);

      $ObjList = new ObjList();
      $ObjList->LoadFromXml($root);

      print '  Ready.' . "\n";
      
      $DataDict = new ObjList();
      $db->ImportDB($DataDict, null);

      $ddl = array();
      $db->GenerateDDL($DataDict, $ObjList, $ddl);
    
      if($db->getProp('sql') != '') {
        file_put_contents($db->getProp('sql'), implode(CRLF . CRLF, $ddl));
        
        /*$xml = new DOMDocument('1.0', 'iso-8859-1');
        $root = $xml->appendChild(new DOMElement('sql'));

        foreach($ddl as $sql) {
          $e = new DOMElement('sql');
          $cdata = new DOMCdataSection($sql);
          $xml->appendChild($e);
          $e->appendChild($cdata);
          $root->appendChild($e);
        }
        $xml->save($db->getProp('sql'));*/
      } else
        print_r($ddl);

      break;
    case 'exeddl':
      $sql = file_get_contents($db->getProp('sql'));
    
      $db->ExecuteDDL($sql);

      break;
    case 'tst':
      $ObjList = new ObjList();
      $db->ImportDB($ObjList, null);

      $xml = new DOMDocument('1.0', 'iso-8859-1');
      $root = $xml->appendChild(new DOMElement('sqldesigner'));

      $ObjList->SaveToXml($root);


      $xml->save('D:\test.txt');
    

      $ObjList2 = new ObjList();

      $xml = new DOMDocument('1.0', 'iso-8859-1');
      $xml->preserveWhiteSpace = false;
      $xml->load('D:\test.txt');
      $root = $xml->getElementsByTagName('sqldesigner')->item(0);

      $ObjList2->LoadFromXml($root);
    
      $xml = new DOMDocument('1.0', 'iso-8859-1');
      $root = $xml->appendChild(new DOMElement('sqldesigner'));

      $ObjList2->SaveToXml($root);

      $xml->save('D:\test2.txt');
  
      break;
    
    default:
      print 'Action ' . $action . ' unkown.';
  }
} catch (Exception $e) {
  print CRLF;
  print '- ERROR: ' . $e->getMessage();

  exit(2);
}

?>