<?php
/*
  Author: Greg Feigenson
  File: add_customer.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/

//header
require('includes/header.inc.php');
$error = "";

//title
echo "<div align='center'><h1>Add a customer</h1>";

//parse input
if ($_POST['submitted'] == 'yes')
	$errorlist = validate();

if(!$_POST['submitted'])
{}
//form is invalid
elseif ($errorlist)
	$error .= "<font color=red><B>Errors:</B><br>$errorlist</font>";
//form is valid, try and add
else
	$add = addCustomer();

//customer add failed
if ($add)
	$error .= "<font color=red><B>Errors:</B><br>$add</font>";
elseif(!$add && $_POST)
	$success = "<br><b>Customer added!</b>";


//print status
if ($error != "")
	echo $error;
else
	echo $success;

//print the form
printCustomerForm();

echo "</div>";

//footer
require('includes/footer.inc.php');



//
// Functions
//

function printCustomerForm()
{
      echo "<form name='input' action='add_customer.php' method='POST'>
       <br><br>

	   <input type='hidden' name='submitted' value='yes'>

       <table border=1>
       
       <tr><td>*First Name*:</td>
       <td><input type='text' name='first_name' value={$_POST['first_name']}></td></tr>

       <tr><td>*Last Name*:</td>
       <td><input type='text' name='last_name' value={$_POST['last_name']}></td></tr>
       
       <tr><td>Email:</td>
       <td><input type='text' name='email' value={$_POST['email']}></td></tr>

       <tr><td>*City*:</td>
       <td><input type='text' name='city' value={$_POST['city']}></td></tr>

       <tr><td>*Zipcode*:</td>
       <td><input type='text' name='zip' value={$_POST['zip']}></td></tr>

       <tr><td>*Street Address 1*:</td>
       <td><input type='text' name='street1' value={$_POST['street1']}></td></tr>

       <tr><td>Street Address 2:</td>
       <td><input type='text' name='street2' value={$_POST['street2']}></td></tr>

       <tr><td>*Phone1*:</td>
       <td><input type='text' name='phone1' value={$_POST['phone1']}></td></tr>

       <tr><td>Phone2:</td>
       <td><input type='text' name='phone2' value={$_POST['phone2']}></td></tr>
       
       </table>

		<br><br>
       <input type='submit' value='Add customer'>

       </form>";
}

function validate()
{
	$error = "";

	//required fields
	$required = array('first_name','last_name','city','zip','street1','phone1');
	
	//make sure required fields are filled out
	foreach ($required as $rule)
	{
		if ($_POST[$rule] == "")
		{
			$error .= "$rule is not filled out<br>";
		}
	}

	//regex for checking phone and zip
	$zipregex = "/^\d{5}((-\d{4})?)$/"; //subcode optional
	$phoneregex = "/^\d{3}\D\d{3}\D\d{4}$/"; //area*3[sep]prefix*3[sep]number*4

	if ($_POST['zip'] != "" && !preg_match($zipregex,$_POST['zip']))
		$error .= "Invalid zipcode<br>";

	if ($_POST['phone1'] != "" && !preg_match($phoneregex,$_POST['phone1']))
		$error .= "Phone1 is invalid (syntax: areacode-prefix-number)<br>";

	if ($_POST['phone2'] != "" && !preg_match($phoneregex,$_POST['phone2']))
		$error .= "Phone2 is invalid (syntax: areacode-prefix-number)<br>";

	return $error;
}

function addCustomer()
{
	global $state;
	global $country;

	//make sure customer doesn't already exist
	$sql =	"SELECT count(customer_id) as numpeople ".
			"FROM customers ".
			"WHERE first_name = '{$_POST['first_name']}' AND last_name = '{$_POST['last_name']}'";

	include('includes/db.inc.php');

	$result = pg_exec($sql) or die("Query failed : " . pg_last_error());
	$result = pg_fetch_assoc($result);
	$numpeople = $result['numpeople'];

	if ($numpeople > 0)
		return "Customer already exists";

	$sql = "INSERT INTO customers(first_name,last_name,status,state,city,zip,street1,phone1,country";

	//Add optional fields
	if ($_POST['email'] != "")
		$sql .= ",email";
	if ($_POST['street2'] != "")
		$sql .= ",street2";
	if ($_POST['phone2'] != "")
		$sql .= ",phone2";

	$sql .= ") VALUES ('{$_POST['first_name']}','{$_POST['last_name']}',1,";
	$sql .= "'$state','{$_POST['city']}','{$_POST['zip']}','{$_POST['street1']}',";
	$sql .= "'{$_POST['phone1']}','$country'";

	//optional field values
	if ($_POST['email'] != "")
		$sql .= ",'{$_POST['email']}'";
	if ($_POST['street2'] != "")
		$sql .= ",'{$_POST['street2']}'";
	if ($_POST['phone2'] != "")
		$sql .= ",'{$_POST['phone2']}'";

	//add final )
	$sql .= ")";

	//Add customer
	$result = pg_exec($sql) or die("Query failed : " . pg_last_error());
}
?>
