/************************************************************************
 * functions.h native chemistry handling functions
 *
 * Copyright (c) 2004,2005 by Ernst-G. Schmid
 * Copyright (c) 2004,2005 by Bayer Business Services GmbH
 * for explicitly marked functions
 *
 * This file is part of the xchem::tigress project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * lesser GNU General Public License for more details.
 ************************************************************************/

#include "pgchem_config.h"

Datum pgchem_is_fp_ss_candidate (PG_FUNCTION_ARGS);
Datum pgchem_version (PG_FUNCTION_ARGS);
Datum pgchem_barsoi_version (PG_FUNCTION_ARGS);
Datum pgchem_validate_molfile (PG_FUNCTION_ARGS);
Datum pgchem_is_checkmol_molfile (PG_FUNCTION_ARGS);
Datum pgchem_is_nostruct (PG_FUNCTION_ARGS);
Datum pgchem_fg_fingerprint (PG_FUNCTION_ARGS);
Datum pgchem_match_substruct (PG_FUNCTION_ARGS);
Datum pgchem_match_exact (PG_FUNCTION_ARGS);
Datum pgchem_ms_fingerprint_long (PG_FUNCTION_ARGS);
Datum pgchem_ms_fingerprint_short (PG_FUNCTION_ARGS);
Datum pgchem_fgroup_codes (PG_FUNCTION_ARGS);
Datum pgchem_tweak_molecule (PG_FUNCTION_ARGS);
Datum pgchem_molecule_to_smiles (PG_FUNCTION_ARGS);
Datum pgchem_molecule_to_canonical_smiles (PG_FUNCTION_ARGS);
Datum pgchem_molecule_to_inchi (PG_FUNCTION_ARGS);
Datum pgchem_smiles_to_molecule (PG_FUNCTION_ARGS);
Datum pgchem_molecule_to_molfile (PG_FUNCTION_ARGS);
Datum pgchem_molfile_to_molecule (PG_FUNCTION_ARGS);
Datum pgchem_fingerprint2 (PG_FUNCTION_ARGS);
Datum pgchem_tanimoto (PG_FUNCTION_ARGS);
Datum pgchem_total_charge (PG_FUNCTION_ARGS);
Datum pgchem_num_atoms (PG_FUNCTION_ARGS);
Datum pgchem_num_heavy_atoms (PG_FUNCTION_ARGS);
Datum pgchem_num_bonds (PG_FUNCTION_ARGS);
Datum pgchem_num_rotatable_bonds (PG_FUNCTION_ARGS);
Datum pgchem_is_chiral (PG_FUNCTION_ARGS);
Datum pgchem_2D (PG_FUNCTION_ARGS);
Datum pgchem_3D (PG_FUNCTION_ARGS);
Datum pgchem_add_hydrogens (PG_FUNCTION_ARGS);
Datum pgchem_remove_hydrogens (PG_FUNCTION_ARGS);
Datum pgchem_strip_salts (PG_FUNCTION_ARGS);
Datum pgchem_V3000_to_molecule (PG_FUNCTION_ARGS);
Datum pgchem_molecule_to_V3000 (PG_FUNCTION_ARGS);
Datum pgchem_match_substruct_ob_a (PG_FUNCTION_ARGS);
Datum pgchem_match_substruct_ob_native_a (PG_FUNCTION_ARGS);

/***************************************************************
 * This function Copyright (c) 2005
 * by Bayer Business Services GmbH
 ***************************************************************/
Datum pgchem_molweight (PG_FUNCTION_ARGS);

/***************************************************************
 * This function Copyright (c) 2005
 * by Bayer Business Services GmbH
 ***************************************************************/
Datum pgchem_hillformula (PG_FUNCTION_ARGS);

/***************************************************************
 * This function Copyright (c) 2005
 * by Bayer Business Services GmbH
 ***************************************************************/
Datum pgchem_exactmass (PG_FUNCTION_ARGS);

/***************************************************************
 * This function Copyright (c) 2005
 * by Bayer Business Services GmbH
 ***************************************************************/
//Datum pgchem_check_small_fragment (PG_FUNCTION_ARGS);
/***************************************************************
 *  Accelerated functions from barsoi
 ***************************************************************/
Datum pgchem_match_exact_a (PG_FUNCTION_ARGS);
Datum pgchem_match_substruct_a (PG_FUNCTION_ARGS);
Datum pgchem_ms_fingerprint_long_a (PG_FUNCTION_ARGS);
Datum pgchem_ms_fingerprint_short_a (PG_FUNCTION_ARGS);
Datum pgchem_fgroup_codes_a (PG_FUNCTION_ARGS);
Datum pgchem_tweak_molecule_a (PG_FUNCTION_ARGS);

/***************************************************************
 * Experimental 'burst mode' functions with barsoi
 ***************************************************************/
/* Datum pgchem_fastmatch_set_exact_query_a (PG_FUNCTION_ARGS);
Datum pgchem_fastmatch_set_substructure_query_a (PG_FUNCTION_ARGS);
Datum pgchem_fastmatch_a (PG_FUNCTION_ARGS); */

#ifndef WIN32
Datum pgchem_lower_connection_priority(PG_FUNCTION_ARGS);
#endif

typedef struct {
    unsigned long long a; 
    unsigned long long b;
} DQWORD;   
