/**********************************************************************
 * functions.sql native chemistry handling functions SQL stubs
 *
 * Copyright (c) 2004,2007 by Ernst-G. Schmid
 *
 * This file is part of the pgchem::tigress project.
 * For more information, see
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 ************************************************************************/

CREATE OR REPLACE FUNCTION add_hydrogens(bytea, boolean, boolean)
  RETURNS bytea AS
'libpgchem', 'pgchem_add_hydrogens'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION exactmass(bytea)
  RETURNS double precision AS
'libpgchem', 'pgchem_exactmass'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION fgroup_codes(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_fgroup_codes_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION fingerprint2(bytea)
  RETURNS bytea AS
'libpgchem', 'pgchem_fingerprint2'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION tanimoto(bytea, bytea)
  RETURNS double precision AS
'libpgchem', 'pgchem_tanimoto'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION instant_tanimoto(bytea, bytea)
  RETURNS double precision AS
$BODY$
DECLARE tanimoto_value float8;
DECLARE fp1 bytea;
DECLARE fp2 bytea;
BEGIN

tanimoto_value=0.0;

fp1=fingerprint2($1);
fp2=fingerprint2($2);

tanimoto_value=tanimoto(fp1,fp2);

RETURN tanimoto_value;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_2d(bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_2D'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_3d(bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_3D'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_checkmol_molecule(bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_is_checkmol_molfile'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_chiral(bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_is_chiral'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_nostruct(bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_is_nostruct'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION match_exact(bytea, bytea, boolean, boolean, boolean, boolean, boolean, boolean)
  RETURNS boolean AS
'libpgchem', 'pgchem_match_exact_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION match_exact(bytea, bytea)
  RETURNS boolean AS
$BODY$
BEGIN
RETURN match_exact($1,$2,false,false,false,false,false,false);
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION match_substruct(bytea, bytea, boolean, boolean, boolean, boolean, boolean, boolean)
  RETURNS boolean AS
'libpgchem', 'pgchem_match_substruct_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION match_substruct(bytea, bytea)
  RETURNS boolean AS
$BODY$
BEGIN
RETURN match_substruct($1,$2,false,false,false,false,false,false);
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molecule_to_inchi(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_inchi'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molecule_to_canonical_smiles(bytea, boolean)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_canonical_smiles'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molecule_to_molfile(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_molfile'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molecule_to_smiles(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_smiles'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molecule_to_v3000(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_V3000'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molfile_to_molecule(text)
  RETURNS bytea AS
'libpgchem', 'pgchem_molfile_to_molecule'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molformula(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_hillformula'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molweight(bytea)
  RETURNS double precision AS
'libpgchem', 'pgchem_molweight'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molkeys_long(bytea, boolean, boolean, boolean)
  RETURNS text AS
'libpgchem', 'pgchem_ms_fingerprint_long_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molkeys_long(bytea)
  RETURNS text AS
$BODY$
BEGIN
RETURN molkeys_long($1,false,false,false);
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molkeys_short(bytea)
  RETURNS text AS
'libpgchem', 'pgchem_ms_fingerprint_short_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_atoms(bytea)
  RETURNS integer AS
'libpgchem', 'pgchem_num_atoms'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_bonds(bytea)
  RETURNS integer AS
'libpgchem', 'pgchem_num_bonds'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_heavy_atoms(bytea)
  RETURNS integer AS
'libpgchem', 'pgchem_num_heavy_atoms'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_rotatable_bonds(bytea)
  RETURNS integer AS
'libpgchem', 'pgchem_num_rotatable_bonds'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION pgchem_barsoi_version()
  RETURNS cstring AS
'libpgchem', 'pgchem_barsoi_version'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION pgchem_version()
  RETURNS cstring AS
'libpgchem', 'pgchem_version'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION remove_hydrogens(bytea, boolean)
  RETURNS bytea AS
'libpgchem', 'pgchem_remove_hydrogens'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION smiles_to_molecule(text)
  RETURNS bytea AS
'libpgchem', 'pgchem_smiles_to_molecule'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION match_substruct_smarts(text, bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_match_substruct_ob_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION match_substruct_smarts(text, text)
  RETURNS boolean AS
'libpgchem', 'pgchem_match_substruct_ob_native_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION strip_salts(bytea)
  RETURNS bytea AS
'libpgchem', 'pgchem_strip_salts'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION substruct_screen_fingerprint(bytea, bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_is_fp_ss_candidate'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION total_charge(bytea)
  RETURNS integer AS
'libpgchem', 'pgchem_total_charge'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION precompute_properties(bytea, boolean)
  RETURNS bytea AS
'libpgchem', 'pgchem_tweak_molecule_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION v3000_to_molecule(text)
  RETURNS bytea AS
'libpgchem', 'pgchem_V3000_to_molecule'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION validate_cas_no(character varying)
  RETURNS boolean AS
$BODY$
DECLARE checksum_from_cas_no varchar;
DECLARE cas_no_left varchar;
DECLARE cas_no_right varchar;
DECLARE cas_no_full varchar;
DECLARE tmpsum int;
DECLARE position_multiplier int;
DECLARE caslen int;
BEGIN
caslen:=length($1);

IF caslen<5 OR caslen>12 THEN RETURN FALSE;
END IF;

checksum_from_cas_no:=split_part($1,'-',3)::int;
cas_no_left:=split_part($1,'-',1);
cas_no_right:=split_part($1,'-',2);
cas_no_full:=cas_no_left || cas_no_right;

if(length(cas_no_left)>7 OR length(cas_no_right)>2 OR length(checksum_from_cas_no)!=1) THEN 
return false; 
END IF;

caslen:=length(cas_no_full);
tmpsum:=0;
position_multiplier:=1;

 FOR i IN REVERSE caslen..1 LOOP
  tmpsum:=tmpsum+substr(cas_no_full,i,1)::int*position_multiplier;
  position_multiplier:=position_multiplier+1;
 END LOOP;
 RETURN tmpsum % 10 = checksum_from_cas_no::int;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION validate_molecule(bytea)
  RETURNS boolean AS
'libpgchem', 'pgchem_validate_molfile'
  LANGUAGE 'c' IMMUTABLE STRICT;
