/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS XPg v 0.1                                                   
* Descripcion:
* Esta clase es la principal de la aplicacion. Se encarga de iniciar 
* la Interfaz Grafica, manejar los eventos de ratn y teclado para la interfaz 
* e instanciar las clases necesarias para realizar los diversas funciones 
* relacionadas con bases de datos.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*          Angela Sandobal  - angesand@libertad.univalle.edu.co     
*/

import java.util.Vector;
import java.util.Enumeration;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.text.DateFormat;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.JTextField;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import javax.swing.SwingConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.SwingUtilities;
import java.io.*;
import javax.swing.JTable;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import java.net.URL;

public class XPg extends JFrame implements ActionListener,SwingConstants,FocusListener,KeyListener,MouseListener {

 JFrame program; 
 JMenuBar menuX;       //Barra de menus desplegables 
 JToolBar iconBar;     //Barra de iconos
 JPanel Global;	       //Panel de contenido
 JSplitPane Ppal;      //Panel redimensionable grande entre el monitor de logs y la interfaz 
 JTextArea LogWin;     //Monitor de Eventos 
 DefaultTreeModel treeModel;                          
 DefaultMutableTreeNode top,category1,globalLeaf; //Nodos del Arbol de conexin 
 JTree tree;		 //HostTree de la estructura de la conexin a PostgreSQL
 JTabbedPane tabbedPane; //Carpetas donde se desplegar la informacin de tables, datos y queries
 PGConnection pgconn;   //Objeto de la clase PGConnection que maneja la conexion
 ConRegister online;     //Objeto de la clase ConRegister que define la estructura de datos de la conexion
 ChooseIdiom language;
 boolean connected = false;
 JSplitPane splitPpal; // Panel redimensionable entre el arbol de bases de datos y las carpetas
 JScrollPane treeView;
 DefaultTreeCellRenderer renderer;
 JButton connect,disconnect; //iconos de conexion
 JButton newDB, dropDB;      //icons de bases de datos
 JButton newTable,dropTable, dumpTable, changeIdiom; //iconos de tablas
 JMenu connection, dataBase, tables, query, admin, help, group, sub_user; //Menues desplegables
 JMenuItem connectItem,disconnectItem,exitItem,newDBItem,dropDBItem,sub_permi; //items de los Menues connection y dataBase
 JMenuItem newTableItem,dropTableItem,dumpTableItem,addFieldItem;    // items del JMenu tables
 JMenuItem editFieldItem,dropFieldItem,insertRecordItem,updateRecordItem,delRecordItem;// items del JMenu tables
 JMenuItem newGroupItem, alterGroupItem, dropGroupItem;
 JMenuItem newUserItem, alterUserItem, dropUserItem;
 JMenuItem grantItem, revokeItem;
 JMenuItem newQryItem,saveQryItem,openQryItem,hqItem,runQryItem,helpItem,aboutItem; //items de los JMenu query y help
 Language idiom;
 ConnectionWatcher guard;
 String ActiveDataB = "";
 String[] permissions;
 String xlanguage = "";
 String DBComponentName = "";   
 Vector vecConn = new Vector();
 Vector dbNames = new Vector();
 Structures panel1;
 Records panel2;
 Queries panel3;
 int ActivedTabbed = 2; 
 int OldCompType = -1;
 int numOldTables = 0;
 int DBComponentType = -1;
 Table currentTable;
 Vector indices;
 JPopupMenu popup,popupDB;
 String startDate = "";
 String OS = "";
 String configPath = "xpg.cfg";
 String xpgHome = "";

 /**
  * METODO CONSTRUCTOR public XPg()
  * Arma y ensambla los elementos de la interfaz grfica
  */
 public XPg() {		
  super("XPg - PostgreSQL GUI");   //Llama al mtodo de la clase padre (Frame) que espera como parmetro una cadena
  
  JPanel pe = new JPanel();
  pe.setLayout(new BorderLayout());
  URL gURL = getClass().getResource("icons/xpg.jpg");
  JLabel labelx = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(gURL)),JLabel.CENTER);
  pe.add(labelx,BorderLayout.CENTER);
  JWindow primero = new JWindow(XPg.this);
  primero.getContentPane().add(pe);
  primero.setSize(284, 312);
  primero.setLocation(188,114);
  primero.setVisible(true);

  ConfigFileReader readLang = new ConfigFileReader();
  OS = System.getProperty("os.name");
  xpgHome = System.getProperty("xpgHome");
  if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD")) 
     {
  	String UHome = System.getProperty("user.home") + System.getProperty("file.separator") + ".xpg";
  	File file = new File(UHome);
  	configPath = UHome + System.getProperty("file.separator") + "xpg.cfg"; 

  	if(!file.exists()) 
      		{
        	 file.mkdir();
                 file = new File(UHome + System.getProperty("file.separator") + "logs");
                 file.mkdir();
                 file = new File(UHome + System.getProperty("file.separator") + "queries");
                 file.mkdir();
                 file = new File(UHome + System.getProperty("file.separator") + "reports");
                 file.mkdir();
        	 readLang.Create_File(configPath);
      		}
         else
              readLang = new ConfigFileReader (configPath, 1);
     } 
  if(OS.startsWith("Windows"))
    {
      String home = xpgHome + System.getProperty("file.separator");
      configPath = home + "xpg.cfg";
      File file = new File(configPath);
      if(!file.exists())
          readLang.Create_File(configPath);
      else
          readLang = new ConfigFileReader (configPath, 1); 
      file = new File(home + System.getProperty("file.separator") + "logs");
      if(!file.exists())
         file.mkdir();
      file = new File(home + System.getProperty("file.separator") + "queries");
      if(!file.exists())
         file.mkdir();
      file = new File(home + System.getProperty("file.separator") + "reports");
      if(!file.exists())
         file.mkdir();
    } 

  //Leer del archivo de configuracin el idioma actual
  xlanguage = readLang.getIdiom();
  
  //Si actualmente no se guarda ningn idioma
  //mostrar ventana inicial para escoger idioma
  if (xlanguage.equals("none"))
   {  	
    language = new ChooseIdiom(XPg.this);
    language.pack();
    language.setLocationRelativeTo(XPg.this);
    language.show();			
    xlanguage = language.getIdiom();
    idiom = new Language(xlanguage);	
    writeFile(xlanguage);
   } 
  else
    idiom = new Language(xlanguage);

  getContentPane().setLayout(new BorderLayout());    // Parte el FRAME
  menuX = new JMenuBar();      //Se crea un nuevo objeto menu desplegable
  iconBar = new JToolBar(SwingConstants.HORIZONTAL); //Se crea un nuevo objeto barra de iconos
  iconBar.setFloatable(false); //Se hace la barra de iconos fija
  Global = new JPanel();   
  setJMenuBar(menuX);   // Aadiendo el menu desplegable al Frame
  CreateMenu();         // Se definen los componentes del menu desplegable		
  CreateToolBar();      // Se definen los componentes de los iconos de la ventana principal
  HostTree();   	//Crea el HostTree a desplegar
  Folders();	        //Crea los Folders a desplegar

  //cambiar los iconos por defecto del arbol
  renderer = new DefaultTreeCellRenderer();
  URL imgURL = getClass().getResource("icons/16_DB_Open.gif");
  renderer.setOpenIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  imgURL = getClass().getResource("icons/16_DB.gif");
  renderer.setClosedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  imgURL = getClass().getResource("icons/16_table.gif");
  renderer.setLeafIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));

  tree.setCellRenderer(renderer);

  //Crear un scroll pane y aade el arbol a este 
  treeView = new JScrollPane(tree);  

  //Crear el split pane aadiendo a la izq. el arbol y a la derecha las pestaas 
  splitPpal = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
  splitPpal.setLeftComponent(treeView);
  splitPpal.setRightComponent(tabbedPane);
  splitPpal.setOneTouchExpandable(true); //el SplitPane muestra controles que permiten al
                                         //usuario ocultar uno de los componentes y asignar todo el espacio al otro
  //Dar el tamao mnimo para los dos componentes del split pane
  treeView.setMinimumSize(new Dimension(100,400));
  treeView.setPreferredSize(new Dimension(200,400));
  tabbedPane.setMinimumSize(new Dimension(400,640));
  tabbedPane.setEnabled(false); //Deshabilitar las carpetas

  splitPpal.setDividerLocation(135); //Selecciona u obtiene la posicin actual del divisor.   
  splitPpal.setPreferredSize(new Dimension(200,400)); // Tamao preferido para el split pane
 
  //Armar el monitor de eventos 
  JButton upTitle = new JButton(idiom.getWord("LOGMON"));
  upTitle.setToolTipText(idiom.getWord("PRESSCL"));

  upTitle.addActionListener(new ActionListener() {
    public void actionPerformed(ActionEvent e) {
     int pi = Ppal.getDividerLocation();
     if(pi == 365) 
       Ppal.setDividerLocation(0);
     else 
       Ppal.setDividerLocation(365);
                                               }
  });
  JPanel downP = new JPanel();
  downP.setLayout(new BorderLayout());

  LogWin.setEditable(false);
  JScrollPane winCover = new JScrollPane(LogWin);
  downP.add(upTitle,BorderLayout.NORTH);
  downP.add(winCover,BorderLayout.CENTER);
 
  //Aade al panel Global al norte la barra de iconos y en el centro el split
  Global.setLayout(new BorderLayout());
  Global.add(iconBar,BorderLayout.NORTH);

  splitPpal.setMinimumSize(new Dimension(0,0));
  downP.setMinimumSize(new Dimension(0,25));

  Ppal = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
  Ppal.setOneTouchExpandable(true); //el SplitPane muestra controles
  Ppal.setTopComponent(splitPpal);
  Ppal.setBottomComponent(downP);
  Ppal.setDividerLocation(365);
  Global.add(Ppal,BorderLayout.CENTER);

  setBackground(Color.lightGray);//define el color de fondo para el Frame
  getContentPane().add("Center", Global);//Aade al Frame ppal el panel Global
  pack();
  setSize(680,560); //Tamao inicial del Frame
  setVisible(true); //mostrar el Frame
  primero.setVisible(false);
 }

 /** 
  * METODO public void CreateMenu()
  * Crea Menu desplegable 
  */
 public void CreateMenu(){
  JMenuItem Item ; //Crea un item (palabra) de un menu
	
  connection = new JMenu(idiom.getWord("CONNEC"));    //Crea el menu de conexin
  connection.setMnemonic(idiom.getNemo("NEMO-CONNEC"));
  menuX.add(connection);        //Adiciona el menu al menu desplegable

  dataBase = new JMenu(idiom.getWord("DB")); //Crea el menu de Base de Dato
  dataBase.setMnemonic(idiom.getNemo("NEMO-DB"));   //Establece un atajo
  menuX.add(dataBase);          //Adiciona el menu al menu desplegable

  tables = new JMenu (idiom.getWord("TABLE"));  //Crea un menu llamado Table
  tables.setMnemonic(idiom.getNemo("NEMO-TABLE"));     //Establece un atajo
  menuX.add(tables);            //Adiciona el menu al menu desplegable

  query = new JMenu(idiom.getWord("QUERY"));//Crea un menu llamado Query
  query.setMnemonic(idiom.getNemo("NEMO-QUERY"));    //Establece un atajo
  menuX.add(query);          //Adiciona el menu al menu desplegable

  admin = new JMenu(idiom.getWord("ADMIN"));//Crea un menu llamado admin
  admin.setMnemonic(idiom.getNemo("NEMO-ADMIN"));       //Establece un atajo
  menuX.add(admin);             //Adiciona el menu al menu desplegable

  help = new JMenu(idiom.getWord("HELP"));//Crea un menu llamado Help
  help.setMnemonic(idiom.getNemo("NEMO-HELP"));   //Establece un atajo
  menuX.add(help);         //Adiciona el menu al menu desplegable

  /*----------Items Menu connection----------*/
  URL imgURL = getClass().getResource("icons/16_connect.gif"); 
  connectItem = new JMenuItem(idiom.getWord("CONNE2"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  connectItem.setActionCommand("ItemConnect");
  connectItem.addActionListener(this);
  connection.add(connectItem);
  connectItem.setMnemonic(idiom.getNemo("NEMO-CONNE2")); 

  imgURL = getClass().getResource("icons/16_disconnect.gif");
  disconnectItem = new JMenuItem(idiom.getWord("DISCON"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  disconnectItem.setActionCommand("ItemDisconnect");
  disconnectItem.addActionListener(this);
  connection.add(disconnectItem);
  disconnectItem.setMnemonic(idiom.getNemo("NEMO-DISCON")); 
  disconnectItem.setEnabled(false);
  
  connection.addSeparator(); 
 
  imgURL = getClass().getResource("icons/16_exit.gif");  
  exitItem = new JMenuItem(idiom.getWord("EXIT"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  exitItem.setActionCommand("ItemExit");
  exitItem.addActionListener(this);
  connection.add(exitItem);
  exitItem.setMnemonic(idiom.getNemo("NEMO-EXIT")); 

  /*----------Items Menu Database ----------*/
  imgURL = getClass().getResource("icons/16_NewDB.gif");
  newDBItem = new JMenuItem(idiom.getWord("NEWF"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  newDBItem.setActionCommand("ItemCreateDB");
  newDBItem.addActionListener(this);
  dataBase.add(newDBItem);
  newDBItem.setMnemonic(idiom.getNemo("NEMO-NEWF")); 

  imgURL = getClass().getResource("icons/16_DropDB.gif");  
  dropDBItem = new JMenuItem(idiom.getWord("DROP"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  dropDBItem.setActionCommand("ItemDropDB");
  dropDBItem.addActionListener(this);
  dataBase.add(dropDBItem);
  dropDBItem.setMnemonic(idiom.getNemo("NEMO-DROP"));
 
  /*----------Items Menu Table----------*/
  imgURL = getClass().getResource("icons/16_NewTable.gif");
  newTableItem = new JMenuItem(idiom.getWord("NEWF"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  newTableItem.setActionCommand("ItemCreateTable");
  newTableItem.addActionListener(this);
  tables.add(newTableItem);
  newTableItem.setMnemonic(idiom.getNemo("NEMO-NEWF")); 

  imgURL = getClass().getResource("icons/16_DropTable.gif");
  dropTableItem = new JMenuItem(idiom.getWord("DROP"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  dropTableItem.setActionCommand("ItemDropTable");
  dropTableItem.addActionListener(this);
  tables.add(dropTableItem);
  dropTableItem.setMnemonic(idiom.getNemo("NEMO-DROP")); 
  
  imgURL = getClass().getResource("icons/16_Dump.gif");
  dumpTableItem = new JMenuItem(idiom.getWord("DUMP"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  dumpTableItem.setActionCommand("ItemDumpTable");
  dumpTableItem.addActionListener(this);
  tables.add(dumpTableItem);
  dumpTableItem.setMnemonic(idiom.getNemo("NEMO-DUMP"));

  imgURL = getClass().getResource("icons/16_Grant.gif");
  sub_permi = new JMenuItem(idiom.getWord("PERMI"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  sub_permi.setActionCommand("ItemGrant");
  sub_permi.addActionListener(this);
  tables.add(sub_permi);
  sub_permi.setMnemonic(idiom.getNemo("NEMO-PERMI"));

  /*----------Items Sub-Menu group----------*/
  group = new JMenu(idiom.getWord("GROUP"));

  imgURL = getClass().getResource("icons/16_NewGroup.gif");
  newGroupItem = new JMenuItem(idiom.getWord("CREATE"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  newGroupItem.setActionCommand("ItemCreateGroup");
  newGroupItem.addActionListener(this);
  group.add(newGroupItem);
  newGroupItem.setMnemonic(idiom.getNemo("NEMO-CREATE")); 

  imgURL = getClass().getResource("icons/16_AlterGroup.gif");
  alterGroupItem = new JMenuItem(idiom.getWord("ALTER"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  alterGroupItem.setActionCommand("ItemAlterGroup");
  alterGroupItem.addActionListener(this);
  group.add(alterGroupItem);
  alterGroupItem.setMnemonic(idiom.getNemo("NEMO-ALTER")); 

  imgURL = getClass().getResource("icons/16_DropGroup.gif");
  dropGroupItem = new JMenuItem(idiom.getWord("DROP"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  dropGroupItem.setActionCommand("ItemDropGroup");
  dropGroupItem.addActionListener(this);
  group.add(dropGroupItem);
  dropGroupItem.setMnemonic(idiom.getNemo("NEMO-DROP")); 

  admin.add(group);
  group.setMnemonic(idiom.getNemo("NEMO-GROUP")); 
  admin.addSeparator();

  /*----------Items Sub-Menu user----------*/
  sub_user = new JMenu(idiom.getWord("USER"));

  imgURL = getClass().getResource("icons/16_NewUser.gif");
  newUserItem = new JMenuItem(idiom.getWord("CREATE"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  newUserItem.setActionCommand("ItemCreateUser");
  newUserItem.addActionListener(this);
  sub_user.add(newUserItem);
  newUserItem.setMnemonic(idiom.getNemo("NEMO-CREATE")); 

  imgURL = getClass().getResource("icons/16_AlterUser.gif");
  alterUserItem = new JMenuItem(idiom.getWord("ALTER"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  alterUserItem.setActionCommand("ItemAlterUser");
  alterUserItem.addActionListener(this);
  sub_user.add(alterUserItem);
  alterUserItem.setMnemonic(idiom.getNemo("NEMO-ALTER")); 

  imgURL = getClass().getResource("icons/16_DropUser.gif");
  dropUserItem = new JMenuItem(idiom.getWord("DROP"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  dropUserItem.setActionCommand("ItemDropUser");
  dropUserItem.addActionListener(this);
  sub_user.add(dropUserItem);
  dropUserItem.setMnemonic(idiom.getNemo("NEMO-DROP")); 

  admin.add(sub_user);
  sub_user.setMnemonic(idiom.getNemo("NEMO-USER")); 

  /*----------Items Menu query----------*/
  imgURL = getClass().getResource("icons/16_new.gif");
  newQryItem = new JMenuItem(idiom.getWord("NEWF"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  newQryItem.setActionCommand("ItemCreateQry");
  newQryItem.addActionListener(this);
  query.add(newQryItem);
  newQryItem.setMnemonic(idiom.getNemo("NEMO-NEWF")); 

  imgURL = getClass().getResource("icons/16_Load.gif");
  openQryItem = new JMenuItem(idiom.getWord("OPEN"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  openQryItem.setActionCommand("ItemOpenQry");
  openQryItem.addActionListener(this);
  query.add(openQryItem);
  openQryItem.setMnemonic(idiom.getNemo("NEMO-OPEN")); 

  imgURL = getClass().getResource("icons/16_HQ.gif");
  hqItem = new JMenuItem(idiom.getWord("HQ"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  hqItem.setActionCommand("ItemHQ");
  hqItem.addActionListener(this);
  query.add(hqItem);
  hqItem.setMnemonic(idiom.getNemo("NEMO-HQ"));

  /*----------Items Menu help----------*/
  imgURL = getClass().getResource("icons/16_Help.gif");  
  helpItem = new JMenuItem(idiom.getWord("HELP"),new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL))); 
  helpItem.setActionCommand("ItemContenido");
  helpItem.addActionListener(this);
  help.add(helpItem);
  helpItem.setMnemonic(idiom.getNemo("NEMO-HELP2")); 
  
  help.addSeparator();
  
  aboutItem = new JMenuItem(idiom.getWord("ABOUT")+"..."); 
  aboutItem.setActionCommand("ItemAbout");
  aboutItem.addActionListener(this);
  help.add(aboutItem);
  aboutItem.setMnemonic(idiom.getNemo("NEMO-ABOUT"));  
  
  switchJMenus(false);
 }   

 /**
  * METODO CreateToolBar 
  * Crea Barra de Iconos 
  */            
 public void CreateToolBar() {

  JToolBar.Separator line1 = new JToolBar.Separator();
  JToolBar.Separator line2 = new JToolBar.Separator();
  JToolBar.Separator line3 = new JToolBar.Separator();
  /*------------ Botones Conexion ------------*/
  URL imgURL = getClass().getResource("icons/16_connect.gif");
  connect = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  connect.setActionCommand("ButtonConnect");
  connect.addActionListener(this);
  connect.setToolTipText(idiom.getWord("CONNE2"));
  iconBar.add(connect);

  imgURL = getClass().getResource("icons/16_disconnect.gif");
  disconnect = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  disconnect.setActionCommand("ButtonDisconnect");
  disconnect.addActionListener(this);
  disconnect.setToolTipText(idiom.getWord("DISCON"));
  iconBar.add(disconnect);
  disconnect.setEnabled(false);

  iconBar.add(line1); 
  /*------------ Botones Base de Datos ------------*/
  imgURL = getClass().getResource("icons/16_NewDB.gif");
  newDB = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  newDB.setActionCommand("ButtonNewDB");
  newDB.addActionListener(this);
  newDB.setToolTipText(idiom.getWord("NEWDB"));
  iconBar.add(newDB);
  newDB.setEnabled(false);
  
  imgURL = getClass().getResource("icons/16_DropDB.gif");
  dropDB = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  dropDB.setActionCommand("ButtonDropDB");
  dropDB.addActionListener(this);
  dropDB.setToolTipText(idiom.getWord("DROPDB"));
  iconBar.add(dropDB);
  dropDB.setEnabled(false);

  iconBar.add(line2); 
  /*------------ Botones Tabla ------------*/
  imgURL = getClass().getResource("icons/16_NewTable.gif");
  newTable = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  newTable.setActionCommand("ButtonNewTable");
  newTable.addActionListener(this);
  newTable.setToolTipText(idiom.getWord("NEWT"));
  iconBar.add(newTable);
  newTable.setEnabled(false);

  imgURL = getClass().getResource("icons/16_DropTable.gif");
  dropTable = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  dropTable.setActionCommand("ButtonDropTable");
  dropTable.addActionListener(this);
  dropTable.setToolTipText(idiom.getWord("DROPT"));
  iconBar.add(dropTable);
  dropTable.setEnabled(false);
  
  imgURL = getClass().getResource("icons/16_Dump.gif");
  dumpTable = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  dumpTable.setActionCommand("ButtonDumpTable");
  dumpTable.addActionListener(this);
  dumpTable.setToolTipText(idiom.getWord("DUMPT"));
  iconBar.add(dumpTable);
  dumpTable.setEnabled(false);
  
  iconBar.add(line3); 
  
  /*------------ Botones Lenguaje ------------*/
  imgURL = getClass().getResource("icons/16_Language.gif"); 
  changeIdiom = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  changeIdiom.setActionCommand("ButtonChangeLanguage");
  changeIdiom.addActionListener(this);
  changeIdiom.setToolTipText(idiom.getWord("CHANGE_L"));
  iconBar.add(changeIdiom);

 }

 /**
  * METODO actionPerformed
  * Manejador de Eventos para la barra de botones y el menu desplegable
  */
 public void actionPerformed(java.awt.event.ActionEvent e) {

  if(e.getActionCommand().equals("ItemRename")) {
     TreePath selPath = tree.getSelectionPath();
     DefaultMutableTreeNode node = (DefaultMutableTreeNode) selPath.getLastPathComponent();
     final String oldName = node.toString();     
     tree.setEditable(true);
     final JTextField rename = new JTextField();
     tree.setCellEditor(new DefaultCellEditor(rename));   
     tree.startEditingAtPath(selPath);
     rename.requestFocus();
     rename.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
          String newName = rename.getText();
          if(newName.indexOf(" ")!=-1)
            {
             rename.setText(oldName);
             JOptionPane.showMessageDialog(XPg.this,
             idiom.getWord("NOCHART"),
             idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
             return;
            } 
          newName = newName.toLowerCase();
          rename.setText(newName);
          String result = "";
          if(newName.length()==0) {
            TreePath selPath = tree.getSelectionPath();
            tree.startEditingAtPath(selPath);             
          } else {
            int index = dbNames.indexOf(ActiveDataB);
            PGConnection konn = (PGConnection) vecConn.elementAt(index);
            result = konn.SQL_Instruction("ALTER TABLE " + oldName + " RENAME TO " + newName);
            if(result.equals("OK")) { 
              DBComponentName = newName;
              String owner = konn.getOwner(newName);           
              panel1.setLabel(ActiveDataB,newName,owner);
              panel2.setLabel(ActiveDataB,newName,panel2.getNumRegs(),owner);
                                    } 
            else {
      	            result = result.substring(0,result.length()-1);
                    rename.setText(oldName);
                 }
  	  }
          addTextLogMonitor(idiom.getWord("EXEC") + "ALTER TABLE " + oldName + " RENAME TO " + newName + "\"");
          addTextLogMonitor(idiom.getWord("RES") + result);
	}
     });
     return;
  }

  if(e.getActionCommand().equals("ItemDelete")) {
    String buttonYes = idiom.getWord ("YES");
    String buttonNo  = idiom.getWord ("NO");
    String title = idiom.getWord("BOOLDELTB");
    String mess  =  idiom.getWord("MESGDELTB")+ DBComponentName + "?";
    BoolOption killtb = new BoolOption(XPg.this,buttonYes,buttonNo,title,mess);                                           
    killtb.pack();   
    killtb.setLocationRelativeTo(XPg.this);                                                                 
    killtb.show();                                                                    
    boolean sure = killtb.getSelecction(); 
    String result = "";
    if(sure) {                                                                                 
      int index = dbNames.indexOf(ActiveDataB);
      PGConnection konn = (PGConnection) vecConn.elementAt(index);
      result = konn.SQL_Instruction("DROP TABLE " + DBComponentName);
      if(result.equals("OK")) {   
          TreePath selPath = tree.getSelectionPath();
          DefaultMutableTreeNode currentNode =(DefaultMutableTreeNode) (selPath.getLastPathComponent());
          DefaultMutableTreeNode NodeDB =(DefaultMutableTreeNode) currentNode.getParent();
          treeModel.removeNodeFromParent(currentNode);
          if(NodeDB.getChildCount()==0) {
               DefaultMutableTreeNode nLeaf = new DefaultMutableTreeNode(idiom.getWord("NOTABLES"));
               NodeDB.add(nLeaf);
                                        }

                              } 
      else
          result = result.substring(0,result.length()-1);

      addTextLogMonitor(idiom.getWord("EXEC") + "DROP TABLE " + DBComponentName + "\"");
      addTextLogMonitor(idiom.getWord("RES") + result);
      tabbedPane.setSelectedIndex(2);
      tabbedPane.setEnabledAt(0,false);
      tabbedPane.setEnabledAt(1,false);
             }
    return;
  }  

  if (e.getActionCommand().equals("ItemDump")) 
   {
    String s = "file:" + System.getProperty("user.home");
    File file;
    boolean Rewrite = true;
    String FileName = "";
    JFileChooser fc = new JFileChooser(s);
    ExtensionFilter filter = new ExtensionFilter("sql",idiom.getWord("SQLF"));
    fc.addChoosableFileFilter(filter);

    int returnVal = fc.showDialog(XPg.this,idiom.getWord("SAVE"));

    if (returnVal == JFileChooser.APPROVE_OPTION)
      {
        file = fc.getSelectedFile();
        FileName = file.getAbsolutePath();
        if(file.exists())
          {
            BoolOption win = new BoolOption(XPg.this,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("ADV"),
            idiom.getWord("FILE") + " '" + FileName + "'" + idiom.getWord("SEQEXIS2") + " " + idiom.getWord("OVWR"));
            win.pack();
            win.setLocationRelativeTo(XPg.this);
            win.show();
            Rewrite = win.getSelecction();
          }

        if(Rewrite)
          {
           try 
            {
              int index = dbNames.indexOf(ActiveDataB);
              PGConnection konn = (PGConnection) vecConn.elementAt(index);
              String dataStr = createTableSQL(konn.getSpecStrucTable(DBComponentName));
              if(!FileName.endsWith(".sql"))
                FileName += ".sql";
              PrintStream sqlFile = new PrintStream(new FileOutputStream(FileName));
              sqlFile.print(dataStr);
              sqlFile.close();
            }
           catch(Exception ex) 
            {
              System.out.println("Error: " + ex);
              ex.printStackTrace();
            }
          }
      }
    return;
   }

  if (e.getActionCommand().equals("ItemExport")) {
    int index = dbNames.indexOf(ActiveDataB);
    PGConnection konn = (PGConnection) vecConn.elementAt(index);
    int regs = Count(DBComponentName,konn);
    addTextLogMonitor(idiom.getWord("EXEC") + "SELECT count(*) FROM " + DBComponentName + "\"");
    addTextLogMonitor(idiom.getWord("NUMR") + DBComponentName + "' : " + regs);

    if(regs > 100)
     {
      JOptionPane.showMessageDialog(XPg.this,
      idiom.getWord("LOTREG") + DBComponentName + idiom.getWord("LOTREG2"),
      idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
      return;
     }

    Vector result = konn.TableQuery("SELECT * FROM " + DBComponentName);
    Vector colnames = konn.TableHeader;
    String res = "";
    if(!konn.queryFail())
      res = "OK";
    else {
      res = konn.problem; 
      res = res.substring(0,res.length()-1);
         }
    addTextLogMonitor(idiom.getWord("EXEC") + "SELECT * FROM " + DBComponentName + "\"");
    addTextLogMonitor(idiom.getWord("RES") + res);
    ReportDesigner format = new ReportDesigner(XPg.this,colnames,result,idiom,LogWin,DBComponentName,konn);
    return;
  } 

  if (e.getActionCommand().equals("ItemExToFile")) {
    ExportSeparatorField little = new ExportSeparatorField(XPg.this,idiom);
    little.setSize(260,150);
    little.pack();
    little.setLocationRelativeTo(XPg.this);
    little.show();
    if(little.isDone()) {
                 String limiter = little.getLimiter();
                 String s = "file:" + System.getProperty("user.home");
                 File file;
                 boolean Rewrite = true;
                 String FileName = "";
                 JFileChooser fc = new JFileChooser(s);
                 int returnVal = fc.showDialog(XPg.this,idiom.getWord("EXPTO"));

                 if (returnVal == JFileChooser.APPROVE_OPTION) 
                   {
                     file = fc.getSelectedFile();
                     FileName = file.getAbsolutePath();
                     if(file.exists())
                       {
                         BoolOption win = new BoolOption(XPg.this,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("ADV"),
                         idiom.getWord("FILE") + " '" + FileName + "'" + idiom.getWord("SEQEXIS2") + " " + idiom.getWord("OVWR"));
                         win.pack();
                         win.setLocationRelativeTo(XPg.this);
                         win.show();
                         Rewrite = win.getSelecction();
                       }
                      if(Rewrite)
                         {
                           try {
                                int index = dbNames.indexOf(ActiveDataB);
                                PGConnection konn = (PGConnection) vecConn.elementAt(index);

                                Vector result = konn.TableQuery("SELECT * FROM " + DBComponentName);
                                Vector colnames = konn.TableHeader;
                                String res = "OK";
                                if(konn.queryFail()) {
                                   res = konn.problem;
                                   res = res.substring(0,res.length()-1);
                                                 }
                                addTextLogMonitor(idiom.getWord("EXEC") + "SELECT * FROM " + DBComponentName + "\"");
                                addTextLogMonitor(idiom.getWord("RES") + res);
                                Table structT = konn.getSpecStrucTable(DBComponentName);   
                                TableHeader TH = structT.base; 
                                PrintStream exportFile = new PrintStream(new FileOutputStream(FileName));
                                printFile(exportFile,result,colnames,limiter,TH);
                                }
                            catch(Exception ex) {  
                                                  System.out.println("Error: " + ex);        
                                                  ex.printStackTrace();
                                                }
                          }

                      }
                    }
    return;
  }

  if (e.getActionCommand().equals("ItemPopCloseDB")) {
    if(DBComponentName.equals(pgconn.getDBname()))
      {
       BoolOption killtb = new BoolOption(XPg.this,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("BOOLDISC"),idiom.getWord("WDIS"));
       killtb.pack();
       killtb.setLocationRelativeTo(XPg.this);
       killtb.show();
       boolean sure = killtb.getSelecction();
       if(sure)
          Disconnect();

       return;
      }

    int pos = dbNames.indexOf(DBComponentName);
    PGConnection pgTmp = (PGConnection) vecConn.remove(pos);
    pgTmp.close();
    dbNames.remove(pos);
    addTextLogMonitor(idiom.getWord("CLSDB") + DBComponentName + "'"); 
    Object raiz = treeModel.getRoot();
    int k = treeModel.getChildCount(raiz);
    for(int i=0;i<k;i++) {
                          Object o = treeModel.getChild(raiz,i);
                          if(DBComponentName.equals(o.toString())) {
                              treeModel.removeNodeFromParent((MutableTreeNode) o);
                              break;
                                                                   }
                          }
    return;
  } 

  if (e.getActionCommand().equals("ItemPopDeleteDB")) {
    if(DBComponentName.equals(pgconn.getDBname()))
      {
     JOptionPane.showMessageDialog(XPg.this,
     idiom.getWord("INVOP"),
     idiom.getWord("INFO"),JOptionPane.ERROR_MESSAGE);
     return;
       }

    String buttonYes = idiom.getWord ("YES");
    String buttonNo  = idiom.getWord ("NO");
    String title = idiom.getWord("BOOLDELTB");
    String mess  =  idiom.getWord("MESGDELDB")+ DBComponentName + "?";
    BoolOption killtb = new BoolOption(XPg.this,buttonYes,buttonNo,title,mess);
    killtb.pack();
    killtb.setLocationRelativeTo(XPg.this);
    killtb.show();
    boolean sure = killtb.getSelecction();
    if(sure)
      {
        int pos =  dbNames.indexOf(DBComponentName);
        PGConnection tempo = (PGConnection) vecConn.remove(pos);
        tempo.close();
        dbNames.remove(pos);
        //Eliminando BD
        String result = pgconn.SQL_Instruction("DROP DATABASE "+ DBComponentName);
        addTextLogMonitor(idiom.getWord("EXEC")+ "DROP DATABASE "+ DBComponentName + "\"");
        if (result.equals("OK")) 
         { 
            TreePath selPath = tree.getSelectionPath();
            DefaultMutableTreeNode currentNode =(DefaultMutableTreeNode) (selPath.getLastPathComponent());
            DefaultMutableTreeNode NodeDB =(DefaultMutableTreeNode) currentNode.getParent();
            treeModel.removeNodeFromParent(currentNode);
            addTextLogMonitor(idiom.getWord("RES")+ result);
          }
         else { 
          String tmp = result.substring(0,result.length()-1);
          addTextLogMonitor(idiom.getWord("RES")+ tmp);
          JOptionPane.showMessageDialog(XPg.this,idiom.getWord("ERRORPOS") + tmp,
                                        idiom.getWord("ERROR!"), JOptionPane.ERROR_MESSAGE);
              }

      } 
    return;
  }

  if (e.getActionCommand().equals("ItemPopDumpDB")) {
    int index = dbNames.indexOf(ActiveDataB);
    PGConnection dbDump = (PGConnection) vecConn.elementAt(index);

    int numTables = dbDump.getNumTables();
 
    if(numTables > 0)
     {
      DumpDb proto = new DumpDb(XPg.this,ActiveDataB,dbDump,idiom);
      proto.pack();
      proto.setLocationRelativeTo(XPg.this);
      proto.setVisible(true);

      if(proto.wellDone)
         addTextLogMonitor(idiom.getWord("DUMPT1") + proto.getTables() + idiom.getWord("DUMPT2") + proto.getDBName() + idiom.getWord("DUMPT3") + proto.getFile() + "'");

     }
    else
     {
      JOptionPane.showMessageDialog(XPg.this,idiom.getWord("TNTAB") + ActiveDataB + "'",
                                    idiom.getWord("INFO"), JOptionPane.INFORMATION_MESSAGE);
     }

    return;
  }

  /*------------ Evento Conexion --------------*/
  if (e.getActionCommand().equals("ItemConnect") 
          || e.getActionCommand().equals("ButtonConnect")) {    
      NConnect();
      return;
  }

  /*------------ Evento Desconectar --------------*/
  if(e.getActionCommand().equals("ItemDisconnect") 
          || e.getActionCommand().equals("ButtonDisconnect")) {       
     Disconnect();
     return;
  }

  /*------------ Evento Salir --------------*/
  if(e.getActionCommand().equals("ItemExit")) {                  
    if(connected) {
       BoolOption exitWin = new BoolOption(XPg.this,idiom.getWord("YES"),idiom.getWord ("NO"),idiom.getWord("BOOLEXIT"),idiom.getWord("MESGEXIT"));
       exitWin.pack();
       exitWin.setLocationRelativeTo(XPg.this);
       exitWin.show();
       boolean sure = exitWin.getSelecction();
       if(sure) 
        {
         SaveLog();
         pgconn.close();
         System.exit(0);
        }
       return;
    }
    else 
       System.exit(0);
         
  }
   
  /*------------ Evento Base de Datos ------------*/
  if(e.getActionCommand().equals("ItemCreateDB") 
         || e.getActionCommand().equals("ButtonNewDB")) {                  
    CreateDB newDB = new CreateDB(XPg.this, idiom, pgconn, LogWin);
    newDB.pack();
    newDB.setLocationRelativeTo(XPg.this);
    newDB.show();
    if(newDB.isDone()) {
      ConRegister tmp = new ConRegister(online.Hostname,newDB.getDBname(),online.Username,online.Password,online.Port);
      PGConnection proofConn = new PGConnection(tmp, idiom);
      if (!proofConn.Fail()) 
       {
        dbNames.add(newDB.getDBname());
        vecConn.add(proofConn);

        //Insertando nueva base de datos en el arbol
        DefaultMutableTreeNode dbLeaf = new DefaultMutableTreeNode(tmp.Database);
        DefaultMutableTreeNode noTables = new DefaultMutableTreeNode(idiom.getWord("NOTABLES")); 
	dbLeaf.add(noTables);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode) treeModel.getRoot();
        treeModel.insertNodeInto(dbLeaf, parent, 
                                 parent.getChildCount());
        JOptionPane.showMessageDialog(XPg.this,idiom.getWord("OKCREATEDB1")+
                                       tmp.Database + "\" \n" + idiom.getWord("OKCREATEDB2"),
                                       idiom.getWord("OK"),
                                       JOptionPane.INFORMATION_MESSAGE);
      } else {
        String msg = idiom.getWord("OKCREATEDB1") + tmp.Database + "\" " + idiom.getWord("OKCREATEDB2") + "\n" + idiom.getWord("NNACESS") + "\n" + idiom.getWord("NNCONTACT");
        JOptionPane.showMessageDialog(XPg.this,msg,
                                       idiom.getWord("INFO"),
                                       JOptionPane.INFORMATION_MESSAGE);
      }
    }
   return;
  }
  
  if(e.getActionCommand().equals("ItemDropDB") 
         || e.getActionCommand().equals("ButtonDropDB")) {
    //Formando el vector de las bases de datos de las cuales el usuario es propietario
    String sqlCmmd = "SELECT datname FROM pg_database WHERE datname != 'template1' AND datname != 'template0' AND datname != '" + online.getDatabase() + " ORDER by datname'";
    Vector DBNames = pgconn.TableQuery(sqlCmmd);
    addTextLogMonitor(idiom.getWord("EXEC") + sqlCmmd);

    if(DBNames.size() == 0)
     {
       JOptionPane.showMessageDialog(XPg.this,
       idiom.getWord("NDBS"),
       idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);

       return;
     }

    if(DBNames.size() == 1)
     {
      Vector o = (Vector) DBNames.elementAt(0);
      String db = (String) o.elementAt(0);
      if(db.equals(online.getDatabase())) 
       {
        JOptionPane.showMessageDialog(XPg.this,
        idiom.getWord("OIDBC"),
        idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);

        return;
       }
     }

    DropDB dropDB = new DropDB(XPg.this, idiom, DBNames);
    dropDB.pack();
    dropDB.setLocationRelativeTo(XPg.this);
    dropDB.show();

    //Si el usuario presiono el boton DROP 
    if (dropDB.confirmDropDB()) { 

       int pos=0;
       boolean inTree= false;

       if(dbNames.contains(dropDB.comboText)){ 
          inTree = true;
          pos = dbNames.indexOf(dropDB.comboText);
       }

       //Cerrar la conexion de la base de datos a borrar si existe
       if (inTree) { 
          PGConnection pgTmp = (PGConnection) vecConn.remove(pos);
          pgTmp.close();
          dbNames.remove(pos);
       }

       //Eliminando BD
       String result = pgconn.SQL_Instruction("DROP DATABASE "+ dropDB.comboText); 
       addTextLogMonitor(idiom.getWord("EXEC")+ "DROP DATABASE "+ dropDB.comboText + "\"");
       if (result.equals("OK")) {
          if (inTree) {
            Object raiz = treeModel.getRoot();
            int k = treeModel.getChildCount(raiz);
            for(int i=0;i<k;i++) {
              Object o = treeModel.getChild(raiz,i);
              if(dropDB.comboText.equals(o.toString())) {
                  treeModel.removeNodeFromParent((MutableTreeNode) o);
                  break;
                                                         }
                                  }
                       }
          addTextLogMonitor(idiom.getWord("RES")+ result);
          JOptionPane.showMessageDialog(XPg.this,idiom.getWord("OKDROPDB1")+
                                        dropDB.comboText + idiom.getWord("OKDROPDB2"),
                                        idiom.getWord("OK"),
                                        JOptionPane.INFORMATION_MESSAGE);

       } else { 
          String tmp = result.substring(0,result.length()-1);
          addTextLogMonitor(idiom.getWord("RES")+ tmp);
          JOptionPane.showMessageDialog(XPg.this,idiom.getWord("ERRORPOS") + tmp,
                                        idiom.getWord("ERROR!"),
                                        JOptionPane.ERROR_MESSAGE);
          
       }
    }
    return;
  }

  /*------------ Evento Tabla ------------*/
  if(e.getActionCommand().equals("ItemCreateTable") 
         || e.getActionCommand().equals("ButtonNewTable")) {                  
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    CreateTable winTable = new CreateTable(XPg.this, idiom, dbNames, vecConn, LogWin);
    winTable.pack();
    winTable.setLocationRelativeTo(XPg.this);  
    winTable.show();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    if(winTable.wellDone) {       
       Object raiz = treeModel.getRoot();
       int k = treeModel.getChildCount(raiz);
       for(int i=0;i<k;i++) {
         Object o = treeModel.getChild(raiz,i);
         if(winTable.dbn.equals(o.toString())) {
           Object[] lista = {raiz,o};
           TreePath rama = new TreePath(lista);

           if(tree.isExpanded(rama)) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode) rama.getLastPathComponent();
                    DefaultMutableTreeNode leaf = (DefaultMutableTreeNode) node.getFirstChild();
                    if(leaf.toString().startsWith(idiom.getWord("NOTABLES"))) {
                         treeModel.removeNodeFromParent((MutableTreeNode)leaf);
                       }
                    DefaultMutableTreeNode TLeaf = new DefaultMutableTreeNode(winTable.CurrentTable);
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode) o;
                    treeModel.insertNodeInto(TLeaf, parent, parent.getChildCount());
                    tree.expandPath(rama);
                                      }
                                                }
                              } 
                             }
    return;
  }

  if(e.getActionCommand().equals("ItemDropTable") 
         || e.getActionCommand().equals("ButtonDropTable")) {                  
    DropTable dT = new DropTable(XPg.this,dbNames,vecConn,idiom,LogWin);
    dT.pack();
    dT.setLocationRelativeTo(XPg.this);  
    dT.show();

    Vector delTables = dT.getDeletedTables();
    int size = delTables.size();
    int count = 0;

    while (!delTables.isEmpty()) {
      count++;
      String tableTarget = (String) delTables.remove(0); 
      Object root = treeModel.getRoot();
      int k = treeModel.getChildCount(root);

      for(int i=0;i<k;i++) {
        Object o = treeModel.getChild(root,i);

        if(dT.dbx.equals(o.toString())) {
          Object[] nodeList = {root,o};
          TreePath branch = new TreePath(nodeList);

          if(tree.isExpanded(branch)) {
	    int p = treeModel.getChildCount(o);

            for(int j=0;j<p;j++) {
              Object t = treeModel.getChild(o,j);

              if(tableTarget.equals(t.toString())) {
                TreePath selPath = tree.getSelectionPath(); 
                DefaultMutableTreeNode node = (DefaultMutableTreeNode) selPath.getLastPathComponent();
                if(count == size)
                 {
		  panel1.setNullTable();
                  panel1.setLabel("","","");	
                  panel2.setLabel("","",0,"");
                  panel1.activeToolBar(false);
                  panel1.activeIndexPanel(false);
                  tabbedPane.setEnabledAt(0,false);
                  tabbedPane.setEnabledAt(1,false);
                  tabbedPane.setSelectedIndex(2);
                  tree.setSelectionPath(branch);
                 }
                treeModel.removeNodeFromParent((MutableTreeNode)t);
                DefaultMutableTreeNode NodeDB =(DefaultMutableTreeNode) (branch.getLastPathComponent());
                if(NodeDB.getChildCount()==0) {
                   DefaultMutableTreeNode nLeaf = new DefaultMutableTreeNode(idiom.getWord("NOTABLES"));
                   NodeDB.add(nLeaf);
                                              }
                break;
              }
            }
          }
        }
      }//fin for 
    } //fin while delTables.isEmpty() 
    return;
  }

  if(e.getActionCommand().equals("ItemDumpTable")
         || e.getActionCommand().equals("ButtonDumpTable"))                   
   {          

    DumpTable proto = new DumpTable(XPg.this,dbNames,vecConn,idiom);
    proto.pack();
    proto.setLocationRelativeTo(XPg.this);
    proto.setVisible(true);

    if(proto.isDone())
      addTextLogMonitor(idiom.getWord("DUMPT1") + proto.getTables() + idiom.getWord("DUMPT2") + proto.getDBName() + idiom.getWord("DUMPT3") + proto.getFile() + "'");

    return;

   }    

  /*---------- Evento Consulta --------*/  
  if(e.getActionCommand().equals("ItemCreateQry")) 
   {
     int carpeta = tabbedPane.getSelectedIndex();

     if(carpeta != 2)
      {
       tabbedPane.setSelectedIndex(2);
       panel3.NewQuery();
      }

     return;
   }

  if(e.getActionCommand().equals("ItemOpenQry")) 
   {
     int carpeta = tabbedPane.getSelectedIndex();

     if(carpeta != 2)
       tabbedPane.setSelectedIndex(2);

     panel3.LoadQuery();

    return;
   }

  if(e.getActionCommand().equals("ItemHQ"))
   {
    HotQueries hotQ = new HotQueries(XPg.this,idiom);

    if (hotQ.isWellDone())
        panel3.loadSQL(hotQ.getSQL(),hotQ.isReady());

    return;
   }
 
 /* ---------------Evento Admin --------------*/
  if(e.getActionCommand().equals("ItemCreateUser")) {                  
    CreateUser cUser = new CreateUser(XPg.this, idiom, pgconn, LogWin);
    cUser.pack();
    cUser.setLocationRelativeTo(XPg.this);
    cUser.show();
    return;
  }

  if(e.getActionCommand().equals("ItemAlterUser")) {                  
    AlterUser aUser = new AlterUser(XPg.this, idiom, pgconn, LogWin);
    aUser.pack();
    aUser.setLocationRelativeTo(XPg.this);
    aUser.show();	     
    return;
  }

  if(e.getActionCommand().equals("ItemDropUser")) {                  
    DropUser dUser = new DropUser(XPg.this,idiom,pgconn,LogWin);
    dUser.pack();
    dUser.setLocationRelativeTo(XPg.this);
    dUser.show();	     
    return;
  }
  
  if(e.getActionCommand().equals("ItemCreateGroup")) {                  
    CreateGroup cGroup = new CreateGroup(XPg.this,idiom,pgconn,LogWin);
    cGroup.pack();
    cGroup.setLocationRelativeTo(XPg.this);
    cGroup.show();	     
    return;
  }

  if(e.getActionCommand().equals("ItemAlterGroup")) {                  

    String as[] = pgconn.getGroups();

    if(as.length == 0) {
       JOptionPane.showMessageDialog(XPg.this,
       idiom.getWord("NGRPS"),
       idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
     }
    else {
      AlterGroup aGroup = new AlterGroup(XPg.this,idiom,pgconn,LogWin);
      aGroup.pack();
      aGroup.setLocationRelativeTo(XPg.this);
      aGroup.show();	     
     }

    return;
  }

  if(e.getActionCommand().equals("ItemDropGroup")) {                  

    String as[] = pgconn.getGroups();

    if(as.length == 0) {
       JOptionPane.showMessageDialog(XPg.this,
       idiom.getWord("NGRPS"),
       idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
     }
    else {
      DropGroup dGroup = new DropGroup(XPg.this,idiom,pgconn,LogWin);
      dGroup.pack();
      dGroup.setLocationRelativeTo(XPg.this);
      dGroup.show();	     
     }

    return;
  }

  if(e.getActionCommand().equals("ItemGrant")) {
    int index = dbNames.indexOf(ActiveDataB);
    PGConnection konn = (PGConnection) vecConn.elementAt(index);

    String[] tb;
    if(permissions[1].equals("false")) 
       tb = konn.getTablesNames(true);
    else
       tb = konn.getTablesNames(false);

    if((tb.length < 1) && (!permissions[1].equals("true"))) 
       JOptionPane.showMessageDialog(XPg.this,
       idiom.getWord("NOTOW") + ActiveDataB + "'",
       idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
    else 
     {
       TablesGrant perm = new TablesGrant(XPg.this,idiom,konn,LogWin,tb);
       perm.pack();
       perm.setLocationRelativeTo(XPg.this);
       perm.show();
     }
    return;
  }

 /*------------ Evento Ayuda ------------*/
  if(e.getActionCommand().equals("ItemContenido")) {                  

   /*
    xpgHelp hlp = new xpgHelp(xpgHome); 
    hlp.pack();
    hlp.setLocationRelativeTo(XPg.this);
    hlp.setVisible(true); */

    JOptionPane.showMessageDialog(XPg.this,
    idiom.getWord("UIMO"),
    idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
    return;
  }

  if(e.getActionCommand().equals("ItemAbout")) {         
    JOptionPane tmp = new JOptionPane();
    URL imgURL = getClass().getResource("icons/logo.gif");
    tmp.showMessageDialog(XPg.this,
    "XPg "+ idiom.getWord("NUMVER") + "\n\n" + 
    idiom.getWord("COMP") + "28/07/2002\n" + idiom.getWord("CLTLIB")+
    idiom.getWord("PLATF")+ idiom.getWord("AUTORS"),idiom.getWord("TITABOUT"),JOptionPane.INFORMATION_MESSAGE,new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
    return;
  }  
   
  /*------------ Evento Lenguaje ------------*/
  if(e.getActionCommand().equals("ButtonChangeLanguage")) 
   {
    ChooseIdiomButton language = new ChooseIdiomButton(XPg.this, idiom, LogWin);
    language.pack();
    language.setLocationRelativeTo(XPg.this);
    language.show();
    if (language.getSave()) 
     {
      xlanguage = language.getIdiom();
      JOptionPane.showMessageDialog(XPg.this,idiom.getWord("NEXT_TIME"),                                  
      idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);                          
      writeFile(xlanguage);
     }
    return;
    }    

 }

 /**
  * METODO HostTree
  * Crea Arbol del Servidor
  */
 public void HostTree() {
  top = new DefaultMutableTreeNode(idiom.getWord("DSCNNTD"));
  category1 = new DefaultMutableTreeNode(idiom.getWord("NODB"));
  top.add(category1);

  tree = new JTree(top);
  tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
  tree.setCellRenderer(renderer);
  tree.collapseRow(0);

  popup = new JPopupMenu();
  JMenuItem Item = new JMenuItem(idiom.getWord("RNAME")); 
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemRename");
  Item.addActionListener(this);
  popup.add(Item);
  Item = new JMenuItem(idiom.getWord("DUMP")); 
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemDump");
  Item.addActionListener(this);
  popup.add(Item);
  Item = new JMenuItem(idiom.getWord("EXPORTAB"));
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemExToFile");
  Item.addActionListener(this);
  popup.add(Item);
  Item = new JMenuItem(idiom.getWord("EXPORREP")); 
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemExport");
  Item.addActionListener(this);
  popup.add(Item);
  Item = new JMenuItem(idiom.getWord("DROP")); 
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemDelete");
  Item.addActionListener(this);
  popup.add(Item);

  popupDB  = new JPopupMenu();

  Item = new JMenuItem(idiom.getWord("DUMP"));
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemPopDumpDB");
  Item.addActionListener(this);
  popupDB.add(Item);

  Item = new JMenuItem(idiom.getWord("CLOSE"));
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemPopCloseDB");
  Item.addActionListener(this);
  popupDB.add(Item);

  Item = new JMenuItem(idiom.getWord("DROP"));
  Item.setFont(new Font("Helvetica", Font.PLAIN, 10));
  Item.setActionCommand("ItemPopDeleteDB");
  Item.addActionListener(this);
  popupDB.add(Item);
 }

 /**
  * METODO Folders 
  * Crea Pestaas
  */
 public void Folders(){
  URL imgURL = getClass().getResource("icons/16_table.gif");
  ImageIcon iconTable = new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL));
  imgURL = getClass().getResource("icons/16_Datas.gif");
  ImageIcon iconRecord = new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL));
  imgURL = getClass().getResource("icons/16_SQL.gif"); 
  ImageIcon iconQuery = new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL));  
  tabbedPane = new JTabbedPane();

  LogWin = new JTextArea(5,0);

  panel1 = new Structures(XPg.this,idiom,LogWin);
  tabbedPane.addTab(idiom.getWord("TABLE"), iconTable, panel1, idiom.getWord("TABLE"));

  panel2 = new Records(idiom,XPg.this,LogWin);
  tabbedPane.addTab(idiom.getWord("RECS"), iconRecord, panel2, idiom.getWord("RECS"));

  SQLFunctionDataStruc[] fList = funcDataStruct();
  SQLFuncBasic[] fbasic = funcBasicStruct();
  panel3 = new Queries(XPg.this,idiom,LogWin,fList,fbasic);

  tabbedPane.addTab(idiom.getWord("QUERYS"), iconQuery, panel3, idiom.getWord("QUERYS"));
 }

 /**
  * METODO ReConfigFile 
  * Re-escribe el archivo de configuracion
  */
 public void ReConfigFile(ConRegister online,Vector ListRegs,int lastUsed) {
   ConRegister tmp = (ConRegister) ListRegs.elementAt(lastUsed);
   boolean noNew = true;
   int pos = lastUsed;

   if(!tmp.Hostname.equals(online.Hostname) 
           || !tmp.Username.equals(online.Username) || !tmp.Database.equals(online.Database)) {
     noNew = false;
     for(int i=0;i<ListRegs.size();i++) {
       if(i!=lastUsed) {
	   ConRegister element = (ConRegister) ListRegs.elementAt(i);
           if(element.Hostname.equals(online.Hostname) 
                   && element.Username.equals(online.Username) && element.Database.equals(online.Database)) {
	     noNew = true; 
	     pos = i;
	     break;
           }
       }
     }	
   }

   if(noNew) {
     new BuildConfigFile(ListRegs,pos,xlanguage);
   } else {
     new BuildConfigFile(ListRegs,online,xlanguage);
   }
 }
 
 /**
  * METODO switchJMenus
  */
 public void switchJMenus(boolean state) {
  dataBase.setEnabled(state);
  tables.setEnabled(state);
  query.setEnabled(state); 
  admin.setEnabled(state); 
 } 

 /**
  * METODO activeToolBar
  */
 public void activeToolBar(boolean state) {
  disconnect.setEnabled(state);
  if(permissions[0].equals("true") && state) {
    newDB.setEnabled(true);
    dropDB.setEnabled(true);
    dataBase.setEnabled(true);
  } else {
         newDB.setEnabled(false);
         dropDB.setEnabled(false);
         dataBase.setEnabled(false);
  }

  newTable.setEnabled(state);
  dropTable.setEnabled(state);
  dumpTable.setEnabled(state);
 
  newTableItem.setEnabled(state);
  dropTableItem.setEnabled(state);
  dumpTableItem.setEnabled(state);
 }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
 public void addTextLogMonitor(String msg) {
  LogWin.append(msg + "\n");	
  int longiT = LogWin.getDocument().getLength();
  if(longiT > 0)
  LogWin.setCaretPosition(longiT - 1);
 }	

 /**
  * METODO delDBRegs 
  * Borra una base de datos
  */
 public void delDBReg(String deathDb){
 }
 
 /**
  * METODO connectionLost 
  * Informa que la conexion se ha perdido
  */
 public void connectionLost(String PSQLserver)  {
     InterfaceOffLine();
     JOptionPane.showMessageDialog(XPg.this,
     idiom.getWord("DOWSO") + PSQLserver + idiom.getWord("DOWSO2"),
     idiom.getWord("ERROR!"),JOptionPane.INFORMATION_MESSAGE); 
 }
 
 /**
  * METODO InterfaceOffLine
  * 
  */  
 public void InterfaceOffLine() {
   guard.goOut();
   HostTree();
   treeView = new JScrollPane(tree);
   treeView.setMinimumSize(new Dimension(100,400));
   treeView.setPreferredSize(new Dimension(200,400));
   splitPpal.setLeftComponent(treeView);        
   setTitle("XPg - PostgreSQL GUI");
   addTextLogMonitor(idiom.getWord("DISSOF") + pgconn.getHostname() +"\n");
   connected = false;
   switchJMenus(false);
   connect.setEnabled(true);
   connectItem.setEnabled(true);
   disconnectItem.setEnabled(false);
   activeToolBar(false);
   tabbedPane.setEnabled(false); 
 }

 /** Maneja el evento de tecla presionada **/
 public void keyTyped(KeyEvent e) {
 }

 /** 
  * METODO keyPressed
  * Maneja los eventos de teclas presionadas en el teclado 
  */
 public void keyPressed(KeyEvent e) {
   int keyCode = e.getKeyCode();                                                           
   String keySelected = KeyEvent.getKeyText(keyCode); //cadena que describe la tecla fsica presionada

   if(keySelected.equals("Delete"))  //si la tecla presionada es delete 
    {                                                                                      
     if (DBComponentType == 0) // Presion sobre la raiz del arbol de conexin, el Servidor   
       {
        BoolOption killcon = new BoolOption(XPg.this,idiom.getWord ("YES"),idiom.getWord ("NO"),idiom.getWord("BOOLDISC"),idiom.getWord("MESGDISC")+DBComponentName+"?");
        killcon.pack();                                                                    
        killcon.setLocationRelativeTo(XPg.this);                                           
        killcon.show();                                                                    
        boolean sure = killcon.getSelecction();                                            
        if(sure)                                                                           
         {                                                                                 
          InterfaceOffLine();                                                              
          JOptionPane.showMessageDialog(XPg.this,                                          
          idiom.getWord("DISSOF") + pgconn.getHostname(),                                  
          idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);                          
          pgconn.close();                                                                  
         }                                                                                 
        return;                                                                            
       }                                                                                   
     if (DBComponentType == 1) // DB                                                       
       {                         
        if(dbNames.size()==1) {
          JOptionPane.showMessageDialog(XPg.this,
          idiom.getWord("INVOP"),
          idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
          return;              
			      }                                            
        BoolOption killdb = new BoolOption(XPg.this,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("BOOLDELDB"),idiom.getWord("MESGDELDB")+DBComponentName+"?");
        killdb.pack(); 
        killdb.setLocationRelativeTo(XPg.this); 
        killdb.show(); 
        boolean sure = killdb.getSelecction(); 
        if(sure) 
         { 
          int pos =  dbNames.indexOf(DBComponentName);
          PGConnection tempo = (PGConnection) vecConn.remove(pos);
          tempo.close();
          dbNames.remove(pos);
          //Eliminando BD
          String result = pgconn.SQL_Instruction("DROP DATABASE "+ DBComponentName);
          addTextLogMonitor(idiom.getWord("EXEC")+ "DROP DATABASE "+ DBComponentName + "\"");
          if (result.equals("OK"))
           {
            TreePath selPath = tree.getSelectionPath();
            DefaultMutableTreeNode currentNode =(DefaultMutableTreeNode) (selPath.getLastPathComponent());
            DefaultMutableTreeNode NodeDB =(DefaultMutableTreeNode) currentNode.getParent();
            treeModel.removeNodeFromParent(currentNode);
            addTextLogMonitor(idiom.getWord("RES")+ result);
           }
          else 
           {
            String tmp = result.substring(0,result.length()-1);
            addTextLogMonitor(idiom.getWord("RES")+ tmp);
            JOptionPane.showMessageDialog(XPg.this,idiom.getWord("ERRORPOS") + tmp,
                                        idiom.getWord("ERROR!"), JOptionPane.ERROR_MESSAGE);
           }

         }
        return;                                                                            
       }                                                                                   
     if (DBComponentType == 2 && !DBComponentName.startsWith(idiom.getWord("NOTABLES"))) // Table                                                    
       {                                                                                   
        BoolOption killtb = new BoolOption(XPg.this,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("BOOLDELTB"),idiom.getWord("MESGDELTB")+ DBComponentName + "?");                                           
        killtb.pack();   
        killtb.setLocationRelativeTo(XPg.this);                                                                 
        killtb.show();                                                                    
        boolean sure = killtb.getSelecction(); 
        if(sure)                                                                           
         {                                                                                                                  
          int poss = dbNames.indexOf(ActiveDataB);
          PGConnection konn = (PGConnection) vecConn.elementAt(poss);

          String result = konn.SQL_Instruction("DROP TABLE " + DBComponentName);
          String value = "";
          if(result.equals("OK"))
             {   
              TreePath selPath = tree.getSelectionPath();
              TreePath lastPath = selPath.getParentPath();
              DefaultMutableTreeNode currentNode =(DefaultMutableTreeNode) (selPath.getLastPathComponent());
              treeModel.removeNodeFromParent(currentNode);
              DefaultMutableTreeNode NodeDB =(DefaultMutableTreeNode) (lastPath.getLastPathComponent());
               if(NodeDB.getChildCount()==0) {
                   DefaultMutableTreeNode nLeaf = new DefaultMutableTreeNode(idiom.getWord("NOTABLES"));
                   NodeDB.add(nLeaf);
                                             }

  	      panel1.setNullTable();
	      panel1.setLabel("","","");	
	      panel2.setLabel("","",0,"");
	      panel1.activeToolBar(false);
	      panel1.activeIndexPanel(false);
	      tabbedPane.setEnabledAt(0,false);
	      tabbedPane.setEnabledAt(1,false);
	      tabbedPane.setSelectedIndex(2);
              tree.setSelectionPath(lastPath);
             }
          else
              result = result.substring(0,result.length()-1);

          addTextLogMonitor(idiom.getWord("EXEC") + "DROP TABLE " + DBComponentName + "\"");
          addTextLogMonitor(idiom.getWord("RES") + result);
         }
        return;                                                                            
       }               
    }                                                                                      
   else {                                                                                     
        }
   if(keySelected.equals("Insert"))                                                        
           System.out.println("Create a Table to the DataBase?");            
 }

 /*
 * METODO keyReleased
 * Maneja el evento de tecla liberada.
 */
 public void keyReleased(KeyEvent e) {
 }

 /**
  * METODO focusGained
  * Maneja un foco para los eventos del teclado
  */
 public void focusGained(FocusEvent e) {
   Component tmp = e.getComponent(); 
   tmp.addKeyListener(this);
 }

 /**
  * METODO focusLost
  */
 public void focusLost(FocusEvent e) {
   Component tmp = e.getComponent();
   tmp.removeKeyListener(this);
 }

 public void mouseClicked(MouseEvent e) {
 }
 
 public void mouseReleased(MouseEvent e) {
 }

 public void mouseEntered(MouseEvent e) {
 }

 public void mouseExited(MouseEvent e) {
 }

 /*
  * METODO mousePressed
  * Maneja los eventos cuando el se hace click con el mouse 
  */
 public void mousePressed(MouseEvent e) {
   treeView.requestFocus();
   if(tree.isEditable())
     tree.setEditable(false);

   if(e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e))
       {
         TreePath selPath = tree.getClosestPathForLocation(e.getX(), e.getY());
         DefaultMutableTreeNode node = (DefaultMutableTreeNode) selPath.getLastPathComponent();
	 if (node.isLeaf() && !node.toString().startsWith(idiom.getWord("NOTABLES")))
           {
             if (!popup.isVisible()) 
              {
                popup.show(tree,e.getX(),e.getY());
                if(!DBComponentName.equals(node.toString()))
                 { 
                  DBComponentName = node.toString();
                  tree.setSelectionPath(selPath);
                  activeFoldersTables(node);
                 }
              }
           }
         if (!node.isRoot() && !node.isLeaf())
	  { 
             if (!popupDB.isVisible()) {
                popupDB.show(tree,e.getX(),e.getY());
                if(!DBComponentName.equals(node.toString())){
                DBComponentName = node.toString();
                tree.setSelectionPath(selPath);
                activeFoldersDB(selPath);
                                                           }
                                       }

	  }
       }

   if(e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) 
    {
   TreePath selPath = tree.getClosestPathForLocation(e.getX(), e.getY());
   DefaultMutableTreeNode node = (DefaultMutableTreeNode) selPath.getLastPathComponent();
   DefaultMutableTreeNode dbnode; 
   DBComponentName = node.toString();
   tree.setSelectionPath(selPath);

      if (node.isLeaf())
       {
        activeFoldersTables(node);
       }
      else 
        {
         if (!node.isRoot())
          {
           activeFoldersDB(selPath);
          }
         else
          {
            query.setEnabled(false);

            //Consultando nombres de BD en el servidor 
            Vector listDB = pgconn.TableQuery("SELECT datname FROM pg_database WHERE datname != 'template1' AND datname != 'template0' ORDER BY datname");
            addTextLogMonitor(idiom.getWord("EXEC")+" SELECT datname FROM pg_database WHERE datname != 'template1' AND datname != 'template0' ORDER BY datname\"");

            Vector newsDB = new Vector();
            for(int p=0;p<listDB.size();p++) {
                 Vector o = (Vector) listDB.elementAt(p);
                 String db = (String) o.elementAt(0);
                 if(!dbNames.contains(db))
                      newsDB.addElement(db);
                                             }
            if(newsDB.size()>0) {
               UpdateDBTree updateDBs = new UpdateDBTree(LogWin,idiom,pgconn,newsDB);
     	       Vector dbases = updateDBs.validDB;
               if(dbases.size()>0)
                 {
                  Vector tmpConn = updateDBs.vecConn;
                   for(int p=0;p<dbases.size();p++)
                    {
                     Object o = dbases.elementAt(p);
                     String db = o.toString();
                     PGConnection tmpDB = (PGConnection) tmpConn.elementAt(p);
                     vecConn.addElement(tmpDB); 
                     dbNames.addElement(db);
                     DefaultMutableTreeNode dbLeaf = new DefaultMutableTreeNode(db);
                     DefaultMutableTreeNode noTables = new DefaultMutableTreeNode(idiom.getWord("NOTABLES")); 
                     dbLeaf.add(noTables);
                     DefaultMutableTreeNode parent =(DefaultMutableTreeNode) treeModel.getRoot();
                     treeModel.insertNodeInto(dbLeaf, parent, parent.getChildCount());
                    }
                 }
                                } 


	    if(!tree.isExpanded(selPath))
	      tree.expandPath(selPath);

            DBComponentType = 0;

	    if(OldCompType != DBComponentType)
	     {
  	      panel1.setNullTable();
	      panel1.setLabel("","","");
	      panel2.setLabel("","",0,"");
              panel1.activeToolBar(false);
              panel1.activeIndexPanel(false);
              panel3.setNullPanel();
              panel3.setTextLabel(idiom.getWord("NODBSEL"));
              panel3.functions.setEnabled(false);
              panel3.loadQuery.setEnabled(false);

              tabbedPane.setEnabledAt(0,false);
              tabbedPane.setEnabledAt(1,false);
              tabbedPane.setEnabledAt(2,false);
              ActiveDataB = "";
             }
          }
        }
	OldCompType = DBComponentType;
      }
 }

 /**
  * Mtodo writeFile 
  * Sobre escribe el archivo de configuracin 
  * usado cuando el usuario quiere guardar un 
  * nuevo idioma
  */
 public void writeFile (String idiomName){
   try {
         ConfigFileReader overWrite = new ConfigFileReader(configPath,2);
         Vector LoginRegisters = overWrite.ListRegisters;
         PrintStream configFile = configFile = new PrintStream(new FileOutputStream(configPath));
         configFile.println("language=" + idiomName);
         for(int i=0;i<LoginRegisters.size();i++)
         {
          ConRegister tmp = (ConRegister) LoginRegisters.elementAt(i);
          configFile.println("server=" + tmp.Hostname);
          configFile.println("database="+tmp.Database);
          configFile.println("username=" + tmp.Username);
               configFile.println("port=" + tmp.Port);
          configFile.println("last=" + tmp.Choosed);
         }
         configFile.close();
       }
   catch(Exception ex) {
                        
       }
 }

 /**
  * Mtodo NConnect 
  * Se encarga de realizar las operaciones de conexion
  */
 public void NConnect() {
   LogWin.setText("");
   boolean fail=true;
   Vector Xtables = new Vector();
   ConnectWin spy = new ConnectWin(idiom,LogWin,XPg.this); 

   while(fail) { 
     //spy = new ConnectWin(idiom,LogWin,XPg.this);
     spy.setLanguage(xlanguage);
     spy.pack();
     spy.setLocationRelativeTo(XPg.this);
     spy.show();

     if(spy.Connected()) {
       setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR)); 
       online = spy.getDataReg(); 
       pgconn = new PGConnection(online, idiom); 

       if(!pgconn.Fail()) {
         fail = false;
         Xtables = pgconn.TableQuery("SELECT tablename FROM pg_tables WHERE tablename !~ '^pg_' AND tablename !~ '^pga_' ORDER BY tablename");
         permissions = pgconn.getUserPerm(online.Username);
         ReConfigFile(spy.getDataReg(),spy.getConfigRegisters(),spy.getRegisterSelected());
                          } 
       else {
         setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
         ErrorDialog showError = new ErrorDialog(new JDialog(),pgconn.getErrorMessage(), idiom);
         showError.pack();
         showError.setLocationRelativeTo(XPg.this);
         showError.show();
            }
     } 
    else { 
          return;
         }
   }
   connected = true;
   String strQuery = "SELECT datname FROM pg_database WHERE";

   if(!spy.lookForOthers())
       strQuery += " datname='" + online.getDatabase() + "'"; 
   else
       strQuery += " datname != 'template1' AND datname != 'template0'";

   strQuery += " ORDER BY datname";

   Vector listDB = pgconn.TableQuery(strQuery);
   int numDbases = listDB.size();  
   addTextLogMonitor(idiom.getWord("LOOKDBS") + online.getHost() + "'");
   addTextLogMonitor(idiom.getWord("EXEC")+ " " + strQuery + "\"");
   addTextLogMonitor(numDbases+" "+ idiom.getWord("DBON") + online.getHost());

   if(numDbases>0) 
    {
     for (int i=0;i<numDbases;i++) {
       Vector o = (Vector) listDB.elementAt(i);
       String dbname = (String) o.elementAt(0);
       addTextLogMonitor(idiom.getWord("TRYCONN") + ": \"" + dbname + "\"... ");
       ConRegister tmp = new ConRegister(online.Hostname,dbname,online.Username,online.Password,online.Port); 
       PGConnection proofConn = new PGConnection(tmp, idiom); 
       if (!proofConn.Fail()) {
         addTextLogMonitor(idiom.getWord("OKACCESS"));
         dbNames.addElement(dbname);
         vecConn.addElement(proofConn);
                              } 
       else {
         addTextLogMonitor(idiom.getWord("NOACCESS")); 
            }
                                  } //fin for
     } //fin if

   top = new DefaultMutableTreeNode(online.getHost());
   numDbases = dbNames.size();
   addTextLogMonitor(idiom.getWord("REPORT")+idiom.getWord("USER ") + pgconn.getUsername() + idiom.getWord("VALID") + numDbases + idiom.getWord("NUMDB"));                           
   int index = -1;

   for(int m=0;m<numDbases;m++) {
     Object o = dbNames.elementAt(m);
     String dbname = o.toString();
     addTextLogMonitor(idiom.getWord("DB: ") + dbname);	        
     category1 = new DefaultMutableTreeNode(dbname);
     top.add(category1);
     if (dbname.equals(online.Database)) {
       index = m;
       Vector OneTable = Xtables;
       int numTables = OneTable.size();

       if (numTables == 0) {
        globalLeaf = new DefaultMutableTreeNode(idiom.getWord("NOTABLES"));
        category1.add(globalLeaf);
        } 
       else 
         {
           for(int i=0;i<numTables;i++) {
             Vector t = (Vector) OneTable.elementAt(i);
             String tablename = (String) t.elementAt(0);
             globalLeaf = new DefaultMutableTreeNode(tablename);
             category1.add(globalLeaf);
                                        }
         }//fin else hay tablas
     } 
    else {
          globalLeaf = new DefaultMutableTreeNode(idiom.getWord("NOTABLES"));
          category1.add(globalLeaf);
         }
   }//fin ciclo for







   treeModel = new DefaultTreeModel(top);
   tree = new JTree(treeModel);
   tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
   tree.setCellRenderer(renderer);
   tree.expandRow(0);
   tree.expandRow(index+1);
   tree.setSelectionRow(index+1); 
   treeView = new JScrollPane(tree);
   treeView.addFocusListener(this);	    
   treeView.setMinimumSize(new Dimension(100,400));
   treeView.setPreferredSize(new Dimension(200,400));
   splitPpal.setLeftComponent(treeView);	       
   splitPpal.setDividerLocation(135);
   tree.addMouseListener(this);
   connect.setEnabled(false);
   connectItem.setEnabled(false);
   disconnectItem.setEnabled(true);
   activeToolBar(true);
   switchJMenus(true); //encender los botones requeridos cuando la conexin es exitosa

   if(permissions[0].equals("false"))
      dataBase.setEnabled(false);
   if(permissions[1].equals("false"))
      admin.setEnabled(false);

   tabbedPane.setEnabled(true);
   tabbedPane.setEnabledAt(0,false);
   tabbedPane.setEnabledAt(1,false);
   tabbedPane.setEnabledAt(2,true);
   tabbedPane.setSelectedIndex(2);
   panel3.newQuery.setEnabled(false);
   panel3.functions.setEnabled(true);
   panel3.loadQuery.setEnabled(true);
   panel3.saveQuery.setEnabled(false);
   panel3.runQuery.setEnabled(false);
   panel3.queryX.setEditable(true);               
   DBComponentName = online.Database;
   DBComponentType = 1; 
   ActiveDataB = DBComponentName;
   int pox = dbNames.indexOf(ActiveDataB);
   panel3.setLabel(ActiveDataB);
   panel3.pgConn = (PGConnection) vecConn.elementAt(pox);
   OldCompType = 1;

   setTitle(idiom.getWord("UONLINE") + pgconn.getUsername());
   String mesg0 = idiom.getWord("INFOSERVER") + pgconn.getHostname();
   String mesg1 = idiom.getWord("VERSION") + pgconn.getVersion();
   String mesg2 = idiom.getWord("WACCESS") + numDbases + idiom.getWord("NUMDB");
   setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
   JOptionPane.showMessageDialog(XPg.this,
   mesg0 + "\n" + mesg1 + "\n" + mesg2,
   idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE); 

   panel3.queryX.requestFocus();
               
   String hostname = pgconn.getHostname();
   int port = pgconn.getPort();
   guard = new ConnectionWatcher(hostname, port, XPg.this);
   guard.start();
	       
   ChangeListener l = new ChangeListener() {
     public void stateChanged(ChangeEvent e) {
       int carpeta = tabbedPane.getSelectedIndex();
       int pox = dbNames.indexOf(ActiveDataB);
       PGConnection konn;
       if(pox != -1)
           konn = (PGConnection) vecConn.elementAt(pox);
       else
           konn = (PGConnection) vecConn.elementAt(0);

       currentTable = konn.getSpecStrucTable(DBComponentName);
       switch(carpeta) {
         case 0 : ActivedTabbed = 0; 
		  indices = konn.getIndexTable(DBComponentName);
                  addTextLogMonitor(idiom.getWord("EXEC") + konn.getSQL() + "\""); 
		  panel1.activeToolBar(true);
		  panel1.activeIndexPanel(true);
                  String result = konn.getOwner(DBComponentName);
		  panel1.setLabel(ActiveDataB,DBComponentName,result);
		  panel1.setTableStruct(currentTable);
		  panel1.setIndexTable(indices, konn);
		  break; 
         case 1 : ActivedTabbed = 1;
                  panel2.setRecordFilter(DBComponentName,ActiveDataB);
	          if(!panel2.updateTable(konn,DBComponentName,currentTable))
                     {
                      tabbedPane.setSelectedIndex(0);
                      ActivedTabbed = 0;

                      indices = konn.getIndexTable(DBComponentName);
                      addTextLogMonitor(idiom.getWord("EXEC") + konn.getSQL() + "\"");
                      panel1.activeToolBar(true);
                      panel1.activeIndexPanel(true);
                      String ownerName = konn.getOwner(DBComponentName);
                      panel1.setLabel(ActiveDataB,DBComponentName,ownerName);
                      panel1.setTableStruct(currentTable);
                      panel1.setIndexTable(indices, konn);
                     }
	          break;
         case 2 : ActivedTabbed = 2;   
                  panel3.setLabel(ActiveDataB);
                  panel3.saveQuery.setEnabled(false);
                  panel3.runQuery.setEnabled(false);
                  panel3.queryX.requestFocus(); 
		  String currString = panel3.queryX.getText(); 
		  if(currString.length() > 1) {
		    panel3.newQuery.setEnabled(true);
		    if(currString.length() > 15) { 
		      panel3.saveQuery.setEnabled(true);
		      panel3.runQuery.setEnabled(true); 
		    }
		  } else {
		    panel3.newQuery.setEnabled(false);
                  }
		  break; 
       }
     }
   };
   tabbedPane.addChangeListener(l); 
 }

 /**
  * METODO getTime
  * Retorna la hora
  */
 public String[] getTime() {
   Calendar today = Calendar.getInstance();
   String[] val = new String[5];
   int monthInt = today.get(Calendar.MONTH) + 1;
   int minuteInt = today.get(Calendar.MINUTE);
   String zero = "";
   String min = "";
   if(monthInt < 10)
       zero = "0";
   if(minuteInt < 10)
       min = "0";

   val[0] = "" + today.get(Calendar.DAY_OF_MONTH);
   val[1] = zero + monthInt;
   val[2] = "" + today.get(Calendar.YEAR);
   val[3] = "" + today.get(Calendar.HOUR_OF_DAY);
   val[4] = min + today.get(Calendar.MINUTE);
   return val;
 }

 /**
  * METODO DateLogName
  * Crea el nombre del archivo de logs segun la fecha
  */
  public String DateLogName(String[] val) {
   String dformat = val[0] + "-" + val[1] + "-" + val[2] + "_" + val[3] + "-" + val[4];
   return dformat;
  }

  public String DateClassic(String[] val) {
   String dformat = val[3] + ":" + val[4] + " " + val[0] + "/" + val[1] + "/" + val[2];
   return dformat;
  }

  public void printFile(PrintStream xfile,Vector registers,Vector FieldNames,String Separator,TableHeader theader)
   {
    Vector types = new Vector();
    try {
    int TableWidth = FieldNames.size();
    for(int p=0;p<TableWidth;p++) {
       String column = (String) FieldNames.elementAt(p);
       types.addElement(theader.getType(column));
       xfile.print(column);
       if(p<TableWidth-1)
        xfile.print(Separator);
                                  }
    xfile.print("\n");
    for(int p=0;p<registers.size();p++) {
       Vector rData = (Vector) registers.elementAt(p);
       for(int i=0;i<TableWidth;i++) {
          Object o = rData.elementAt(i);
          String Stype = (String) types.elementAt(i);
          String field = "null";
          if(o != null) {
            if(Stype.startsWith("varchar") || Stype.startsWith("name") || Stype.startsWith("text"))
              field = o.toString();
            if(Stype.startsWith("int")) {
              Integer ipr = (Integer) o;
              field = "" + ipr;
                                        }
            if(Stype.startsWith("float") || Stype.startsWith("decimal")) {
              Integer ipr = (Integer) o;
              field = "" + ipr;
                                        }
            if(Stype.startsWith("bool")) {
              Boolean bx = (Boolean) o;
              field = "" + bx;
                                        }

                        }
          xfile.print(field);
          if(i<TableWidth-1)
              xfile.print(Separator);
                                         }
          xfile.print("\n");
                                        }
      xfile.close();
         }
       catch(Exception e) { 
                            System.out.println("Error: " + e); 
                            e.printStackTrace();
                          }
 }


 /**
  * METODO Count
  * Retorna el numero de registros de una tabla 
  */
  public int Count(String TableN,PGConnection konn){
   int val;
   String counting = "select count(*) from " + TableN + ";";
   Vector result = konn.TableQuery(counting);
   Vector value = (Vector) result.elementAt(0);
   try {
        Integer entero = (Integer) value.elementAt(0);
        val = entero.intValue();
   }
   catch(Exception ex){
        Long entero = (Long) value.elementAt(0);
        val = entero.intValue(); 
   }
   
   return val;
  }

 /**
  * METODO Disconnect
  * Desconecta todas las conexiones a un servidor
  */ 
  public void Disconnect() {
     /* ciclo for para cerrar todas la pg_konn activas */
     for(int p=0;p<vecConn.size();p++) {
       PGConnection tempo = (PGConnection) vecConn.remove(p);
       tempo.close();
     }

     dbNames = new Vector();
     vecConn = new Vector();
     panel1.activeToolBar(false);
     panel1.activeIndexPanel(false);
     panel1.setNullTable();

     panel2.activeInterface(false);
     panel3.setNullPanel();
     InterfaceOffLine();
     SaveLog();

     JOptionPane.showMessageDialog(XPg.this,
     idiom.getWord("DISSOF") + pgconn.getHostname(),
     idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
     pgconn.close();
  }

 /**
  * METODO main : SaveLog 
  * Guarda a un archivo la informacion contenida en el Monitor de Eventos 
  */
  public void SaveLog() 
   {
     try 
     {
      String LogName = DateLogName(getTime()) + ".log";
      String UHome = "logs" + System.getProperty("file.separator");
      if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD"))
           UHome = System.getProperty("user.home") + System.getProperty("file.separator")
                     + ".xpg" + System.getProperty("file.separator") + "logs"
                     + System.getProperty("file.separator");
      PrintStream fileLog = new PrintStream(new FileOutputStream(UHome + LogName));
      fileLog.print("Begin: " + startDate + "\n" + "\n");
      fileLog.print(LogWin.getText());
      fileLog.print("End: " + DateClassic(getTime()));
      fileLog.close();
     } 
     catch(Exception ex) 
       {
        System.out.println("Error: " + ex);
        ex.printStackTrace();
       }
   }


   public void activeFoldersDB(TreePath selPath)
    {
          tabbedPane.setSelectedIndex(2);

          if(!query.isEnabled())
              query.setEnabled(true);

           if(OldCompType == 0) {
              tabbedPane.setEnabledAt(2,true);
              panel3.queryX.setEditable(true);
              panel3.functions.setEnabled(true);
              panel3.loadQuery.setEnabled(true);
                                }
           ActiveDataB = DBComponentName;

           panel3.setLabel(ActiveDataB);
           int index = dbNames.indexOf(ActiveDataB);
           PGConnection konn = (PGConnection) vecConn.elementAt(index);
           panel3.pgConn = konn;

           DBComponentType = 1;

           //Consultando nombres de tablas de una BD, sin incluir tablas del sistema
           Vector RefreshTableList = konn.TableQuery("SELECT tablename FROM pg_tables WHERE tablename !~ '^pg_' AND tablename  !~ '^pga_' ORDER BY tablename");
           addTextLogMonitor(idiom.getWord("EXEC")+" SELECT tablename FROM pg_tables WHERE tablename  !~ '^pg_' AND tablename  !~ '^pga_' ORDER BY tablename\"" );

           DefaultMutableTreeNode currentNode =(DefaultMutableTreeNode) (selPath.getLastPathComponent());

           currentNode.removeAllChildren();
           if(RefreshTableList.size()!=0)
            {
              for(int i=0;i<RefreshTableList.size();i++)
              {
                Vector o = (Vector) RefreshTableList.elementAt(i);
                String nameT = (String) o.elementAt(0);
                DefaultMutableTreeNode nLeaf = new DefaultMutableTreeNode(nameT);
                currentNode.add(nLeaf);
              }
            }
           else
              {
                 DefaultMutableTreeNode nLeaf = new DefaultMutableTreeNode(idiom.getWord("NOTABLES"));
                 currentNode.add(nLeaf);
              }
           treeModel.nodeStructureChanged(currentNode);

           if(!tree.isExpanded(selPath))
             tree.expandPath(selPath);
           else
             tree.collapsePath(selPath);

           if(OldCompType != 1) 
             {
               panel1.setNullTable();
               panel1.setLabel("","","");
               panel2.setLabel("","",0,"");
               panel1.activeToolBar(false);
               panel1.activeIndexPanel(false);
               tabbedPane.setEnabledAt(0,false);
               tabbedPane.setEnabledAt(1,false);
             }

   }



   public void activeFoldersTables(DefaultMutableTreeNode node)
    {
        DefaultMutableTreeNode dbnode;
        DBComponentType = 2;
        dbnode = (DefaultMutableTreeNode) node.getParent();
        ActiveDataB = dbnode.toString();

        if(OldCompType == 0) {
            tabbedPane.setEnabledAt(2,true);
            panel3.functions.setEnabled(true);
            panel3.loadQuery.setEnabled(true);
                             }

        if(!DBComponentName.startsWith(idiom.getWord("NOTABLES")))
         {
          if(!query.isEnabled())
           query.setEnabled(true);

          int index = dbNames.indexOf(ActiveDataB);
          PGConnection konn = (PGConnection) vecConn.elementAt(index);
          currentTable = konn.getSpecStrucTable(DBComponentName);
          indices = konn.getIndexTable(DBComponentName);
          tabbedPane.setEnabledAt(0,true);
          tabbedPane.setEnabledAt(1,true);
          panel1.updateUI();
          if(ActivedTabbed == 0)
            {
             panel1.activeToolBar(true);
             panel1.activeIndexPanel(true);
             String result = konn.getOwner(DBComponentName);
             panel1.setLabel(ActiveDataB,DBComponentName,result);
             panel1.setTableStruct(currentTable);
             panel1.setIndexTable(indices, konn);
            }
          if(ActivedTabbed == 1)
            {
             panel2.setRecordFilter(DBComponentName,ActiveDataB);
             if(!panel2.updateTable(konn,DBComponentName,currentTable))
              {
               tabbedPane.setSelectedIndex(0);
               ActivedTabbed = 0;

               panel1.activeToolBar(true);
               panel1.activeIndexPanel(true);
               String result = konn.getOwner(DBComponentName);
               panel1.setLabel(ActiveDataB,DBComponentName,result);
               panel1.setTableStruct(currentTable);
               panel1.setIndexTable(indices, konn);
              }
            }
          if(ActivedTabbed == 2)
            {
             tabbedPane.setSelectedIndex(0);
             panel1.current_conn = konn;
            }
         }
         else
         {
          if(ActivedTabbed == 0)
          {
           tabbedPane.setSelectedIndex(2);
           ActivedTabbed = 2;
          }
          if(ActivedTabbed == 1)
            {
             tabbedPane.setSelectedIndex(2);
             ActivedTabbed = 2;
            }
          if(ActivedTabbed == 2)
            {
             panel3.setLabel(ActiveDataB);
            }
          tabbedPane.setEnabledAt(0,false);
          tabbedPane.setEnabledAt(1,false);
         }
    }


 public String createTableSQL(Table currentTable) 
  {
   String sql = "CREATE TABLE " + currentTable.getName() + " (\n";
   //Nuevos datos de la tabla
   TableHeader headT = currentTable.base;
   int numFields = headT.NumFields;

   for(int k=0;k<numFields;k++)
    {
      Object o = (String) headT.fields.elementAt(k);
      String field_name = o.toString();
      FieldReg tmp = (FieldReg) headT.hashFields.get(field_name);
      sql += tmp.Name + " ";

      String typeF = tmp.Type;
      if ("char".equals(tmp.Type)  || "varchar".equals(tmp.Type))
       {
        int longStr = tmp.options.charLong;
        if(longStr>0)
          typeF = tmp.Type + "(" + tmp.options.charLong + ")";
        else
          typeF = tmp.Type;
       }

      sql += typeF + " ";

      Boolean tmpbool = new Boolean(tmp.options.isNull);

      if(tmpbool.booleanValue())
        sql += "NOT NULL ";

      String defaultV = tmp.options.DefaultValue;

      if(defaultV.endsWith("::bool"))
       {
        if(defaultV.indexOf("t")!=-1)
           defaultV = "true";
        else
           defaultV = "false";
       }

      if(defaultV.length()>0)
        sql += " DEFAULT " + defaultV;

      if(k < numFields-1)
        sql += ",\n";
   }
   sql += "\n);";

   return sql;
 }

 /**
  * Metodo funcBasicStruct 
  * Organiza la definicion de las instrucciones SQL basicas 
  */

 public SQLFuncBasic[] funcBasicStruct()
  {
    SQLFuncBasic[] basicArray = new SQLFuncBasic[38];

    String[][] descriptFunc = {
    {"ALTER GROUP","ALTER GROUP name ADD USER username [, ... ]<br>ALTER GROUP name DROP USER username [, ... ]"},
    {"ALTER TABLE","ALTER TABLE [ ONLY ] table [ * ]<br>ADD [ COLUMN ] column type [ column_constraint [ ... ] ]<br><br>ALTER TABLE [ ONLY ] table [ * ]<br>ALTER [ COLUMN ] column { SET DEFAULT value | DROP DEFAULT }<br><br>ALTER TABLE [ ONLY ] table [ * ]<br>ALTER [ COLUMN ] column SET STATISTICS integer<br><br>ALTER TABLE [ ONLY ] table [ * ]<br>RENAME [ COLUMN ] column TO newcolumn<br><br>ALTER TABLE table<br>RENAME TO new_table<br><br>ALTER TABLE table<br>ADD table_constraint_definition<br><br>ALTER TABLE [ ONLY ] table<br>DROP CONSTRAINT constraint { RESTRICT | CASCADE }<br><br>ALTER TABLE table<br>OWNER TO new_owner"},
    {"ALTER USER","ALTER USER username [ [ WITH ] option [ ... ] ]<br>" + idiom.getWord("WHERE") + " <b>option</b> " + idiom.getWord("CAN") + "<br>[ ENCRYPTED | UNENCRYPTED ] PASSWORD 'password'<br>| CREATEDB | NOCREATEDB<br>| CREATEUSER | NOCREATEUSER<br>| VALID UNTIL 'abstime'"},
    {"CREATE AGGREGATE","CREATE AGGREGATE name ( BASETYPE = input_data_type,<br>SFUNC = sfunc, STYPE = state_type<br>[ , FINALFUNC = ffunc ]<br>[ , INITCOND = initial_condition ] )"},
    {"CONSTRAINT TRIGGER","CREATE CONSTRAINT TRIGGER name<br>AFTER events ON<br>relation constraint attributes<br>FOR EACH ROW EXECUTE PROCEDURE func '(' args ')'"},
    {"CREATE DATABASE","CREATE DATABASE name<br>[ WITH [ LOCATION = 'dbpath' ]<br>[ TEMPLATE = template ]<br>[ ENCODING = encoding ] ]"},
    {"CREATE FUNCTION","CREATE [ OR REPLACE ] FUNCTION name ( [ argtype [, ...] ] )<br>RETURNS rettype<br>AS 'definition'<br>LANGUAGE langname<br>[ WITH ( attribute [, ...] ) ]<br><br>CREATE [ OR REPLACE ] FUNCTION name ( [ argtype [, ...] ] )<br>RETURNS rettype<br>AS 'obj_file', 'link_symbol'<br>LANGUAGE langname<br>[ WITH ( attribute [, ...] ) ]"},
    {"CREATE GROUP","CREATE GROUP name [ [ WITH ] option [ ... ] ]<br>" + idiom.getWord("WHERE") + " <b>option</b> " + idiom.getWord("CAN") + "<br>SYSID gid<br>| USER  username [, ...]"},
    {"CREATE INDEX","CREATE [ UNIQUE ] INDEX index_name ON table<br>[ USING acc_method ] ( column [ ops_name ] [, ...] )<br>[ WHERE predicate ]<br><br>CREATE [ UNIQUE ] INDEX index_name ON table<br>[ USING acc_method ] ( func_name( column [, ... ]) [ ops_name ] )<br>[ WHERE predicate ]"},
    {"CREATE LANGUAGE","CREATE [ TRUSTED ] [ PROCEDURAL ] LANGUAGE langname<br>HANDLER call_handler"},
    {"CREATE OPERATOR","CREATE OPERATOR name ( PROCEDURE = func_name<br>[, LEFTARG = lefttype<br>] [, RIGHTARG = righttype ]<br>[, COMMUTATOR = com_op ] [, NEGATOR = neg_op ]<br>[, RESTRICT = res_proc ] [, JOIN = join_proc ]<br>[, HASHES ] [, SORT1 = left_sort_op ] [, SORT2 = right_sort_op ] )"},
    {"CREATE RULE","CREATE RULE name AS ON event<br>TO object [ WHERE condition ]<br>DO [ INSTEAD ] action<br>" + idiom.getWord("WHERE") + " <b>action</b> " + idiom.getWord("CAN") + "<br>NOTHING<br>|<br>query<br>|<br>( query ; query ... )<br>|<br>[ query ; query ... ]"},
    {"CREATE SEQUENCE","CREATE [ TEMPORARY | TEMP ] SEQUENCE seqname [ INCREMENT increment ]<br>[ MINVALUE minvalue ] [ MAXVALUE maxvalue ]<br>[ START start ] [ CACHE cache ] [ CYCLE ]"},
    {"CREATE TABLE","&nbsp;&nbsp;CREATE [ [ LOCAL ] { TEMPORARY | TEMP } ] TABLE table_name (<br>&nbsp;&nbsp;{ column_name data_type [ DEFAULT default_expr ] [ column_constraint [, ...<br>&nbsp;&nbsp;] ]<br>&nbsp;&nbsp;    | table_constraint }  [, ... ]<br>&nbsp;&nbsp;)<br>&nbsp;&nbsp;[ INHERITS ( parent_table [, ... ] ) ]<br>&nbsp;&nbsp;[ WITH OIDS | WITHOUT OIDS ]<br><br>" + idiom.getWord("WHERE") + " <b>column_constraint</b> " + idiom.getWord("IS") + "<br>&nbsp;&nbsp;[ CONSTRAINT constraint_name ]<br>&nbsp;&nbsp;{ NOT NULL | NULL | UNIQUE | PRIMARY KEY |<br>&nbsp;&nbsp;CHECK (expression) |<br>&nbsp;&nbsp;REFERENCES reftable [ ( refcolumn ) ] [ MATCH FULL | MATCH PARTIAL ]<br>&nbsp;&nbsp;[ ON DELETE action ] [ ON UPDATE action ] }<br>&nbsp;&nbsp;[ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]<br><br>" + idiom.getWord("AND") + " <b>table_constraint</b> " + idiom.getWord("IS") + "<br>&nbsp;&nbsp;[ CONSTRAINT constraint_name ]<br>&nbsp;&nbsp;{ UNIQUE ( column_name [, ... ] ) |<br>&nbsp;&nbsp;PRIMARY KEY ( column_name [, ... ] ) |<br>&nbsp;&nbsp;CHECK ( expression ) |<br>&nbsp;&nbsp;FOREIGN KEY ( column_name [, ... ] ) REFERENCES reftable [ ( refcolumn [, ...<br>&nbsp;&nbsp;] ) ]<br>&nbsp;&nbsp;] ) ]<br>&nbsp;&nbsp;[ MATCH FULL | MATCH PARTIAL ] [ ON DELETE action ] [ ON UPDATE action ] }<br>&nbsp;&nbsp;[ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]"},
    {"CREATE TABLE AS","CREATE [ [ LOCAL ] { TEMPORARY | TEMP } ] TABLE table_name [ (column_name [, ...] ) ]<br>AS query"},
    {"CREATE TRIGGER","CREATE TRIGGER name { BEFORE | AFTER } { event [OR ...] }<br>ON table FOR EACH { ROW | STATEMENT }<br>EXECUTE PROCEDURE func ( arguments )"},
    {"CREATE TYPE","CREATE TYPE typename ( INPUT = input_function, OUTPUT = output_function<br>, INTERNALLENGTH = { internallength | VARIABLE }<br>[ , EXTERNALLENGTH = { externallength | VARIABLE } ]<br>[ , DEFAULT = default ]<br>[ , ELEMENT = element ] [ , DELIMITER = delimiter ]<br>[ , SEND = send_function ] [ , RECEIVE = receive_function ]<br>[ , PASSEDBYVALUE ]<br>[ , ALIGNMENT = alignment ]<br>[ , ALIGNMENT = alignment ]<br>[ , STORAGE = storage ]<br>)"},
    {"CREATE USER","CREATE USER username [ [ WITH ] option [ ... ] ]<br>" + idiom.getWord("WHERE") + " <b>option</b> " + idiom.getWord("CAN") + "<br>SYSID uid<br>| [ ENCRYPTED | UNENCRYPTED ] PASSWORD 'password'<br>| CREATEDB | NOCREATEDB<br>| CREATEUSER | NOCREATEUSER<br>| IN GROUP groupname [, ...]<br>| VALID UNTIL 'abstime'"},
    {"CREATE VIEW","CREATE VIEW view [ ( column name list ) ] AS SELECT query"},
    {"DELETE","DELETE FROM [ ONLY ] table [ WHERE condition ]"},
    {"DROP AGGREGATE","DROP AGGREGATE name ( type )"},
    {"DROP DATABASE","DROP DATABASE name"},
    {"DROP FUNCTION","DROP FUNCTION name ( [ type [, ...] ] )"},
    {"DROP GROUP","DROP GROUP name"},
    {"DROP INDEX","DROP INDEX index_name [, ...]"},
    {"DROP LANGUAGE","DROP [ PROCEDURAL ] LANGUAGE name"},
    {"DROP OPERATOR","DROP OPERATOR id ( lefttype | NONE , righttype | NONE )"},
    {"DROP RULE","DROP RULE name [, ...]"},
    {"DROP SEQUENCE","DROP SEQUENCE name [, ...]"},
    {"DROP TABLE","DROP TABLE name [, ...]"},
    {"DROP TRIGGER","DROP TRIGGER name ON table"},
    {"DROP TYPE","DROP TYPE typename [, ...]"},
    {"DROP USER","DROP USER name"},
    {"DROP VIEW","DROP VIEW name [, ...]"},
    {"GRANT","GRANT { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER } [,...] | ALL [ PRIVILEGES ] }<br>ON [ TABLE ] objectname [, ...]<br>TO { username | GROUP groupname | PUBLIC } [, ...]"},
    {"REVOKE","REVOKE { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER } [,...] | ALL [ PRIVILEGES ] }<br>ON [ TABLE ] object [, ...]<br>FROM { username | GROUP groupname | PUBLIC } [, ...]"},
    {"SELECT","SELECT [ ALL | DISTINCT [ ON ( expression [, ...] ) ] ]<br>* | expression [ AS output_name ] [, ...]<br>[ FROM from_item [, ...] ]<br>[ WHERE condition ]<br>[ GROUP BY expression [, ...] ]<br>[ HAVING condition [, ...] ]<br>[ { UNION | INTERSECT | EXCEPT } [ ALL ] select ]<br>[ ORDER BY expression [ ASC | DESC | USING operator ] [, ...] ]<br>[ FOR UPDATE [ OF tablename [, ...] ] ]<br>[ LIMIT { count | ALL } ]<br>[ OFFSET start ]<br><br>" + idiom.getWord("WHERE") + " <b>from_item</b> " + idiom.getWord("CAN") + "<br><br>[ ONLY ] table_name [ * ]<br>[ [ AS ] alias [ ( column_alias_list ) ] ]<br>|<br>( select )<br>[ AS ] alias [ ( column_alias_list ) ]<br>|<br>from_item [ NATURAL ] join_type from_item<br>[ ON join_condition | USING ( join_column_list ) ]"},
    {"UPDATE","UPDATE [ ONLY ] table SET col = expression [, ...]<br>[ FROM fromlist ]<br>[ WHERE condition ]"}
    };

    for(int i=0;i<38;i++)
      {
        int k = i + 1;        
        SQLFuncBasic func = new SQLFuncBasic(idiom,descriptFunc[i][0],idiom.getWord("FDB" + k),descriptFunc[i][1]);
        basicArray[i] = func;
      }

    return basicArray;
  }

 /**
  * Metodo funcDataStruct
  * Organiza la definicion de las funciones
  */
 public SQLFunctionDataStruc[] funcDataStruct()
  {
    SQLFunctionDataStruc[] funcList = new SQLFunctionDataStruc[100];
    int[] funcSets = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
                       1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 2, 1, 4,
                       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2,
                       2, 1, 3, 4, 1, 1, 1, 1, 2, 1, 2, 1 };
    
    String[][] descriptFunc = { 
    {"COALESCE(list)","non-NULL","COALESCE(rle, c2 + 5, 0)"},
    {"NULLIF(input,value)","input or NULL","NULLIF(c1, 'N/A')"},
    {"CASE WHEN expr THEN expr [...] ELSE expr END","expr","CASE WHEN c1 = 1 THEN 'match'<br>ELSE 'no match' END"},
    {"abs(float8)","float8","abs(-17.4)"},
    {"degrees(float8)","float8","degrees(0.5)"},
    {"exp(float8)","float8","exp(2.0)"},
    {"ln(float8)","float8","ln(2.0)"},
    {"log(float8)","float8","log(2.0)"},
    {"pi()","float8","pi()"},
    {"pow(float8,float8)","float8","pow(2.0, 16.0)"},
    {"radians(float8)","float8","radians(45.0)"},
    {"round(float8)","float8","round(42.4)"},
    {"sqrt(float8)","float8","sqrt(2.0)"},
    {"cbrt(float8)","float8","cbrt(27.0)"},
    {"trunc(float8)","float8","trunc(42.4)"},
    {"float(int)","float8","float(2)"},
    {"float4(int)","float4","float4(2)"},
    {"integer(float)","int","integer(2.0)"},
    {"acos(float8)","float8","acos(10.0)"},
    {"asin(float8)","float8","asin(10.0)"},
    {"atan(float8)","float8","atan(10.0)"},
    {"atan2(float8,float8)","float8","atan3(10.0,20.0)"},
    {"cos(float8)","float8","cos(0.4)"},
    {"cot(float8)","float8","cot(20.0)"},
    {"sin(float8)","float8","cos(0.4)"},
    {"tan(float8)","float8","tan(0.4)"},
    {"char_length(string)","int4","char_length('jose')"},
    {"character_length(string)","int4","character_length('jose')"},
    {"lower(string)","string","lower('TOM')"},
    {"octet_length(string)","int4","octet_length('jose')"},
    {"position(string in string)","int4","position('o' in 'Tom')"},
    {"substring(string [from int] [for int])","string","substring('Tom' from 2 for 2)"},
    {"trim([leading|trailing|both] [string] from string)","string","trim(both 'x' from 'xTomx')"},
    {"upper(text)","text","upper('tom')"},
    {"char(text)","char","char('text string')"},
    {"char(varchar)","char","char(varchar 'varchar string')"},
    {"initcap(text)","text","initcap('thomas')"},
    {"lpad(text,int,text)","text","lpad('hi',4,'??')"},
    {"ltrim(text,text)","text","ltrim('xxxxtrim','x')"},
    {"textpos(text,text)","text","position('high','ig')"},
    {"rpad(text,int,text)","text","rpad('hi',4,'x')"},
    {"rtrim(text,text)","text","rtrim('trimxxxx','x')"},
    {"substr(text,int[,int])","text","substr('hi there',3,5)"},
    {"text(char)","text","text('char string')"},
    {"text(varchar)","text","text(varchar 'varchar string')"},
    {"translate(text,from,to)","text","translate('12345', '1', 'a')"},
    {"varchar(char)","varchar","varchar('char string')"},
    {"varchar(text)","varchar","varchar('text string')"},
    {"abstime(timestamp)","abstime","abstime(timestamp 'now')"},
    {"age(timestamp)","interval","age(timestamp '1957-06-13')"},
    {"age(timestamp,timestamp)","interval","age('now', timestamp '1957-06-13')"},
    {"date_part(text,timestamp)","float8","date_part('dow',timestamp 'now')"},
    {"date_part(text,interval)","float8","date_part('hour',interval '4 hrs 3 mins')"},
    {"date_trunc(text,timestamp)","timestamp","date_trunc('month',abstime 'now')"},
    {"interval(reltime)","interval","interval(reltime '4 hours')"},
    {"isfinite(timestamp)","bool","isfinite(timestamp 'now')"},
    {"isfinite(interval)","bool","isfinite(interval '4 hrs')"},
    {"reltime(interval)","reltime","reltime(interval '4 hrs')"},
    {"timestamp(date)","timestamp","timestamp(date 'today')"},
    {"timestamp(date,time)","timestamp","timestamp(timestamp '1998-02-24',time '23:07');"},
    {"to_char(timestamp,text)","text","to_char(timestamp '1998-02-24','DD');"},
    {"to_char(timestamp, text)","text","to_char(timestamp 'now','HH12:MI:SS')"},
    {"to_char(int, text)","text","to_char(125, '999')"},
    {"to_char(float, text)","text","to_char(125.8, '999D9')"},
    {"to_char(numeric, text)","text","to_char(numeric '-125.8', '999D99S')"},
    {"to_date(text, text)","date","to_date('05 Dec 2000', 'DD Mon YYYY')"},
    {"to_timestamp(text, text)","date","to_timestamp('05 Dec 2000', 'DD Mon YYYY')"},
    {"to_number(text, text)","numeric","to_number('12,454.8-', '99G999D9S')"},
    {"area(object)","float8","area(box '((0,0),(1,1))')"},
    {"box(box,box)","box","box(box '((0,0),(1,1))',box '((0.5,0.5),(2,2))')"},
    {"center(object)","point","center(box '((0,0),(1,2))')"},
    {"diameter(circle)","float8","diameter(circle '((0,0),2.0)')"},
    {"height(box)","float8","height(box '((0,0),(1,1))')"},
    {"isclosed(path)","bool","isclosed(path '((0,0),(1,1),(2,0))')"},
    {"isopen(path)","bool","isopen(path '[(0,0),(1,1),(2,0)]')"},
    {"length(object)","float8","length(path '((-1,0),(1,0))')"},
    {"pclose(path)","path","popen(path '[(0,0),(1,1),(2,0)]')"},
    {"npoint(path)","int4","npoints(path '[(0,0),(1,1),(2,0)]')"},
    {"popen(path)","path","popen(path '((0,0),(1,1),(2,0))')"},
    {"radius(circle)","float","radius(circle '((0,0),2.0)')"},
    {"width(box)","float8","width(box '((0,0),(1,1))')"},
    {"box(circle)","box","box('((0,0),2.0)'::circle)"},
    {"box(point,point)","box","box('(0,0)'::point,'(1,1)'::point)"},
    {"box(polygon)","box","box('((0,0),(1,1),(2,0))'::polygon)"},
    {"circle(box)","box","circle('((0,0),(1,1))'::box)"},
    {"circle(point,float8)","circle","circle('(0,0)'::point,2.0)"},
    {"lseg(box)","lseg","lseg('((-1,0),(1,0))'::box)"},
    {"lseg(point,point)","lseg","lseg('(-1,0)'::point,'(1,0)'::point)"},
    {"path(polygon)","point","path('((0,0),(1,1),(2,0))'::polygon)"},
    {"point(circle)","point","point('((0,0),2.0)'::circle)"},
    {"point(lseg,lseg)","point","point('((-1,0),(1,0))'::lseg, '((-2,-2),(2,2))'::lseg)"},
    {"point(polygon)","point","point('((0,0),(1,1),(2,0))'::polygon)"},
    {"polygon(box)","polygon","polygon('((0,0),(1,1))'::box)"},
    {"polygon(circle)","polygon","polygon('((0,0),2.0)'::circle)"},
    {"polygon(npts,circle)","polygon","polygon(12,'((0,0),2.0)'::circle)"},
    {"polygon(path)","polygon","polygon('((0,0),(1,1),(2,0))'::path)"},
    {"isoldpath(path)","path","isoldpath('(1,3,0,0,1,1,2,0)'::path)"},
    {"revertpoly(polygon)","polygon","revertpoly('((0,0),(1,1),(2,0))'::polygon)"},
    {"upgradepath(path)","path","upgradepath('(1,3,0,0,1,1,2,0)'::path)"},
    {"upgradepoly(polygon)","polygon","upgradepoly('(0,1,2,0,1,0)'::polygon)"},
    {"broadcast(cidr)","text","broadcast('192.168.1.5/24')"},
    {"broadcast(inet)","text","broadcast('192.168.1.5/24')"},
    {"host(inet)","text","host('192.168.1.5/24')"},
    {"masklen(cidr)","int4","masklen('192.168.1.5/24')"},
    {"masklen(inet)","int4","masklen('192.168.1.5/24')"},
    {"netmask(inet)","text","netmask('192.168.1.5/24')"}
    };

    int counter = 0;
    int index = 0;
    SQLFunctionDataStruc func;

    for(int i=0;i<funcSets.length;i++)
     {
      if(funcSets[i] == 1)
       {
         int word = index + 1;
         func = new SQLFunctionDataStruc(idiom,descriptFunc[index][0],descriptFunc[index][1],
                                         idiom.getWord("FD" + word),descriptFunc[index][2]);    
         index++;
       }
      else
       {
         func = new SQLFunctionDataStruc(idiom);
         for(int j=0;j<funcSets[i];j++) 
          {
           int word = index + 1;
           func.addItem(descriptFunc[index][0],descriptFunc[index][1],idiom.getWord("FD" + word),
                        descriptFunc[index][2]);
           index++;
          }
       }
      funcList[counter] = func;
      counter++;
     }

    return funcList;
  }

 /**
  * METODO main : PRINCIPAL
  * Crea un nuevo objeto XPg que inicializa la aplicacin
  */
 public static void main(String arg[]) {
   final XPg program = new XPg();
   program.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

   // Cierra la aplicacion cuando se hace clic en la X del Frame
   WindowListener l = new WindowAdapter() {    					                        
     public void windowClosing(WindowEvent e) {
      BoolOption killX = new BoolOption(program,program.idiom.getWord("OK"),program.idiom.getWord("CANCEL"),program.idiom.getWord("BOOLEXIT"),program.idiom.getWord("QUESTEXIT"));
      killX.pack();   
      killX.setLocationRelativeTo(program);                                                                 
      killX.show();                                                                    
      boolean sure = killX.getSelecction(); 
      if(sure) {                                                                           
          System.exit(0);
      } else {
          return;
      } 
     }
   }; 
   program.addWindowListener(l);
   program.NConnect();
 }

}
