/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS SQLFunctionDisplay v 0.1                                                   
* Descripcion:
* Esta clase se encarga de mostrar la ayuda referente a una
* funcion SQL propia de postgres.
*
* Esta clase es instanciada desde la clase Queries.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.event.*;
import java.net.URL;
import java.io.*;
import java.util.Vector;

public class SQLFunctionDisplay extends JDialog implements ActionListener
 {
  JButton b1;
  JEditorPane blow;
  String functionName = "";
  boolean isWellDone = false;
  Language idiom;

  public SQLFunctionDisplay(Language lang,JFrame app,String html)
   {
    super(app, true);
    idiom = lang;
    setTitle(idiom.getWord("FDTILE"));
    JPanel panel = new JPanel();
    panel.setLayout(new BorderLayout());

    blow = createEditorPane(html);
    blow.setEditable(false);
    blow.addHyperlinkListener(
         new HyperlinkListener()
           {
             public void hyperlinkUpdate(final HyperlinkEvent e)
              {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED)
                    {
                      blow.setCursor(new Cursor(Cursor.HAND_CURSOR));
                    }
                else
                   if(e.getEventType() == HyperlinkEvent.EventType.EXITED)
                     {
                       blow.setCursor(Cursor.getDefaultCursor());
                     }
                  else
                   if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
                    {
                      functionName = e.getDescription();
                      isWellDone = true;
                      setVisible(false);
                    }
              }
            }
                            );

    panel.add(blow,BorderLayout.CENTER);


    b1 = new JButton(idiom.getWord("CLOSE"));
    b1.setVerticalTextPosition(AbstractButton.CENTER);
    b1.setHorizontalTextPosition(AbstractButton.CENTER);
    b1.setActionCommand("CLOSE");
    b1.addActionListener(this);

    JPanel Panel2 = new JPanel();
    Panel2.setLayout(new FlowLayout());
    Panel2.add(b1);

    JPanel control = new JPanel();
    control.add(Panel2);
    panel.add(b1,BorderLayout.SOUTH);

    setContentPane(panel);
    
   }


  public JEditorPane createEditorPane(String FileName)
   {
    JEditorPane editorPane = new JEditorPane("text/html",FileName);
    editorPane.setEditable(false);

    return editorPane;
   }

  public void actionPerformed(ActionEvent e)
   {
    if(e.getActionCommand().equals("CLOSE"))
     {
       setVisible(false);
       return;
     }
   }

  public boolean isUsed()
   {
     return isWellDone;
   }

  public String getFuncName()
   {
     return functionName;
   }

/*
  public static void main(String[] arg)
   {
    String funcName = "broadcast(inet)";
    String funcType = "text";
    String funcDesc = "construct broadcast address as text";
    String funcExample = "broadcast('192.168.1.5/24')";

    String th = "<th align=\"center\">";
    String td = "<td align=\"center\">";
    String nth = "</th>";
    String ntd = "</td>";
    String ntable = "</table></html>";
    String tr = "<tr>";
    String std = "<td>";
    String ntr = "</tr>";
    String table = "<html><table border=1>" + tr;
    String url1 = "<a href=\"";
    String url2 = "\">";
    String nurl = "</a>";
    String header = table + th + "Function" + nth + th + "Returns" + nth + th + "Description" + nth + th + "Example" + nth + ntr;


    String data = "";
    data += header; 

    data += tr + td + url1;
    data += funcName; 
    data += url2;
    data += funcName;
    data += nurl + ntd + td;
    data += funcType;
    data += ntd + std;
    data += funcDesc;
    data += ntd + td;
    data += funcExample;
    data += ntd + ntr;

    data += tr + td;
    data += "broadcast(inet)";
    data += ntd + td + "text" + ntd + std + "construct broadcast address as text" + ntd + td + "broadcast('192.168.1.5/24')" + ntd + ntr;

    data += ntable; 

     JFrame f = new SQLFunctionDisplay(data);
     f.addWindowListener(new WindowAdapter()
       {
         public void windowClosing(WindowEvent e)
          {
            System.exit(0);
          }
       });

   }
*/
}
