/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ReportFooter v 0.1                                                   
* Descripcion:
* Clase encargada de manejar el cuadro de dialogo mediante
* el cual se seleccionan las caracteristicas del pie de pagina
* para un reporte.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*; 

public class ReportFooter extends JDialog implements ActionListener{

 JComboBox Fstyle;
 JComboBox Fsize; 
 JTextArea HeaderText;
 JTextField dimen;
 JTextField sizeT;
 JPanel pColor;
 String fontC = "#000000";
 String Cola = "";
 boolean wellDone = false;
 Language idiom;

public ReportFooter(Language leng,JDialog dialog,JFrame parent)
 {               
  super(dialog,true);                  
  idiom = leng;
  setTitle(idiom.getWord("REPFSETT"));
  getContentPane().setLayout(new BorderLayout()); 
  HeaderText = new JTextArea(5,5);
  JScrollPane holdHeader = new JScrollPane(HeaderText);
  JPanel Header = new JPanel();
  Header.setLayout(new BorderLayout());
  Border etched1 = BorderFactory.createEtchedBorder();
  TitledBorder title1; 
  JPanel nH = new JPanel();
  nH.setLayout(new GridLayout(1,0));
  JPanel cH = new JPanel();
  cH.setLayout(new BorderLayout());
  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("FOOTT"));
  cH.setBorder(title1);
 
  JPanel FontPanel = new JPanel();
   FontPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
 
  String[] values = {"Arial","Arial Black","Arial Narrow","Book Antiqua","Bookman Old Style","Calixto MT","Century Gothic","Comic Sans MS","Copperplate Gothic Bold","Copperplate Gothic Light","Courier New","Garamond","Impact","Lucida Console","Lucida Handwriting","Lucida Sans","Lucida Sans Unicode","Map Symbols","Marlett","Matisse ITC","Monotype Sorts","MS Outlook","MT Extra","News Gothic MT","OCR A Extended","Symbol","Tahoma","Tempus Sans ITC","Times New Roman","Verdana","Webdings","Westminster","Wingdings"};

  JLabel style = new JLabel(idiom.getWord("STYLE") + ": ");
  Fstyle = new JComboBox(values);
  JLabel size = new JLabel(" " + idiom.getWord("LONGTYPE") + ": ");
  String[] values1 = {"1","2","3","4"};
  Fsize = new JComboBox(values1);
  JButton Fcolor = new JButton(idiom.getWord("FCOLOR"));
  Fcolor.setActionCommand("COLOR");
  Fcolor.addActionListener(this);
  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("FSETT"));
  FontPanel.setBorder(title1);
  pColor = new JPanel();
  pColor.setPreferredSize(new Dimension(15,15));
  title1 = BorderFactory.createTitledBorder(etched1);
  pColor.setBorder(title1);
  pColor.setBackground(Color.black);

  FontPanel.add(style);
  FontPanel.add(Fstyle);
  FontPanel.add(size);
  FontPanel.add(Fsize);
  FontPanel.add(Fcolor); 
  FontPanel.add(pColor);

  JPanel sH = new JPanel();
  sH.setLayout(new FlowLayout(FlowLayout.CENTER));
  title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("SLINE"));
  sH.setBorder(title1);
  JLabel width = new JLabel(idiom.getWord("W"),JLabel.CENTER); 
  dimen = new JTextField(3);
  JLabel percent = new JLabel("%",JLabel.CENTER);
  JLabel sizeB = new JLabel(" " + idiom.getWord("LONGTYPE") + ": ",JLabel.CENTER);
  sizeT = new JTextField(2);
  sH.add(width); 
  sH.add(dimen);
  sH.add(percent);
  sH.add(sizeB);
  sH.add(sizeT);

  nH.add(FontPanel);
  cH.add(holdHeader,BorderLayout.CENTER);
  Header.add(nH,BorderLayout.NORTH);
  Header.add(cH,BorderLayout.CENTER);
  Header.add(sH,BorderLayout.SOUTH); 

  JButton ok = new JButton(idiom.getWord("OK"));
  ok.setActionCommand("ButtonOk");
  ok.addActionListener(this);
  JButton cancel = new JButton(idiom.getWord("CANCEL"));
  cancel.setActionCommand("ButtonCancel");
  cancel.addActionListener(this); 
  JPanel botonD = new JPanel();
  botonD.setLayout(new FlowLayout(FlowLayout.CENTER));
  botonD.add(ok);
  botonD.add(cancel);

  getContentPane().add(Header,BorderLayout.CENTER);
  getContentPane().add(botonD,BorderLayout.SOUTH);
  pack();
  setLocationRelativeTo(parent);
  setVisible(true); 
 }

 public void actionPerformed(java.awt.event.ActionEvent e) 
  {

   if(e.getActionCommand().equals("COLOR"))
    {
      Color newColor = JColorChooser.showDialog(ReportFooter.this,idiom.getWord("CTC"),Color.white);
      if (newColor != null) 
       {
        pColor.setBackground(newColor);
        int valR = newColor.getRed();
        int valG = newColor.getGreen();
        int valB = newColor.getBlue();
       }    
    }

   if(e.getActionCommand().equals("ButtonCancel"))
    {
      setVisible(false);
    }

   if(e.getActionCommand().equals("ButtonOk"))
    {
      String FootText = HeaderText.getText();
      String fontSt = (String) Fstyle.getSelectedItem();
      String fontSz = (String) Fsize.getSelectedItem();
      String largo = dimen.getText();
      String ancho = sizeT.getText();
      String FontTag = "";
      String hr = "";

      if(largo.length()>0 && ancho.length()>0)
       {
        if(!isNum(largo))
         {
          JOptionPane.showMessageDialog(ReportFooter.this,
                                  idiom.getWord("HRW"),
                                  idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);

          return;
         }

        if(!isNum(ancho))
         {
          JOptionPane.showMessageDialog(ReportFooter.this,
                                  idiom.getWord("HRS"),
                                  idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);

          return;
         }

          hr = "<hr size=" + ancho + " width=" + largo + "></center>";
       }

      if(FootText.length()>0) 
       {
         FontTag = "<font face=\"" + fontSt + "\" " + "size=" + fontSz + " color=\"" + fontC + "\">";
         FontTag += "<blockquote><blockquote>" + FootText + "</blockquote></blockquote></font>";
       }

      Cola = hr + FontTag;
      wellDone=true;
      setVisible(false);
     }
 }

 public boolean isNum(String s)
  {
    for(int i = 0; i < s.length(); i++)
     {
      char c = s.charAt(i);
      if(!Character.isDigit(c))
          return false;
     }

    return true;
  }


} //Fin de la Clase
