/* $PostgresPy: pl/src/pl.h,v 1.10 2004/06/29 00:09:52 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Header file for pl.c for use by the abstract procedural
 *    language, and by the specific language implementation.
 *    Many of the function prototypes, macros, definitions, and
 *    externs serve as documentation for authors implementing
 *    a specific language.
 */
#ifndef PL_H
#define PL_H "pl.h"

#define PL_VERSION
#define PL_RELEASE 20040122
#define PL_COMPILE "void"

/*
 *	Compile time information.
 */
extern const unsigned short	pl_version;
extern const unsigned long		pl_release;

/*
 * The pg_language tuple, resolved in pl_initialize()
 */
extern HeapTuple					Language;

/*
 * The procedural language context(Top, atm)
 * The former context that the language was invoked under
 */
extern MemoryContext	plcontext;
extern MemoryContext	plFormerContext;

/*
 * Reset count of the procedural language.(times successfully, initialized)
 * Mainly for static variables that need to be reinitialized after resets.
 */
extern unsigned short pl_inits;
extern const char *	 language_name;

/*
 * Abstract type for function structures
 */
typedef void * plproc;


/*
 * Language Specific Prototypes:
 */
void		lang_initialize(void);
void		lang_finalize(void);

/*
 * Returns the error string to be given to the user.
 */
void *	lang_error();
char *	lang_errorstr();

/* 
 * Language Ereport
 */
#define lereport(msg,...) FMACRO( \
	if( lang_error() ) ereport(ERROR,( \
		errmsg(msg), \
		errdetail("%s", lang_errorstr()),#__VA_ARGS__ \
	)); \
)

/*
 * Returns a pointer to the language specific procedure.
 *		Name, Source, type of procedure
 */
plproc 	plproc_FromSource(HeapTuple, char *);

/*
 * Returning NULL without a language error means the language
 * does not support binary compilation. Just get it from the source.
 */
char *	plproc_ToBinary(plproc, Size *);
plproc	plproc_FromBinary(char *, Size);

/*
 * Disposes of the language dependent plproc structure.
 */
void		plproc_free(plproc);

/**
 * End of User specified routines.
 **/

/*
 * plcache is the key to pl's use. It provides the common
 * functionality that most procedural languages will utilize
 * one way or another.
 */
struct plcache
{
	Oid				fn_oid;
	HeapTuple		proc;
#ifdef Anum_pg_proc_proargnames
	char *			argnames[FUNC_MAX_ARGS];
#endif

	plproc			code;
	void *			meta; /* XXX: Might disapear */
};

bytea * mkbytea(const char *, Size);
HeapTuple ProcTuple_FromOid(Oid);

#define FC_FNOID	fcinfo->flinfo->fn_oid
#define FC_FNEXTRA fcinfo->flinfo->fn_extra
#define HeapTupleGetXmin(TUP) (HeapTupleHeaderGetXmin((TUP)->t_data))

#endif
