/* $PostgresPy: if/src/portal.h,v 1.2 2004/07/27 16:19:41 flaw Exp $
 *
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 *//*
 * Postgres Portal Interface
 */
#ifndef PyPg_PORTAL_H
#define PyPg_PORTAL_H "portal.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef void (*DRReceive) (HeapTuple, TupleDesc, DestReceiver *);
typedef void (*DRStartup) (DestReceiver *, int, TupleDesc);
typedef void (*DRShutdown) (DestReceiver *);
typedef void (*DRDestroy) (DestReceiver *);

struct PgPortalReceiver
{
	DRReceive receive;
	DRStartup startup;
	DRShutdown shutdown;
	DRDestroy destroy;
	CommandDest dest;
	struct PyPgPortal *self;
};

typedef struct PyPgPortal {
	PyObject_HEAD
	PyObj query, tup, tdo;

	Portal portal;
	struct PgPortalReceiver dest;
} *PgPortal;

extern PyTypeObject PyPgPortal_Type;
#define PgPortal_NEW() (PgPortal)PyPgPortal_Type.tp_alloc(&PyPgPortal_Type, 0)

#define PgPortal_TypeCheck(OB) (PyObject_TypeCheck(OB, &PyPgPortal_Type))
#define PgPortal_TypeCheckExact(OB) (OB->ob_type == &PyPgPortal_Type)

PgPortal PgPortal_New(PgQuery, Query *, Plan *, ParamListInfo);
#ifdef __cplusplus
}
#endif
#endif /* !PyPg_PORTAL_H */
