/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.File;
import java.io.FilePermission;
import java.security.Permission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.EOXactListener;
import org.postgresql.pljava.internal.Session;
import org.postgresql.pljava.management.Commands;

public class Backend {
    public static final Object THREADLOCK = new Object();
    private static Session s_session;
    private static boolean s_inSetTrusted;
    private static final SecurityManager s_untrustedSecurityManager;
    private static final SecurityManager s_trustedSecurityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Session getSession() {
        if (s_session == null) {
            s_session = new Session();
            Object object = THREADLOCK;
            synchronized (object) {
                Backend._addEOXactListener(s_session);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (s_session != null) {
                        Backend._removeEOXactListener(s_session);
                    }
                    s_session = null;
                }
            });
        }
        return s_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigOption(String string) {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getConfigOption(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatementCacheSize() {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getStatementCacheSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int n, String string) {
        Object object = THREADLOCK;
        synchronized (object) {
            Backend._log(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClassImages(Connection connection, int n, String string) throws SQLException {
        if (System.getSecurityManager() == s_trustedSecurityManager) {
            try {
                Backend.setTrusted(false);
                Commands.addClassImages(connection, n, string);
            }
            finally {
                Backend.setTrusted(true);
            }
        } else {
            Commands.addClassImages(connection, n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTrusted(boolean bl) {
        s_inSetTrusted = true;
        try {
            Logger logger = Logger.getAnonymousLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Using SecurityManager for " + (bl ? "trusted" : "untrusted") + " language");
            }
            System.setSecurityManager(bl ? s_trustedSecurityManager : s_untrustedSecurityManager);
        }
        finally {
            s_inSetTrusted = false;
        }
    }

    public static native boolean isCallingJava();

    public static native boolean isReleaseLingeringSavepoints();

    private static native String _getConfigOption(String var0);

    private static native int _getStatementCacheSize();

    private static native void _log(int var0, String var1);

    private static native void _addEOXactListener(EOXactListener var0);

    private static native void _removeEOXactListener(EOXactListener var0);

    static {
        s_inSetTrusted = false;
        s_untrustedSecurityManager = new PLJavaSecurityManager();
        s_trustedSecurityManager = new PLJavaSecurityManager(){

            void assertPermission(Permission permission) {
                if (permission instanceof FilePermission) {
                    String string = permission.getActions();
                    if ("read".equals(string)) {
                        File file = new File(System.getProperty("java.home"));
                        File file2 = new File(permission.getName());
                        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
                            if (!file3.equals(file)) continue;
                            return;
                        }
                    }
                    throw new SecurityException(permission.getActions() + " on " + permission.getName());
                }
                super.assertPermission(permission);
            }
        };
    }

    private static class PLJavaSecurityManager
    extends SecurityManager {
        private boolean m_recursion = false;

        private PLJavaSecurityManager() {
        }

        public void checkPermission(Permission permission) {
            this.nonRecursiveCheck(permission);
        }

        public void checkPermission(Permission permission, Object object) {
            this.nonRecursiveCheck(permission);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void nonRecursiveCheck(Permission permission) {
            if (this.m_recursion) {
                return;
            }
            this.m_recursion = true;
            try {
                this.assertPermission(permission);
            }
            finally {
                this.m_recursion = false;
            }
        }

        void assertPermission(Permission permission) {
            if (permission instanceof RuntimePermission) {
                String string = permission.getName();
                if ("*".equals(string) || "exitVM".equals(string)) {
                    throw new SecurityException();
                }
                if ("setSecurityManager".equals(string) && !s_inSetTrusted) {
                    throw new SecurityException();
                }
            } else if (permission instanceof PropertyPermission && permission.getActions().indexOf("write") >= 0 && permission.getName().startsWith("java.")) {
                throw new SecurityException();
            }
        }
    }
}

