<?php // $Id: lib-expire.inc.php,v 1.11 2001/07/28 14:10:40 ciaccia Exp $ - #phpAdsNew Revision: 1.7 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// Define constants
define ("phpAds_Clicks", 1);
define ("phpAds_Views", 2);



/*********************************************************/
/* Check the expiration of a client				         */
/*********************************************************/

function phpAds_expire ($clientid, $type=0)
{
	global $phpAds_tbl_clients, $phpAds_tbl_banners, $phpAds_warn_limit;
	
	// Get client information
	$campaignresult = db_query("SELECT *, expire <> NULL AND expire < NOW() as expired FROM $phpAds_tbl_clients WHERE clientid = $clientid");
	
	if ($campaign = pg_fetch_array($campaignresult, 0))
	{
		// Decrement views
		if (($campaign["views"] > 0) and ($type == phpAds_Views))
		{
			$campaign["views"] = $campaign["views"] - 1;
			
			// Mail warning - preset is reached
			if ($campaign["views"] == $phpAds_warn_limit)
				warn_mail($campaign);
			
			db_query("UPDATE $phpAds_tbl_clients SET views=views-1 WHERE clientid=$clientid");
		}
		
		// Decrement clicks
		if (($campaign["clicks"] > 0) and ($type == phpAds_Clicks))
		{
			$campaign["clicks"] = $campaign["clicks"] - 1;
			
			db_query("UPDATE $phpAds_tbl_clients SET clicks=clicks-1 WHERE clientid=$clientid");
		}
		 
		
		// Check view count and de-activate banner if needed
		// Check activation status
		$active = "t";
		
		if ($campaign["clicks"] == 0 || $campaign["views"] == 0)
			$active = "f";
		
		if ($campaign["expired"])
			$active = "f";

		if ($campaign["active"] != $active)
		{
			db_query("UPDATE $phpAds_tbl_clients SET active='$active' WHERE clientid=$clientid");
		}
		
		if ($active == 't')
		{
			// Send deactivation warning
			phpAds_deactivateMail ($campaign);
		}
	}
}



/*********************************************************/
/* Mail warning - preset is reached						 */
/*********************************************************/

function phpAds_warningMail ($campaign)
{
	global $phpAds_warn_limit, $phpAds_warn_admin, $phpAds_warn_client;
	global $phpAds_admin_email, $phpAds_admin_email_headers, $phpAds_admin_fullname;
	global $strViewsClicksLow, $strMailHeader, $strWarnClientTxt, $strMailNothingLeft, $strMailFooter;
	global $phpAds_tbl_clients, $phpAds_language, $phpAds_path;
	
	if ($phpAds_warn_admin=='1' || $phpAds_warn_client=='1')
	{
		// Get the client which belongs to this campaign
		$clientresult = db_query("SELECT * FROM $phpAds_tbl_clients WHERE clientid=".$campaign['parent']);
		if ($client = @pg_fetch_array($clientresult, 0))
		{
			// Load client language strings
			if (isset($client["language"]) && $client["language"] != "")
				include ("$phpAds_path/language/".$client["language"].".inc.php");
			else
				include ("$phpAds_path/language/$phpAds_language.inc.php");		
			
			
			$Subject = $strViewsClicksLow.": ".$campaign["clientname"];
			
			$Body    = "$strMailHeader\n";
			$Body 	.= "$strWarnClientTxt\n";
			$Body 	.= "$strMailNothingLeft\n\n";
			$Body   .= "$strMailFooter";
			
			$Body    = str_replace ("{clientname}", $campaign["clientname"], $Body);
			$Body	 = str_replace ("{contact}", $client["contact"], $Body);
			$Body    = str_replace ("{adminfullname}", $phpAds_admin_fullname, $Body);
			$Body    = str_replace ("{limit}", $phpAds_warn_limit, $Body);
			
			
			if ($phpAds_warn_admin == '1')
				@mail($phpAds_admin_email, $Subject, $Body, $phpAds_admin_email_headers);
			
			if ($client["email"] != '')
			{
				$To = $client["contact"]." <".$client["email"].">";
				
				if ($phpAds_warn_client == '1')
					@mail($To, $Subject, $Body, $phpAds_admin_email_headers);
			}
		}
	}
}



/*********************************************************/
/* Mail warning - preset is reached						 */
/*********************************************************/

function phpAds_deactivateMail ($campaign)
{
	global $phpAds_tbl_clients, $phpAds_tbl_banners;
	global $strMailSubjectDeleted, $strMailHeader, $strMailClientDeactivated;
	global $strNoMoreClicks, $strNoMoreViews, $strBeforeActivate, $strAfterExpire;
	global $strBanner, $strMailNothingLeft, $strMailFooter;
	global $phpAds_admin_fullname, $phpAds_admin_email_headers;
	global $strUntitled, $phpAds_language, $phpAds_path;
	
	$clientresult = db_query("SELECT * FROM $phpAds_tbl_clients WHERE clientid=".$campaign['parent']);
	if ($client = @pg_fetch_array($clientresult))
	{
		if ($client["email"] != '' && $client["reportdeactivate"] == 't')
		{
			// Load client language strings
			if (isset($client["language"]) && $client["language"] != "")
				include ("$phpAds_path/language/".$client["language"].".inc.php");
			else
				include ("$phpAds_path/language/$phpAds_language.inc.php");		
			
			$Subject = $strMailSubjectDeleted.": ".$campaign["clientname"];
	   		$To		 = $client["contact"]." <".$client["email"].">";
			
			$Body = "$strMailHeader\n";
			$Body .= $strMailClientDeactivated;
			if ($campaign['clicks'] == 0) 			$Body .= ", $strNoMoreClicks";
			if ($campaign['views'] == 0) 			$Body .= ", $strNoMoreViews";
			if (time() < $campaign["activate_st"])	$Body .= ", $strBeforeActivate";
			if (time() > $campaign["expire_st"] && $campaign["expire_st"] != 0)
			$Body .= ", $strAfterExpire";
			$Body .= ".\n\n";
			
			
			$res_banners = db_query("
				SELECT
					bannerid,
					URL,
					description,
					alt
				FROM
					$phpAds_tbl_banners
				WHERE
					clientid = ".$campaign['clientid']."
				");
			
			if (pg_numrows($res_banners) > 0)
			{
				$Body .= "-------------------------------------------------------\n";
				
				for ($pgj = 0; $row_banners = @pg_fetch_array($res_banners, $pgj); $pgj++)
				{
					$name = "[id".$row_banners['bannerid']."] ";
					
					if ($row_banners['description'] != "")
						$name .= $row_banners['description'];
					elseif ($row_banners['alt'] != "")
						$name .= $row_banners['alt'];
					else
						$name .= $strUntitled;
					
					$Body .= $strBanner."  ".$name."\n";
					$Body .= "linked to: ".$row_banners['URL']."\n";
					$Body .= "-------------------------------------------------------\n";
				}
			}
			
			$Body .= "\n";
			$Body .= "$strMailNothingLeft\n\n";
			$Body .= "$strMailFooter";
			
			$Body  = str_replace ("{clientname}", $client["clientname"], $Body);
			$Body  = str_replace ("{contact}", $client["contact"], $Body);
			$Body  = str_replace ("{adminfullname}", $phpAds_admin_fullname, $Body);
			
			@mail ($To, $Subject, $Body, $phpAds_admin_email_headers);
			unset ($Subject) ;
		}
	}
}

?>