<?php // $Id: campaignoverview.plugin.php,v 1.2 2001/07/09 16:43:06 ciaccia Exp $ - #phpAdsNew Revision: 1.2 #

/************************************************************************/
/* phpPgAds - Campaign Overview Plugin 1.0                              */
/* =======================================                              */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


// Public name of the plugin info function
$plugin_info_function		= "Plugin_CampaignoverviewInfo";


// Public info function
function Plugin_CampaignoverviewInfo()
{
	$plugininfo = array (
		"plugin-name"			=> "Campaign Overview",
		"plugin-description"	=> "Generate an overview of the selected campaign.
									The report is exported as CSV for use in a spreadsheet.",
		"plugin-author"			=> "Niels Leenheer",
		"plugin-export"			=> "csv",
		"plugin-authorize"		=> phpAds_Admin+phpAds_Client,
		"plugin-execute"		=> "Plugin_CampaignoverviewExecute",
		"plugin-import"			=> array (
			"campaignid"			=> array (
				"title"					=> "Campaign",
				"type"					=> "campaignid-dropdown" ),
			"delimiter"		=> array (
				"title"					=> "Delimiter",
				"type"					=> "edit",
				"size"					=> 1,
				"default"				=> "," ) )
	);
	
	return ($plugininfo);
}



/*********************************************************/
/* Private plugin function                               */
/*********************************************************/

function Plugin_CampaignoverviewExecute($campaignid, $delimiter=",")
{
	global $phpAds_tbl_banners, $phpAds_tbl_adstats, $phpAds_tbl_adviews, $phpAds_tbl_adclicks;
	global $phpAds_compact_stats;
	
	header ("Content-type: application/csv\nContent-Disposition: \"attachment; filename=campaignoverview.csv\"");
	
	if ($phpAds_compact_stats)
	{
		$res_query = "
		SELECT
			$phpAds_tbl_banners.bannerid as bannerid,
			$phpAds_tbl_banners.description as description,
			$phpAds_tbl_banners.alt as alt,
			SUM($phpAds_tbl_adstats.views) as adviews,
			SUM($phpAds_tbl_adstats.clicks) as adclicks
		FROM
			$phpAds_tbl_banners,
			$phpAds_tbl_adstats
		WHERE
			$phpAds_tbl_banners.clientid = $campaignid
			AND $phpAds_tbl_banners.bannerid = $phpAds_tbl_adstats.bannerid
		GROUP BY
			$phpAds_tbl_banners.bannerid, description, alt
		UNION
		SELECT 
			$phpAds_tbl_banners.bannerid as bannerid,
			$phpAds_tbl_banners.description as description,
			$phpAds_tbl_banners.alt as alt,
			0::int4 as adviews,
			0::int4 as adclicks
		FROM
			$phpAds_tbl_banners
		WHERE
			$phpAds_tbl_banners.clientid = $campaignid
			AND $phpAds_tbl_banners.bannerid NOT IN (SELECT bannerid FROM $phpAds_tbl_adstats)
			";
		
		$res_banners = db_query($res_query) or pg_die();
		
	for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
		{
			$stats [$row_banners['bannerid']]['views'] = $row_banners['adviews'];
			$stats [$row_banners['bannerid']]['clicks'] = $row_banners['adclicks'];
			$stats [$row_banners['bannerid']]['description'] = $row_banners['description'];
			$stats [$row_banners['bannerid']]['alt'] = $row_banners['alt'];
		}
	}
	else
	{
		$res_query = "
		SELECT
			$phpAds_tbl_banners.bannerid as bannerid,
			$phpAds_tbl_banners.description as description,
			$phpAds_tbl_banners.alt as alt,
			COUNT($phpAds_tbl_adviews.bannerid) as adviews
		FROM
			$phpAds_tbl_banners,
			$phpAds_tbl_adviews
		WHERE
			$phpAds_tbl_banners.clientid = $campaignid
			AND $phpAds_tbl_banners.bannerid = $phpAds_tbl_adviews.bannerid
		GROUP BY
			$phpAds_tbl_banners.bannerid, description, alt
		UNION
		SELECT
			$phpAds_tbl_banners.bannerid as bannerid,
			$phpAds_tbl_banners.description as description,
			$phpAds_tbl_banners.alt as alt,
			0 as adviews
		FROM
			$phpAds_tbl_banners
		WHERE
			$phpAds_tbl_banners.clientid = $campaignid
			AND $phpAds_tbl_banners.bannerid NOT IN (SELECT bannerid FROM $phpAds_tbl_adviews)
			";
		
		$res_banners = db_query($res_query) or pg_die();
		
	for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
		{
			$stats [$row_banners['bannerid']]['views'] = $row_banners['adviews'];
			$stats [$row_banners['bannerid']]['description'] = $row_banners['description'];
			$stats [$row_banners['bannerid']]['alt'] = $row_banners['alt'];
		}
		
		$res_query = "
		SELECT
			$phpAds_tbl_banners.bannerid as bannerid,
			COUNT($phpAds_tbl_adviews.bannerid) as adclicks
		FROM
			$phpAds_tbl_banners,
			$phpAds_tbl_adclicks
		WHERE
			$phpAds_tbl_banners.clientid = $campaignid
			AND $phpAds_tbl_banners.bannerid = $phpAds_tbl_adclicks.bannerid
		GROUP BY
			$phpAds_tbl_banners.bannerid
		UNION
		SELECT
			$phpAds_tbl_banners.bannerid as bannerid,
			0 as adcliks
		FROM
			$phpAds_tbl_banners
		WHERE
			$phpAds_tbl_banners.clientid = $campaignid
			AND $phpAds_tbl_banners.bannerid NOT IN (SELECT bannerid FROM $phpAds_tbl_adclicks)
			";
		
		$res_banners = db_query($res_query) or pg_die();
		
	for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
		{
			$stats [$row_banners['bannerid']]['clicks'] = $row_banners['adclicks'];
			$stats [$row_banners['bannerid']]['description'] = $row_banners['description'];
			$stats [$row_banners['bannerid']]['alt'] = $row_banners['alt'];
		}
	}
	
	echo "Campaign: ".phpAds_getClientName ($campaignid)."\n\n";
	echo "Banner".$delimiter."AdViews".$delimiter."AdClicks".$delimiter."CTR\n";
	
	$totalclicks = 0;
	$totalviews = 0;
	
	if (isset($stats) && is_array($stats))
	{
		for (reset($stats);$key=key($stats);next($stats))
		{
			$row = array();
			
			$row[] = phpAds_buildBannerName ($key, $stats[$key]['description'], $stats[$key]['alt']);
			$row[] = $stats[$key]['views'];
			$row[] = $stats[$key]['clicks'];
			$row[] = phpAds_buildCTR ($stats[$key]['views'], $stats[$key]['clicks']);
			
			echo implode ($delimiter, $row)."\n";
			
			$totalclicks += $stats[$key]['clicks'];
			$totalviews += $stats[$key]['views'];
		}
	}
	
	echo "\n";
	echo "Total".$delimiter.$totalviews.$delimiter.$totalclicks.$delimiter.phpAds_buildCTR ($totalviews, $totalclicks)."\n";
}

?>