/*-------------------------------------------------------------------------
 *
 * FILE
 *    uuid.h
 *
 * DESCRIPTION
 *    Head file for UUID
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 */
#ifndef __UUID_H__
#define __UUID_H__

#include <time.h>

#include <sys/time.h>
#include <sys/types.h>

#define TIME_OFFSET_HIGH 0x01B21DD2
#define TIME_OFFSET_LOW  0x13814000

#define UUID_VARIANT_NCS 	0
#define UUID_VARIANT_DCE 	1
#define UUID_VARIANT_MICROSOFT	2
#define UUID_VARIANT_OTHER	3

#define UUID_TYPE_NIL 0
#define UUID_TYPE_TIME_BASE 1
#define UUID_TYPE_NAME_BASE 3
#define UUID_TYPE_RANDOM_BASE 4

typedef u_int32_t uuid_u32_t; /* == 32 bits */
typedef u_int16_t uuid_u16_t; /* == 16 bits */
typedef u_int8_t  uuid_u8_t;  /* == 8 bits */

typedef u_int64_t uuid_u64_t; /* == 64 bits */

/*
typedef struct _macaddr_t
{
	uuid_u8_t a;
	uuid_u8_t b;
	uuid_u8_t c;
	uuid_u8_t d;
	uuid_u8_t e;
	uuid_u8_t f;
}macaddr_t;

typedef struct _uuid_t
{
	uuid_u32_t time_low;
	uuid_u16_t time_mid;
	uuid_u16_t time_hi_and_version;
	uuid_u16_t clock_seq;
	macaddr_t  node;
} uuid_t;
*/

typedef struct _uuid_t
{
	uuid_u32_t time_low;
	uuid_u16_t time_mid;
	uuid_u16_t time_hi_and_version;
	uuid_u16_t clock_seq;
	uuid_u8_t  node[6];
} uuid_t;

typedef uuid_t* uuid_p;

#ifdef __cplusplus
extern "C" {
#endif

/* generate function */
int uuid_generate_random(uuid_p);
int uuid_generate_time(uuid_p);
int uuid_generate_nil(uuid_p);
int uuid_generate_name(const uuid_p, const char[], uuid_p);
int uuid_generate_name2(const char[], const char[], uuid_p);

/* convert function */
int uuid_parse(const char[], uuid_p);
int uuid_unparse(const uuid_p, char[]);

/* common function */
int uuid_type(const uuid_p);
int uuid_variant(const uuid_p);

/* compare function */
int uuid_compare(const uuid_p, const uuid_p);

/* time-base uuid only tool function */
int uuid_time(const uuid_p, struct timeval*);
/* int uuid_mac(const uuid_p, macaddr_t*); */

#ifdef __cplusplus
}
#endif

#endif /* __UUID_H__ */
