#include "server/postgres.h"
#include "server/fmgr.h"

extern int SablotProcessStrings(char *styleSheetStr, char *inputStr, char **resultStr);

static char *text2char(const text *s)
{
	char *t = NULL;

	if(s) {
		size_t len = VARSIZE(s) - VARHDRSZ;

		t = palloc(len + 1);
		memcpy(t, VARDATA(s), len);
		t[len] = 0;
	}

	return t;
}

static text *char2text(const char *s)
{
	text *t = NULL;

	if(s) {
		size_t len = strlen(s) + VARHDRSZ;

		t = palloc(len);
		memcpy(VARDATA(t), s, len - VARHDRSZ);
		VARATT_SIZEP(t) = len;
	}

	return t;
}

Datum xslt(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(xslt);

Datum xslt(PG_FUNCTION_ARGS)
{
	text	*xslText = PG_GETARG_TEXT_P(0);		/* style sheet buffer */
	text	*xmlText = PG_GETARG_TEXT_P(1);		/* document buffer */
	text	*resText;				/* result buffer */
	char	*xsl, *xml, *res;			/* temporary buffers */
	int	err;

	xsl = text2char(xslText);
	xml = text2char(xmlText);

	err = SablotProcessStrings(xsl, xml, &res);

	pfree(xsl);
	pfree(xml);

	if(err) {
		PG_RETURN_NULL();
	} else {
		resText = char2text(res);

		SablotFree(res);

		PG_RETURN_TEXT_P(resText);
	}
}
