<?php
/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/* We use UNIONs and not OUTER JOINS to support PostgreSQL < 7.1 */

$DBMS_FALSE = "FALSE";
$DBMS_TRUE = "TRUE";

function get_category_info(&$qid, $id) {

	global $SESSION;

	$qid->Query("
		SELECT
			 c.id
			,c.name
			,l.name AS lname
			,c.special_level
			,c.description
		FROM categories c, categories_i18n l
		WHERE c.id = l.category_id AND l.lang = '$SESSION[i18n]' AND c.id = '$id'
		UNION     
		SELECT
			 c.id
			,c.name
			,'' AS lname
			,c.special_level
			,c.description
		FROM categories c
		WHERE c.id = '$id'
		AND c.id NOT IN (
			SELECT category_id FROM categories_i18n WHERE lang = '$SESSION[i18n]'
		)
	");
}

function get_allcategories_info(&$qid) {

	global $SESSION;

	$qid->Query("
		SELECT
			 c.id
			,c.name
			,l.name AS lname
			,c.special_level
			,c.description
			,parent.name AS parent
		FROM categories c, categories_i18n l, categories parent
		WHERE c.id = l.category_id AND c.parent_id = parent.id AND l.lang = '$SESSION[i18n]' AND c.id > 1
		UNION
		SELECT
			 c.id
			,c.name
			,'' AS lname
			,c.special_level
			,c.description
			,parent.name AS parent
		FROM categories c, categories parent
		WHERE c.parent_id = parent.id AND c.id > 1
		AND c.id NOT IN (
			SELECT category_id FROM categories_i18n WHERE lang = '$SESSION[i18n]'
		)
		ORDER BY name, special_level
	");
}

function get_product_info(&$qid, $product_id) {

	global $SESSION;

	$qid->Query("
		SELECT
			 p.id AS product_id
			,p.name
			,l.name AS lname
			,p.description
			,l.description AS ldescription
			,p.extended_description
			,l.extended_description AS lextended_description
		FROM products p, products_i18n l
		WHERE p.id = l.product_id AND l.lang = '$SESSION[i18n]' AND p.id = '$product_id'
		UNION     
		SELECT
			 p.id AS product_id
			,p.name
			,'' AS lname
			,p.description
			,'' AS ldescription
			,p.extended_description
			,'' AS lextended_description
		FROM products p
		WHERE p.id = '$product_id'
		AND p.id NOT IN (
			SELECT product_id FROM products_i18n WHERE lang = '$SESSION[i18n]'
		)
	");
}

function get_allproducts_info(&$qid) {

	global $SESSION;

	$qid->Query("
		SELECT
			 p.id AS product_id
			,p.name
			,l.name AS lname
			,p.special_level
			,p.description
		FROM products p, products_i18n l
		WHERE p.id = l.product_id AND l.lang = '$SESSION[i18n]'
		UNION
		SELECT
			 p.id AS product_id
			,p.name
			,'' AS lname
			,p.special_level
			,p.description
		FROM products p
		WHERE p.id NOT IN (
			SELECT product_id FROM products_i18n WHERE lang = '$SESSION[i18n]'
		)
		ORDER BY name, special_level
	");
}

?>
