<?php
/* (c) 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */
/* with contribution for the script structure 
   from categories.php (c) 2000 Ying Zhang (ying@zippydesign.com) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");

$qid = new PGM_Sql;

$DOC_TITLE = "IVA_Management";
include ("header.php");

switch (nvl($mode)) {
	case "add" :
		print_add_iva_form();
		break;

	case "edit" :
		if (!($id == 0))
			print_edit_iva_form($id);
		break;

	case "del" :
		if (!($id == 0))
			delete_iva($id);
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_iva($HTTP_POST_VARS["iva"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_iva($HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["iva"] = $HTTP_POST_VARS["iva"];
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = "Add_IVA";
			include ("$CFG->dirroot" . "/form_header.php");
			load_iva_form_template($frm, $id, $errors);
		}
		break;

	case "update" :
		if ($id == 0)
			break;
		$errors = new Object;
		$errormsg = "";
		validate_iva($HTTP_POST_VARS["iva"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_iva($id, $HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["iva"] = $HTTP_POST_VARS["iva"];
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			include ("$CFG->dirroot" . "/form_header.php");
			load_iva_form_template($frm, $id, $errors);
		}
		break;

	case "import" :
		print_import_iva_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_iva_form();
		else
			import_iva($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_iva_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_iva_form_template($frm, $id, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/iva_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"		=> $frm["newmode"],
		"iva_id"		=> $id,
		"frm_iva"		=> $frm["iva"],
		"errors_iva"		=> errmsg($errors->iva),
		"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function print_add_iva_form() {
/* print a blank iva form so we can add a new iva percentage */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	/* set default values for the reset of the fields */
	$frm["newmode"] = "insert";
	$frm["iva"] = "";
	$frm["submit_caption"] = "Add_IVA";

	load_iva_form_template($frm, $id, $errors);
}

function print_edit_iva_form($id) {
/* print an iva form so we can edit the selected iva percentage */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the iva percentage */
	$qid->Query("SELECT iva FROM iva WHERE id = '$id'");
	$qid->next_record();
	$frm["iva"] = $qid->f("iva");

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	load_iva_form_template($frm, $id, $errors);
}

function delete_iva($id) {
// delete the iva percentage specified by $id, and reset to 0
// the iva_id for all products with this iva percentage

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->begin();

	/* select the iva percentage to be deleted */
	$qid->Query("SELECT iva FROM iva WHERE id = '$id'");
	$qid->next_record();
	$frm["iva"] = $qid->f("iva");

	/* delete this iva percentage */
	$qid->Query("DELETE FROM iva WHERE id = '$id'");

	// reset to 0 the iva_id for all products with this iva_id
	$qid->Query(" UPDATE products SET iva_id = 0 WHERE iva_id = '$id'");

	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/iva_deleted.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_iva"      => ov($frm[iva]),
		"backurl"       => $backurl
	));
	$t->pparse("out", "page");
}

function insert_iva($frm) {
/* add a new iva percentage.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("INSERT INTO iva (iva) VALUES ('$frm[iva]')");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/iva_added.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_iva"      => ov($frm[iva]),
		"backurl"       => $backurl
	));
	$t->pparse("out", "page");
}

function update_iva($id, $frm) {
/* update the iva $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("UPDATE iva SET iva = '$frm[iva]' WHERE id = '$id'");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/iva_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_iva"      => ov($frm[iva]),
		"backurl"       => $backurl
	));
	$t->pparse("out", "page");
}

function print_iva_list() {
/* read all the iva percentages from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	if (!isset($page_number) || $datachanged) {
		$qid->Query("
			SELECT id, iva FROM iva WHERE id > 0 ORDER BY iva
		");
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$qid->next_record();
			$SESSION["iva"][$i]["id"] = $qid->f("id");
			$SESSION["iva"][$i]["iva"] = $qid->f("iva");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["iva_per_page"]) {
		$first = ($page_number-1)*$SESSION["iva_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["iva_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["iva_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["iva_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/iva_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "iva_row", "iva_rows");
	$t->set_var("iva_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
			"session_iva_id"	=> $SESSION["iva"][$i]["id"],
			"session_iva_iva"	=> $SESSION["iva"][$i]["iva"]
		));
		$t->parse("iva_rows", "iva_row", true);
	}
	$t->pparse("out", "page");
}

function print_import_iva_form() {
/* print the import iva form so we can add/update iva percentages from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function import_iva($HTTP_POST_FILES) {
/* Import iva percentages from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);
	$errors = new Object;
	global $qid;

	$qid->begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* dangerous characters quoting */
		$fldarr[0] = addslashes($fldarr[0]);

		/* ... and let's see if the iva percentage already exists ... */
		$qid->Query("SELECT id FROM iva WHERE iva = '$fldarr[0]'");
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's create it */
			$qid->Query("INSERT INTO iva (iva) VALUES ('$fldarr[0]')");
		}
	}

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

?>
