<?php
/* categories.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");
require ("$CFG->libdir" . "/" . "$CFG->dbms" . "_adminqueries.inc.php");

$qid = new PGM_Sql;

$DOC_TITLE = "Categories_Management_i18n";
include ("header.php");

switch (nvl($mode)) {
	case "edit" :
		print_edit_category_form($id);
		break;

	case "del" :
		if (!($id == 1)) {
			delete_category($id);
			if ($SESSION["frames_used"]) { ?>
			<script language="JavaScript">
			<!--
			parent.categories.location.reload();
			// -->
			</script>
			<?php }
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_category_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_category($id, $HTTP_POST_VARS);
			if ($SESSION["frames_used"]) { ?>
			<script language="JavaScript">
			<!--
			parent.categories.location.reload();
			// -->
			</script>
			<?php }
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			include ("$CFG->dirroot" . "/form_header.php");
			load_category_form_template($frm, $id, $errors);
		}
		break;

	case "import" :
		print_import_categories_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_categories_form();
		else
			import_categories($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_category_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_category_form_template($frm, $id, $category_options, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/category_i18n_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"		=> $frm["newmode"],
		"category_id"		=> $id,
		"frm_name"		=> ov($frm["name"]),
		"i18n"			=> ov($SESSION["i18n"]),
		"frm_lname"		=> ov($frm["lname"]),
		"errors_name"		=> errmsg($errors->category_name),
		"frm_description"	=> ov($frm["description"]),
		"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function print_edit_category_form($id) {
/* print a category form so we can edit the selected category */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the category */
	get_category_info(&$qid, $id);
	$qid->next_record();
	$frm["name"] = $qid->f("name");
	$frm["lname"] = $qid->f("lname");
	$frm["description"] = $qid->f("description");

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	load_category_form_template($frm, $id, $category_options, $errors);
}

function delete_category($id) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("
		DELETE FROM categories_i18n
		WHERE category_id = '$id' AND lang = '$SESSION[i18n]'
	");
	$qid->Query("
		SELECT name FROM categories
		WHERE id = '$id'
	");
	$qid->next_record();
	$cat->name = $qid->f("name");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/category_i18n_deleted.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"cat_name"	=> ov($cat->name),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function update_category($id, $frm) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid->Query("
		DELETE FROM categories_i18n
		WHERE category_id = '$id' AND lang = '$SESSION[i18n]'
	");
	$qid->Query("
		INSERT INTO categories_i18n (category_id, lang, name)
		VALUES ('$id', '$SESSION[i18n]', '$frm[name]')
	");
	$qid->Query("
		SELECT name FROM categories
		WHERE id = '$id'
	");
	$qid->next_record();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/category_i18n_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_name"	=> ov($qid->f("name")),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function print_category_list() {

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	if (!isset($page_number) || $datachanged) {
		get_allcategories_info(&$qid);
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$qid->next_record();
			$SESSION["categories"][$i]["id"] = $qid->f("id");
			$SESSION["categories"][$i]["name"] = $qid->f("name");
			$SESSION["categories"][$i]["lname"] = $qid->f("lname");
			$SESSION["categories"][$i]["special_level"] = $qid->f("special_level");
			$SESSION["categories"][$i]["description"] = $qid->f("description");
			$SESSION["categories"][$i]["parent"] = $qid->f("parent");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["categories_per_page"]) {
		$first = ($page_number-1)*$SESSION["categories_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["categories_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["categories_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["categories_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/category_i18n_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "category_row", "category_rows");
	$t->set_var("category_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
			"session_categories_id"			=> $SESSION["categories"][$i]["id"],
			"session_categories_name"		=> ov($SESSION["categories"][$i]["name"]),
			"i18n"					=> ov($SESSION["i18n"]),
			"session_categories_lname"		=> ov($SESSION["categories"][$i]["lname"]),
			"session_categories_special_level"	=> $SESSION["categories"][$i]["special_level"],
			"session_categories_parent"		=> ov($SESSION["categories"][$i]["parent"]),
			"session_categories_description"	=> ovwbr($SESSION["categories"][$i]["description"])
		));
		$t->parse("category_rows", "category_row", true);
	}
	$t->pparse("out", "page");
}

function print_import_categories_form() {
/* print the import category form so we can add/update categories from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function import_categories($HTTP_POST_FILES) {
/* Import categories from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->globalerror);
	$errors = new Object;
	global $qid;

	/* Let's open a transaction */
	$qid->begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* Empty parent = "Top" */
		if (strlen(trim($fldarr[0])) == 0)
			$fldarr[0] = "Top";
		/* dangerous characters quoting */
		for ($i=0; $i<3; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* Let's see if the category exists ... */
		$qid->Query("
			SELECT id FROM categories WHERE name = '$fldarr[0]'
		");
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's return an error ... */
			echo $line_num . $Err_ImpCat_i18n . $fldarr[0] . "'.<br>";
		} else {
			/* ... otherwise let's save its ID ... */
			$qid->next_record();
			$cid = $qid->f("id");

			$qid->Query("
				DELETE FROM categories_i18n
				WHERE category_id = '$cid' AND lang = '$fldarr[1]'
			");
			$qid->Query("
				INSERT INTO categories_i18n (category_id, lang, name)
				VALUES ('$cid', '$fldarr[1]', '$fldarr[2]')
			");
		}
	}

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

?>
