/*
	resources.cpp

	Shared data resources for oroject pgjobs to be linked once.
	These resources are declared in defs.h.

	Project: pgjobs
	Author: Zlatko Michailov
	Created: 29-Oct-2003
	Updated:  7-May-2004
	Updated: 26-May-2004
	Updated: 27-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



//--------------------------------------------------------------------------------
// Installation

extern const char	InstallRoot[]		= "/usr/share/pgjobs";



//--------------------------------------------------------------------------------
// Config

extern const char	ConfigFilePath[]	= "/usr/share/pgjobs/pgjobs.conf";
extern const char	BackupExt[]			= ".bak";
extern const char	Default[]			= "default";
extern const char	None[]				= "none";
extern const char	Master[]			= "master";
extern const char	System[]			= "system";
extern const char	Postgres[]			= "postgres";



//--------------------------------------------------------------------------------
// Log

extern const char	LogRoot[]			= "/var/log/pgjobs/";
extern const char	LogExt[]			= ".txt";
extern const char	DatePattern[]		= "%4.4u.%2.2u.%2.2u";
extern const char	TimePattern[]		= "%2.2u:%2.2u:%2.2u";



//--------------------------------------------------------------------------------
// Status

extern const char	StatusStartup[]		= "Startup ";
extern const char	StatusRunning[]		= "Running ";
extern const char	StatusShutdown[]	= "Shutdown";



//--------------------------------------------------------------------------------
// Log Level

extern const char	LogLevelDefault[]	= "1";



//--------------------------------------------------------------------------------
// Config manipulation

extern const char	Indent[]		= "    ";

extern const char*	SchemaSystem[]	=
{
	"Version"
};

extern const char*	SchemaMaster[]	=
{
	"LogLevel"
};

extern const char*	SchemaDb[]		=
{
	"Host        ",
	"Port        ",
	"Database    ",
	"LogLevel    ",
	"User        ",
	"Notification",
	"Recipient   "
};

extern const int SizeOfSchemaSystem	= sizeof( SchemaSystem ) / sizeof( char* );
extern const int SizeOfSchemaMaster	= sizeof( SchemaMaster ) / sizeof( char* );
extern const int SizeOfSchemaDb		= sizeof( SchemaDb ) / sizeof( char* );



//--------------------------------------------------------------------------------
// File system

extern const char	NullDevice[]		= "/dev/null";
extern const char	TempFileTemplate[]	= "%s/pgjobs/%lu-%lu-%lu.tmp";



//--------------------------------------------------------------------------------

