/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DEBUGGER_H
#define DEBUGGER_H

#include <string>
//#include <qstring.h>
#include "../exceptions/vpexception.h"

/**
 * This class contains some debugger utilities. Currently there are 4 types
 * of debugging messages. The types are messages that can be traced are:
 * 1. SQL query messages.
 * 2. Function entering/exiting signals.
 * 3. General debug messages.
 * 4. Exceptions.
 *
 * Currently all error messages are logged to the console. This will eventually
 * change to be able to trace messages to a file.
 */
class Debugger
{
protected:
	/**
	 * This boolean indicates if tracing of SQL queries has been turned on.
	 */
	static bool m_bLogSQL;

	/**
	 * This boolean indicates if tracing of entering/exiting functions
	 * has been turned on.
	 */		
	static bool m_bLogFunctions;
	
	/**
	 * This boolean indicates if tracing of general debug messages has been turned on.
	 */		
	static bool m_bLogTraces;

	/**
	 * This boolean indicates if tracing of exceptions has been turned on.
	 */		
	static bool m_bLogExceptions;
		
public:	
		
	/**
 	 * Used to set the sql trace messages on/off.
   */			    	
	static void setLogSQL(bool bLogSQL);
	
	/**
	 * Used to see if sql message tracing is on or off.
	 */
	static bool isLogSQL();

	/**
 	 * Used to set the functions trace messages on/off.
   */			    	
	static void setLogFunctions(bool bLogFunctions);
	
	/**
	 * Used to see if functions message tracing is on or off.
	 */
	static bool isLogFunctions();

	/**
 	 * Used to set the debug trace messages on/off.
   */			    	
	static void setLogTraces(bool bLogTraces);
	
	/**
	 * Used to see if debug message tracing is on or off.
	 */
	static bool isLogTraces();

	/**
 	 * Used to set the tracing of exceptions on/off.
   */			    	
	static void setLogExceptions(bool bLogExceptions);
	
	/**
	 * Used to see if the tracing of exceptions if on or off.
	 */
	static bool isLogExceptions();
		
	/**
	 * This method will trace a SQL query.
	 */
	static void logSQL(const string & rstrFunctionName, const string & rstrSQL); 				
	
	/**
	 * This method will trace when a function is entered.
	 */
	static void entered(const string & rstrFunctionName); 				

	/**
	 * This method will trace when a function is exited.
	 */
	static void exited(const string & rstrFunctionName); 				

	/**
	 * This method will trace normal debug messages.
	 */
	static void logTrace(const string & rstrFunctionName, const string & rstrMessage); 				

	/**
	 * This method will trace normal debug messages (for QStrings).
	 */
//	static void logQTrace(const string & rstrFunctionName, const QString & rqstrMessage); 				
	
	/**
	 * This method will trace exceptions.
	 */
	static void logException(const string & rstrFunctionName, const VPException & roException); 				
				
};


#endif

