/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "viewgroupitempopup.h"
#include "viewgrouplistviewitem.h"

	/**
	 * Constructor
	 */
	ViewGroupItemPopup::ViewGroupItemPopup(QWidget *pqoParent, ViewGroupListViewItem *poViewGroupItem)
		: QPopupMenu(pqoParent)
	{
		m_poViewGroupItem = poViewGroupItem;	// keep a reference to the view group item
		
		// setup all the items and their slots
		//insertSeparator();
		insertItem("Refresh", this, SLOT(refreshListOfViews()));		
	} // end constructor

	/**
	 * Used to access the view group list view item.
	 */
	ViewGroupListViewItem * ViewGroupItemPopup::getViewGroupListViewItem() const
	{
		return m_poViewGroupItem;
	} // end getViewGroupListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the view list.
   */	
	void ViewGroupItemPopup::refreshListOfViews()
	{
		// lets refresh the list as requested
		m_poViewGroupItem->refreshList();
	} // end refreshListOfViews
