/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "triggeritempopup.h"
#include "triggerlistviewitem.h"
#include "../../common/commentform.h"
#include "../../../utils/debugger.h"

	/**
	 * Constructor
	 */
	TriggerItemPopup::TriggerItemPopup(QWidget *pqoParent, TriggerListViewItem *poTriggerListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poTriggerListViewItem = poTriggerListViewItem;	// keep a reference to the Trigger item
		
		insertItem("View/Edit Comment", this, SLOT(editComment()));				

	} // end constructor

	/**
	 * Used to get a reference to the Trigger item that this popup was generated from.
	 */
	TriggerListViewItem * TriggerItemPopup::getTriggerListViewItem() const
	{
		return m_poTriggerListViewItem;
	} // end getTriggerListViewItem
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void TriggerItemPopup::editComment()
	{
		// bring up edit comment form
		CommentForm *poCommentForm = new CommentForm(this, *((m_poTriggerListViewItem->getDBMasterManager())->getDBConnection()),
																				CommentForm::TriggerComment);
		poCommentForm->setObjectName(m_poTriggerListViewItem->getTriggerName());		
		poCommentForm->setComment(m_poTriggerListViewItem->getTriggerComment().c_str());
		poCommentForm->show();				
	} // end editComment

