/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "triggergroupitempopup.h"
#include "triggergrouplistviewitem.h"

	/**
	 * Constructor
	 */
	TriggerGroupItemPopup::TriggerGroupItemPopup(QWidget *pqoParent, TriggerGroupListViewItem *poTriggerGroupItem)
		: QPopupMenu(pqoParent)
	{
		m_poTriggerGroupItem = poTriggerGroupItem;	// keep a reference to the Trigger group item
		
		// setup all the items and their slots
		//insertSeparator();
		insertItem("Refresh", this, SLOT(refreshListOfTriggers()));		
	} // end constructor

	/**
	 * Used to access the Trigger group list view item.
	 */
	TriggerGroupListViewItem * TriggerGroupItemPopup::getTriggerGroupListViewItem() const
	{
		return m_poTriggerGroupItem;
	} // end getTriggerGroupListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the view list.
   */	
	void TriggerGroupItemPopup::refreshListOfTriggers()
	{
		// lets refresh the list as requested
		m_poTriggerGroupItem->refreshList();
	} // end refreshListOfTriggers
