/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef FOREIGNKEYLISTVIEWITEM_H
#define FOREIGNKEYLISTVIEWITEM_H

#include "../../baselistviewitem.h"
#include "../../../dataaccess/tables/foreignkeys/dbforeignkey.h"
#include "../../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a database table foreign key.
 */
class ForeignKeyListViewItem: public BaseListViewItem, public DBForeignKey, public DBMasterManagerRef
{
				
public:
	
	/**
 	 * Constructor
   */		
	ForeignKeyListViewItem(QListViewItem *pqoListViewItem);
	
	/**
 	 * Constructor
   */			
	ForeignKeyListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	
	
	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
	
};


#endif

