/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "functionitempopup.h"
#include "functionlistviewitem.h"
#include "../common/commentform.h"
#include "../../utils/debugger.h"

	/**
	 * Constructor
	 */
	FunctionItemPopup::FunctionItemPopup(QWidget *pqoParent, FunctionListViewItem *poFunctionListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poFunctionListViewItem = poFunctionListViewItem;	// keep a reference to the Function item
		
		insertItem("View/Edit Comment", this, SLOT(editComment()));				

	} // end constructor

	/**
	 * Used to get a reference to the Function item that this popup was generated from.
	 */
	FunctionListViewItem * FunctionItemPopup::getFunctionListViewItem() const
	{
		return m_poFunctionListViewItem;
	} // end getFunctionListViewItem
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void FunctionItemPopup::editComment()
	{
		// bring up edit comment form
		CommentForm *poCommentForm = new CommentForm(this, *((m_poFunctionListViewItem->getDBMasterManager())->getDBConnection()),
																				CommentForm::FunctionComment);
		poCommentForm->setObjectName(m_poFunctionListViewItem->getFunctionName());		
		poCommentForm->setComment(m_poFunctionListViewItem->getFunctionComment().c_str());
		poCommentForm->show();				
	} // end editComment

