/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef NORECORDEXCEPTION_H
#define NORECORDEXCEPTION_H

#include "vpsystemexception.h"
#include <string>

/**
 * This exception is thrown when a no record exists in a recordset.
 */
class NoRecordException: public VPSystemException
{
	
public:

	/**
 	 * Constructor
 	 *
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	NoRecordException(const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName);
};


#endif

