/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBFOREIGNKEY_H
#define DBFOREIGNKEY_H

#include <string>
#include <vector>
#include "../../../exceptions/indexoutofrangeexception.h"

/**
 * This class is used to represent a database foreign key.
 */
class DBForeignKey
{

protected:
	string m_strForeignKeyName;
	string m_strForeignTableName;
	string m_strTableName;
	vector<string> m_vstrForeignColumns;
	vector<string> m_vstrReferencingColumns;
				
public:
				
	/**
 	 * Constructor
   */		
	DBForeignKey();
	
	/**
 	 * Destructor
   */		
	~DBForeignKey();
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();

	/**
 	 * Used to set the foreign key name.
   */			    	
	void setForeignKeyName(const string &rstrForeignKeyName);

	/**
 	 * Used to retrieve the foreign key name.
   */			    			
	const string & getForeignKeyName() const;
		
	/**
 	 * Used to set the foreign table name.
   */			    	
	void setForeignTableName(const string &rstrForeignTableName);

	/**
 	 * Used to retrieve the foreign table name.
   */			    			
	const string & getForeignTableName() const;

	/**
 	 * Used to set the table name.
   */			    						
	void setTableName(const string &rstrTableName);

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & getTableName() const;			

	/**
 	 * Used to add a foreign key column.
   */			    						
	void addForeignColumn(const string & rstrForeignColumn);

	/**
 	 * Used to retrieve a foreign key column.
   */			    			
	const string & getForeignColumn(int nColumnIndex) const throw (IndexOutOfRangeException);
	
	/**
	 * Used to get the number of foreign key columns.
	 */
	int getNumberOfForeignColumns() const; 			
		
	/**
 	 * Used to add a referencing key column.
   */			    						
	void addReferencingColumn(const string & rstrReferencingColumn);

	/**
 	 * Used to retrieve a referencing key column.
   */			    			
	const string & getReferencingColumn(int nColumnIndex) const throw (IndexOutOfRangeException);
	
	/**
	 * Used to get the number of referencing key columns.
	 */
	int getNumberOfReferencingColumns() const; 			
			
};

#endif

