/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbtableset.h"
#include "../dbconnection.h"

	/**
 	 * Constructor 	
   */		
  DBTableSet::DBTableSet()
  {
  	// do nothing
  } // end constructor
	
	/**
 	 * Destructor
   */		
	DBTableSet::~DBTableSet()
	{
		// do nothing
	} // end destructor

	/**
	 * Used to indicate if the record set is empty.
	 * @return	true if record set is empty, false otherwise
	 */
	bool DBTableSet::isEmpty()
	{
		return m_oTableList.isEmpty();
	} // end isEmpty

	/**
	 * Used to get the current index location.
	 * @return	the current index
	 */
	int DBTableSet::getCurrentIndex()
	{
		return m_oTableList.getCurrentIndex();
	} // end getCurrentIndex
		
	/**
	 * Used to move to the next record in the record set. This function must be called before
	 * the first result can be retrieved. When a record set is initially set, the internal
	 * pointer points to a location before the first record. The reason for this is so that
	 * the record set may sit in a while loop with calls to next indicating if more records
	 * are to come. The function returns true when more records exist and false when no more
	 * records are to come.
	 *
	 * @return	true when more records to come, false when no more records
	 */
	bool DBTableSet::next()
	{
		return m_oTableList.next();	
	} // end next

	/**
	 * Used to move to the previous record in the record set. The function returns true when
	 * a previous record exists, it will return false when the begining of the set is reached.
	 *
	 * @return	true when previous record exists, false when first record reached (or when empty record set)
	 */
	bool DBTableSet::previous()
	{
		return m_oTableList.previous();
	} // end previous

	/**
	 * Used to move the cursor back to a position before the first record. This is used when
	 * the recordset needs to be used but then reset, so that next() function can be used
	 * correctly.
	 */
	void DBTableSet::reset()
	{
		m_oTableList.reset();
	} // end reset
	
	/**
	 * Used to move to the first record.
	 * @exception	throws NoRecordException when empty record
	 */
	void DBTableSet::first() throw (NoRecordException)
	{
		return m_oTableList.first();
	} // end first

	/**
	 * Used to move to the last record.
	 * @exception	throws NoRecordException when empty record	
	 */
	void DBTableSet::last() throw (NoRecordException)
	{
		return m_oTableList.last();	
	} // end last
				
	/**
	 * Used to get the number of records in this record set.
	 * @return 	the number of records
	 */
	int DBTableSet::getRecordCount()
	{
		return m_oTableList.getRecordCount();		
	} // end getRecordCount

	/**
	 * Used to get the current table.
	 * @param	roDBTable the a DBTable object used to return output for current record
	 * @exception	throws NoRecordException when empty record	
	 */
	void DBTableSet::getDBTable(DBTable & roDBTable) throw (NoRecordException)
	{
		if (isEmpty())
		{
			throw NoRecordException(string("Cannot retrieve DBTable object, no records exist."), string("DBTableSet"), string("getDBTable"));
		} // end if empty
		try
		{
			roDBTable.setTableName(m_oTableList.getFieldValue(string("tablename")));
			roDBTable.setTableComment(m_oTableList.getFieldValue(string("description")));			
			roDBTable.setTableOwner(m_oTableList.getFieldValue(string("tableowner")));						
		} // end try
		catch (VPException e)
		{
			// debug this
			cout << e.getExceptionName() << ": " << e.getExceptionDescription() << "\n";
		} // end catch	
	} // end getDBTable

