/*
 * SequenceList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package components.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class SequenceList extends TreeInfo {
    
    /** Creates a new instance of SequenceList */
    public SequenceList(RootElement source) {
        super(source);
        setIcon("/images/sequence.png");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            ResultSet rs = getConnection().getQueryGenerator().getSequenceNames();
            while(rs.next()){
                addProperty(new Element(this, new Sequence(getDatabase(), rs.getString("sequence_name"))));
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){}
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Sequences";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
