/*
 * ColumnPanel.java
 *
 * Created on 1 de agosto de 2002, 16:34
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class ColumnPanel extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private ColumnPanelListener listener = null;
    
    /** Creates a new instance of ColumnPanel */
    public ColumnPanel() {
        data_table = new SQLTable();
        listener = new ColumnPanelListener(this);
        initPanel();
    }
    
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
        //        add(new ColumnPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    public void refresh(){
        ((SQLTableModel) data_table.getModel()).setDataSource(getColumnsTable());
        repaint();
    }
    public void refresh(Table table_object){
        table = table_object;
        refresh();
    }
    
    public Table getTable(){
        return table;
    }
    
    public ColumnPanelListener getListener(){
        return listener;
    }
    
    public void newColumn(){
    }
    public void editColumn(){
    }
    public void deleteColumn(){
    }
    
    
    public dataSource getColumnsTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        
        if(table != null){
            Vector temp = table.getColumns();
            for(int i=0; i<temp.size(); i++){
                TableColumn tc = (TableColumn) temp.get(i);
                
                Vector elem = new Vector();
                elem.add(String.valueOf(tc.getColumnNumber()));
                elem.add(tc.getName());
                elem.add(tc.getColumnType().getName());
                elem.add(String.valueOf(tc.getSize()));
                elem.add(Utilities.formatBoolean(tc.allowNulls()));
                elem.add(tc.getDefaultValue());
                elem.add(tc.getDescription());
                
                dsve.addElement(elem);
            }
        }
        return dsve;
    }
}

