/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import pgclibrary.objects.DBObject;

public class TableForeignKey
extends DBObject {
    private boolean enabled = false;
    private String tablename = new String();
    private String onDelete = new String();
    private String onUpdate = new String();
    private Vector scolumns = new Vector();
    private Vector dcolumns = new Vector();
    private boolean deferrable = false;

    public TableForeignKey(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public String getDeleteSQL() {
        return new String();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("CONSTRAINT ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" FOREIGN KEY (");
        int n = 0;
        while (n < this.getSourceColumnNames().size()) {
            stringBuffer.append(this.getSourceColumnNames().get(n));
            if (n < this.getSourceColumnNames().size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" ) REFERENCES ").append(this.getTableName()).append(" (");
        int n2 = 0;
        while (n2 < this.getDestColumnNames().size()) {
            stringBuffer.append(this.getDestColumnNames().get(n2));
            if (n2 < this.getDestColumnNames().size() - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(" ) ON DELETE ").append(this.getOnDelete());
        stringBuffer.append(" ON UPDATE ").append(this.getOnUpdate());
        if (this.isDeferrable()) {
            stringBuffer.append(" DEFERRABLE ");
        } else {
            stringBuffer.append(" NOT DEFERRABLE ");
        }
        stringBuffer.append(" INITIALLY IMMEDIATE");
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getTableForeignKey(this.getOwner().getName(), string);
            if (resultSet != null && resultSet.next()) {
                this.setEnabled(resultSet.getBoolean("fk_enabled"));
                this.setName(resultSet.getString("fk_name"));
                this.setTableName(resultSet.getString("fk_table"));
                this.setDeferrable(resultSet.getBoolean("fk_deferrable"));
                this.setOnDelete(resultSet.getString("del_proc"));
                this.setOnUpdate(resultSet.getString("upd_proc"));
                this.setColumns(resultSet.getInt("fk_argnum"), resultSet.getString("fk_arguments"));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.enabled = false;
        this.tablename = new String();
        this.scolumns = new Vector();
        this.dcolumns = new Vector();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public String getTableName() {
        return this.tablename;
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public String getSourceColumns() {
        String string = new String();
        int n = 0;
        while (n < this.getSourceColumnNames().size()) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + (String)this.getSourceColumnNames().get(n);
            ++n;
        }
        return string;
    }

    public Vector getSourceColumnNames() {
        return this.scolumns;
    }

    public String getDestColumns() {
        String string = new String();
        int n = 0;
        while (n < this.getDestColumnNames().size()) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + (String)this.getDestColumnNames().get(n);
            ++n;
        }
        return string;
    }

    public Vector getDestColumnNames() {
        return this.dcolumns;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private void setDeferrable(boolean bl) {
        this.deferrable = bl;
    }

    private void setTableName(String string) {
        this.tablename = string != null ? string : new String();
    }

    private String getAction(String string) {
        String string2 = "NO ACTION";
        if (string.indexOf("cascade") > 0) {
            string2 = "CASCADE";
        } else if (string.indexOf("restrict") > 0) {
            string2 = "RESTRICT";
        } else if (string.indexOf("null") > 0) {
            string2 = "SET NULL";
        } else if (string.indexOf("default") > 0) {
            string2 = "SET DEFAULT";
        }
        return string2;
    }

    private void setOnDelete(String string) {
        this.onDelete = this.getAction(string);
    }

    private void setOnUpdate(String string) {
        this.onUpdate = this.getAction(string);
    }

    private void setColumns(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\000");
        int n2 = 0;
        while (n2 < 4 && stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n2;
        }
        this.scolumns = new Vector();
        this.dcolumns = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            this.scolumns.add(stringTokenizer.nextToken());
            this.dcolumns.add(stringTokenizer.nextToken());
        }
    }
}

