namespace eval ::math {
	proc Max {pValue args} {
		set lMax $pValue
	
		foreach lValue $args {
			if {($lValue > $lMax)} {
				set lMax $lValue
			}
		}
	
		return $lMax
	}


	proc Min {pValue args} {
		set lMin $pValue
		
		foreach lValue $args {
			if {($lValue < $lMin)} {
				set lMin $lValue
			}
		}
	
		return $lMin
	}
	
	proc Mean {pValue args} {
		set lSum $pValue
	
		set lArgc [expr {[llength $args] + 1}]
	
		foreach lValue $args {
			set lSum [expr {$lSum + $lValue}]
		}
	
		return [expr {double($lSum) / $lArgc }]
	}
	
	proc Product {pValue args} {
		set lProduct $pValue
		
		foreach lValue $args {
			set lProduct [expr {$lProduct * $lValue}]
		}
	
		return $lProduct
	}
	
	proc Sum {pValue args} {
		set lSum $pValue
	
		foreach lValue $args {
			set lSum [expr {$lSum + $lValue}]
		}
	
		return $lSum
	}
}
