/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.ResultSet;
import org.postgresql.jdbc2.Connection;
import org.postgresql.util.PSQLException;

public class Statement
implements java.sql.Statement {
    Connection connection;
    java.sql.ResultSet result = null;
    SQLWarning warnings = null;
    int timeout = 0;
    boolean escapeProcessing = true;
    private Vector batch = null;

    public Statement(Connection c) {
        this.connection = c;
    }

    public void addBatch(String sql) throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        this.batch.addElement(sql);
    }

    public void cancel() throws SQLException {
    }

    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.removeAllElements();
        }
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void close() throws SQLException {
        this.result = null;
    }

    public boolean execute(String sql) throws SQLException {
        if (this.escapeProcessing) {
            sql = this.connection.EscapeSQL(sql);
        }
        this.result = this.connection.ExecSQL(sql);
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public int[] executeBatch() throws SQLException {
        if (this.batch == null || this.batch.isEmpty()) {
            throw new PSQLException("postgresql.stat.batch.empty");
        }
        int size = this.batch.size();
        int[] result = new int[size];
        int i = 0;
        this.execute("begin");
        try {
            i = 0;
            while (i < size) {
                result[i] = this.executeUpdate((String)this.batch.elementAt(i));
                ++i;
            }
            this.execute("commit");
        }
        catch (SQLException sQLException) {
            this.execute("abort");
            throw new PSQLException("postgresql.stat.batch.error", new Integer(i), this.batch.elementAt(i));
        }
        return result;
    }

    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        while (this.result != null && !((ResultSet)((Object)this.result)).reallyResultSet()) {
            this.result = ((ResultSet)((Object)this.result)).getNext();
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult");
        }
        return this.result;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getFetchSize() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getKeysetSize() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getMaxFieldSize() throws SQLException {
        return 8192;
    }

    public int getMaxRows() throws SQLException {
        return this.connection.maxrows;
    }

    public boolean getMoreResults() throws SQLException {
        this.result = ((ResultSet)((Object)this.result)).getNext();
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.result;
    }

    public int getResultSetConcurrency() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getResultSetType() throws SQLException {
        throw Driver.notImplemented();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return ((ResultSet)((Object)this.result)).getStatusString();
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            return -1;
        }
        return ((ResultSet)((Object)this.result)).getResultCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void setCursorName(String name) throws SQLException {
        this.connection.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setKeysetSize(int keys) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new PSQLException("postgresql.stat.maxfieldsize");
    }

    public void setMaxRows(int max) throws SQLException {
        this.connection.maxrows = max;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    public void setResultSetConcurrency(int value) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setResultSetType(int value) throws SQLException {
        throw Driver.notImplemented();
    }
}

