""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

import os
from sys import stdin, stdout, stderr

global PYTHONDEBUG
if os.environ.has_key('PYTHONDEBUG'):
	PYTHONDEBUG = os.environ['PYTHONDEBUG']
else:
	PYTHONDEBUG = 0

class Object:
	"the top class object"

	type = 'Object'

	def __init__(self, name = 'Object'):
		if PYTHONDEBUG:
			stderr.write('creating object %s\n' % name)
		self.name = name
		
	def __repr__(self):
		return "<object name='%s'/>" % self.name

	def __str__(self):
		"do not overload, should be equivalent to self.name"
		return self.name
	
	def __cmp__(self, object):
		return cmp(str(self),str(object))

	def __nonzero__(self):
		return 1
	
	def __hash__(self):
		return hash(self.name)

	def copy(self):
		return Object(self.name)
	
	def read(self, filename):
		"serialization"
		return
	
	def write(self, filename):
		"serialization"
		output = open(filename,'w')
		output.write(`self`)
