"""remove old cvss model and add a new one

Revision ID: 0ed0dab44def
Revises: 4d7a8fdd94e4
Create Date: 2022-07-22 15:51:22.639999+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '85aeb4185f98'
down_revision = '0ed0dab44def'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('vulnerability_cvssv2_id_fkey', 'vulnerability', type_='foreignkey')
    op.drop_constraint('vulnerability_cvssv3_id_fkey', 'vulnerability', type_='foreignkey')
    op.drop_table('cvss_v3')
    op.drop_table('cvss_v2')
    op.drop_table('cvss_base')
    op.drop_column('vulnerability', 'cvssv2_id')
    op.drop_column('vulnerability', 'cvssv3_id')
    op.execute('drop type cvss_attack_complexity')
    op.execute('drop type cvss_access_vector')
    op.execute('drop type cvss_access_complexity')
    op.execute('drop type cvss_attack_vector')
    op.execute('drop type cvss_authentication')
    op.execute('drop type cvss_privileges_required')
    op.execute('drop type cvss_scope')
    op.execute('drop type cvss_user_interaction')
    op.execute('drop type cvss_impact_types_v2')
    op.execute('drop type cvss_impact_types_v3')

    op.add_column('vulnerability', sa.Column('_cvss2_vector_string', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_base_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_exploitability_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_impact_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_base_severity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_temporal_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_temporal_severity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_environmental_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_environmental_severity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_access_vector', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_access_complexity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_authentication', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_confidentiality_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_integrity_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_availability_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_exploitability', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_remediation_level', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_report_confidence', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_collateral_damage_potential', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_target_distribution', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_confidentiality_requirement', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_integrity_requirement', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss2_availability_requirement', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('_cvss3_vector_string', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_base_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_exploitability_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_impact_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_base_severity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_temporal_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_temporal_severity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_environmental_score', sa.Float(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_environmental_severity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_attack_vector', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_attack_complexity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_privileges_required', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_user_interaction', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_confidentiality_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_integrity_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_availability_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_exploit_code_maturity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_remediation_level', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_report_confidence', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_confidentiality_requirement', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_integrity_requirement', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_availability_requirement', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_attack_vector', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_attack_complexity', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_privileges_required', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_user_interaction', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_scope', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_confidentiality_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_integrity_impact', sa.Text(), nullable=True))
    op.add_column('vulnerability', sa.Column('cvss3_modified_availability_impact', sa.Text(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('vulnerability', 'cvss3_modified_availability_impact')
    op.drop_column('vulnerability', 'cvss3_modified_integrity_impact')
    op.drop_column('vulnerability', 'cvss3_modified_confidentiality_impact')
    op.drop_column('vulnerability', 'cvss3_modified_scope')
    op.drop_column('vulnerability', 'cvss3_modified_user_interaction')
    op.drop_column('vulnerability', 'cvss3_modified_privileges_required')
    op.drop_column('vulnerability', 'cvss3_modified_attack_complexity')
    op.drop_column('vulnerability', 'cvss3_modified_attack_vector')
    op.drop_column('vulnerability', 'cvss3_availability_requirement')
    op.drop_column('vulnerability', 'cvss3_integrity_requirement')
    op.drop_column('vulnerability', 'cvss3_confidentiality_requirement')
    op.drop_column('vulnerability', 'cvss3_report_confidence')
    op.drop_column('vulnerability', 'cvss3_remediation_level')
    op.drop_column('vulnerability', 'cvss3_exploit_code_maturity')
    op.drop_column('vulnerability', 'cvss3_availability_impact')
    op.drop_column('vulnerability', 'cvss3_integrity_impact')
    op.drop_column('vulnerability', 'cvss3_confidentiality_impact')
    op.drop_column('vulnerability', 'cvss3_user_interaction')
    op.drop_column('vulnerability', 'cvss3_privileges_required')
    op.drop_column('vulnerability', 'cvss3_attack_complexity')
    op.drop_column('vulnerability', 'cvss3_attack_vector')
    op.drop_column('vulnerability', 'cvss3_environmental_severity')
    op.drop_column('vulnerability', 'cvss3_environmental_score')
    op.drop_column('vulnerability', 'cvss3_temporal_severity')
    op.drop_column('vulnerability', 'cvss3_temporal_score')
    op.drop_column('vulnerability', 'cvss3_base_severity')
    op.drop_column('vulnerability', 'cvss3_base_score')
    op.drop_column('vulnerability', 'cvss3_impact_score')
    op.drop_column('vulnerability', 'cvss3_exploitability_score')
    op.drop_column('vulnerability', '_cvss3_vector_string')
    op.drop_column('vulnerability', 'cvss2_availability_requirement')
    op.drop_column('vulnerability', 'cvss2_integrity_requirement')
    op.drop_column('vulnerability', 'cvss2_confidentiality_requirement')
    op.drop_column('vulnerability', 'cvss2_target_distribution')
    op.drop_column('vulnerability', 'cvss2_collateral_damage_potential')
    op.drop_column('vulnerability', 'cvss2_report_confidence')
    op.drop_column('vulnerability', 'cvss2_remediation_level')
    op.drop_column('vulnerability', 'cvss2_exploitability')
    op.drop_column('vulnerability', 'cvss2_availability_impact')
    op.drop_column('vulnerability', 'cvss2_integrity_impact')
    op.drop_column('vulnerability', 'cvss2_confidentiality_impact')
    op.drop_column('vulnerability', 'cvss2_authentication')
    op.drop_column('vulnerability', 'cvss2_access_complexity')
    op.drop_column('vulnerability', 'cvss2_access_vector')
    op.drop_column('vulnerability', 'cvss2_environmental_severity')
    op.drop_column('vulnerability', 'cvss2_environmental_score')
    op.drop_column('vulnerability', 'cvss2_temporal_severity')
    op.drop_column('vulnerability', 'cvss2_temporal_score')
    op.drop_column('vulnerability', 'cvss2_base_severity')
    op.drop_column('vulnerability', 'cvss2_base_score')
    op.drop_column('vulnerability', 'cvss2_impact_score')
    op.drop_column('vulnerability', 'cvss2_exploitability_score')
    op.drop_column('vulnerability', '_cvss2_vector_string')

    op.add_column('vulnerability', sa.Column('cvssv3_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('vulnerability', sa.Column('cvssv2_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_table('cvss_base',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('cvss_base_id_seq'::regclass)"), autoincrement=True, nullable=False),
    sa.Column('version', sa.VARCHAR(length=8), autoincrement=False, nullable=False),
    sa.Column('vector_string', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('base_score', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('fixed_base_score', postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    sa.Column('type', sa.VARCHAR(length=24), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='cvss_base_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('cvss_v2',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('access_vector', postgresql.ENUM('L', 'N', 'A', name='cvss_access_vector'), autoincrement=False, nullable=True),
    sa.Column('access_complexity', postgresql.ENUM('L', 'M', 'H', name='cvss_access_complexity'), autoincrement=False, nullable=True),
    sa.Column('authentication', postgresql.ENUM('N', 'S', 'M', name='cvss_authentication'), autoincrement=False, nullable=True),
    sa.Column('confidentiality_impact', postgresql.ENUM('N', 'P', 'C', name='cvss_impact_types_v2'), autoincrement=False, nullable=True),
    sa.Column('integrity_impact', postgresql.ENUM('N', 'P', 'C', name='cvss_impact_types_v2'), autoincrement=False, nullable=True),
    sa.Column('availability_impact', postgresql.ENUM('N', 'P', 'C', name='cvss_impact_types_v2'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['id'], ['cvss_base.id'], name='cvss_v2_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='cvss_v2_pkey')
    )
    op.create_table('cvss_v3',
    sa.Column('id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('attack_vector', postgresql.ENUM('N', 'A', 'L', 'P', name='cvss_attack_vector'), autoincrement=False, nullable=True),
    sa.Column('attack_complexity', postgresql.ENUM('L', 'H', name='cvss_attack_complexity'), autoincrement=False, nullable=True),
    sa.Column('privileges_required', postgresql.ENUM('N', 'L', 'H', name='cvss_privileges_required'), autoincrement=False, nullable=True),
    sa.Column('user_interaction', postgresql.ENUM('N', 'R', name='cvss_user_interaction'), autoincrement=False, nullable=True),
    sa.Column('scope', postgresql.ENUM('U', 'C', name='cvss_scope'), autoincrement=False, nullable=True),
    sa.Column('confidentiality_impact', postgresql.ENUM('N', 'L', 'H', name='cvss_impact_types_v3'), autoincrement=False, nullable=True),
    sa.Column('integrity_impact', postgresql.ENUM('N', 'L', 'H', name='cvss_impact_types_v3'), autoincrement=False, nullable=True),
    sa.Column('availability_impact', postgresql.ENUM('N', 'L', 'H', name='cvss_impact_types_v3'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['id'], ['cvss_base.id'], name='cvss_v3_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='cvss_v3_pkey')
    )
    op.create_foreign_key('vulnerability_cvssv3_id_fkey', 'vulnerability', 'cvss_v3', ['cvssv3_id'], ['id'])
    op.create_foreign_key('vulnerability_cvssv2_id_fkey', 'vulnerability', 'cvss_v2', ['cvssv2_id'], ['id'])
    # ### end Alembic commands ###
