/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLDocument.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXMLDocumentConstructor);

class JSXMLDocumentPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLDocumentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLDocumentPrototype>(vm)) JSXMLDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLDocumentPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLDocumentPrototype, JSXMLDocumentPrototype::Base);

using JSXMLDocumentDOMConstructor = JSDOMConstructorNotConstructable<JSXMLDocument>;

template<> const ClassInfo JSXMLDocumentDOMConstructor::s_info = { "XMLDocument"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLDocumentDOMConstructor) };

template<> JSValue JSXMLDocumentDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDocument::getConstructor(vm, &globalObject);
}

template<> void JSXMLDocumentDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XMLDocument"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXMLDocument::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSXMLDocumentPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLDocumentConstructor, 0 } },
};

const ClassInfo JSXMLDocumentPrototype::s_info = { "XMLDocument"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLDocumentPrototype) };

void JSXMLDocumentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLDocument::info(), JSXMLDocumentPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXMLDocument::s_info = { "XMLDocument"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLDocument) };

JSXMLDocument::JSXMLDocument(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLDocument>&& impl)
    : JSDocument(structure, globalObject, WTFMove(impl))
{
}

Ref<XMLDocument> JSXMLDocument::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSXMLDocument::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXMLDocumentPrototype::createStructure(vm, &globalObject, JSDocument::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSXMLDocumentPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXMLDocument::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLDocument>(vm, globalObject);
}

JSValue JSXMLDocument::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLDocumentDOMConstructor, DOMConstructorID::XMLDocument>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLDocumentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLDocumentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLDocument::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSXMLDocument::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXMLDocument, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXMLDocument.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXMLDocument = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXMLDocument.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXMLDocument = std::forward<decltype(space)>(space); }
    );
}

void JSXMLDocument::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLDocument*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
