/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWGSLLanguageFeatures.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMSetLike.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_has);
static JSC_DECLARE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_entries);
static JSC_DECLARE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_keys);
static JSC_DECLARE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_values);
static JSC_DECLARE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_forEach);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWGSLLanguageFeaturesConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWGSLLanguageFeatures_size);

class JSWGSLLanguageFeaturesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWGSLLanguageFeaturesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWGSLLanguageFeaturesPrototype* ptr = new (NotNull, JSC::allocateCell<JSWGSLLanguageFeaturesPrototype>(vm)) JSWGSLLanguageFeaturesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWGSLLanguageFeaturesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWGSLLanguageFeaturesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWGSLLanguageFeaturesPrototype, JSWGSLLanguageFeaturesPrototype::Base);

using JSWGSLLanguageFeaturesDOMConstructor = JSDOMConstructorNotConstructable<JSWGSLLanguageFeatures>;

template<> const ClassInfo JSWGSLLanguageFeaturesDOMConstructor::s_info = { "WGSLLanguageFeatures"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWGSLLanguageFeaturesDOMConstructor) };

template<> JSValue JSWGSLLanguageFeaturesDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWGSLLanguageFeaturesDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WGSLLanguageFeatures"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWGSLLanguageFeatures::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWGSLLanguageFeaturesPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWGSLLanguageFeaturesConstructor, 0 } },
    { "size"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWGSLLanguageFeatures_size, 0 } },
    { "has"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWGSLLanguageFeaturesPrototypeFunction_has, 1 } },
    { "entries"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWGSLLanguageFeaturesPrototypeFunction_entries, 0 } },
    { "keys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWGSLLanguageFeaturesPrototypeFunction_keys, 0 } },
    { "values"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWGSLLanguageFeaturesPrototypeFunction_values, 0 } },
    { "forEach"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWGSLLanguageFeaturesPrototypeFunction_forEach, 1 } },
};

const ClassInfo JSWGSLLanguageFeaturesPrototype::s_info = { "WGSLLanguageFeatures"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWGSLLanguageFeaturesPrototype) };

void JSWGSLLanguageFeaturesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWGSLLanguageFeatures::info(), JSWGSLLanguageFeaturesPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, getDirect(vm, vm.propertyNames->builtinNames().valuesPublicName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWGSLLanguageFeatures::s_info = { "WGSLLanguageFeatures"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWGSLLanguageFeatures) };

JSWGSLLanguageFeatures::JSWGSLLanguageFeatures(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WGSLLanguageFeatures>&& impl)
    : JSDOMWrapper<WGSLLanguageFeatures>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WGSLLanguageFeatures>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWGSLLanguageFeatures::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWGSLLanguageFeaturesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWGSLLanguageFeaturesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWGSLLanguageFeatures::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWGSLLanguageFeatures>(vm, globalObject);
}

JSValue JSWGSLLanguageFeatures::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWGSLLanguageFeaturesDOMConstructor, DOMConstructorID::WGSLLanguageFeatures>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWGSLLanguageFeatures::destroy(JSC::JSCell* cell)
{
    JSWGSLLanguageFeatures* thisObject = static_cast<JSWGSLLanguageFeatures*>(cell);
    thisObject->JSWGSLLanguageFeatures::~JSWGSLLanguageFeatures();
}

JSC_DEFINE_CUSTOM_GETTER(jsWGSLLanguageFeaturesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWGSLLanguageFeaturesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWGSLLanguageFeatures::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWGSLLanguageFeatures_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSWGSLLanguageFeatures& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAny>(lexicalGlobalObject, throwScope, forwardSizeToSetLike(lexicalGlobalObject, thisObject))));
}

JSC_DEFINE_CUSTOM_GETTER(jsWGSLLanguageFeatures_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWGSLLanguageFeatures>::get<jsWGSLLanguageFeatures_sizeGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWGSLLanguageFeaturesPrototypeFunction_hasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWGSLLanguageFeatures>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(keyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, forwardHasToSetLike(*lexicalGlobalObject, *callFrame, *castedThis, keyConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_has, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWGSLLanguageFeatures>::call<jsWGSLLanguageFeaturesPrototypeFunction_hasBody>(*lexicalGlobalObject, *callFrame, "has");
}

static inline JSC::EncodedJSValue jsWGSLLanguageFeaturesPrototypeFunction_entriesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWGSLLanguageFeatures>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, forwardEntriesToSetLike(*lexicalGlobalObject, *callFrame, *castedThis))));
}

JSC_DEFINE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_entries, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWGSLLanguageFeatures>::call<jsWGSLLanguageFeaturesPrototypeFunction_entriesBody>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline JSC::EncodedJSValue jsWGSLLanguageFeaturesPrototypeFunction_keysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWGSLLanguageFeatures>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, forwardKeysToSetLike(*lexicalGlobalObject, *callFrame, *castedThis))));
}

JSC_DEFINE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_keys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWGSLLanguageFeatures>::call<jsWGSLLanguageFeaturesPrototypeFunction_keysBody>(*lexicalGlobalObject, *callFrame, "keys");
}

static inline JSC::EncodedJSValue jsWGSLLanguageFeaturesPrototypeFunction_valuesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWGSLLanguageFeatures>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, forwardValuesToSetLike(*lexicalGlobalObject, *callFrame, *castedThis))));
}

JSC_DEFINE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_values, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWGSLLanguageFeatures>::call<jsWGSLLanguageFeaturesPrototypeFunction_valuesBody>(*lexicalGlobalObject, *callFrame, "values");
}

static inline JSC::EncodedJSValue jsWGSLLanguageFeaturesPrototypeFunction_forEachBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWGSLLanguageFeatures>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(callbackConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, forwardForEachToSetLike(*lexicalGlobalObject, *callFrame, *castedThis, callbackConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsWGSLLanguageFeaturesPrototypeFunction_forEach, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWGSLLanguageFeatures>::call<jsWGSLLanguageFeaturesPrototypeFunction_forEachBody>(*lexicalGlobalObject, *callFrame, "forEach");
}

JSC::GCClient::IsoSubspace* JSWGSLLanguageFeatures::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWGSLLanguageFeatures, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWGSLLanguageFeatures.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWGSLLanguageFeatures = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWGSLLanguageFeatures.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWGSLLanguageFeatures = std::forward<decltype(space)>(space); }
    );
}

void JSWGSLLanguageFeatures::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWGSLLanguageFeatures*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWGSLLanguageFeaturesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWGSLLanguageFeaturesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWGSLLanguageFeatures = static_cast<JSWGSLLanguageFeatures*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWGSLLanguageFeatures->protectedWrapped().ptr(), jsWGSLLanguageFeatures);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WGSLLanguageFeatures@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20WGSLLanguageFeaturesE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WGSLLanguageFeatures>, void>> static inline void verifyVTable(WGSLLanguageFeatures* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WGSLLanguageFeatures@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20WGSLLanguageFeaturesE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WGSLLanguageFeatures has subclasses. If WGSLLanguageFeatures has subclasses that get passed
        // to toJS() we currently require WGSLLanguageFeatures you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WGSLLanguageFeatures>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WGSLLanguageFeatures>(impl.ptr());
#endif
    return createWrapper<WGSLLanguageFeatures>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WGSLLanguageFeatures& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WGSLLanguageFeatures* JSWGSLLanguageFeatures::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWGSLLanguageFeatures*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
