/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSVideoConfiguration.h"

#include "JSColorGamut.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSHdrMetadataType.h"
#include "JSTransferFunction.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<VideoConfiguration>> convertDictionary<VideoConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    VideoConfiguration result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().mediaCapabilitiesExtensionsEnabled) {
        JSValue alphaChannelValue;
        if (isNullOrUndefined)
            alphaChannelValue = jsUndefined();
        else {
            alphaChannelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alphaChannel"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!alphaChannelValue.isUndefined()) {
            auto alphaChannelConversionResult = convert<IDLBoolean>(lexicalGlobalObject, alphaChannelValue);
            if (UNLIKELY(alphaChannelConversionResult.hasException(throwScope)))
                return ConversionResultException { };
            result.alphaChannel = alphaChannelConversionResult.releaseReturnValue();
        }
    }
    JSValue bitrateValue;
    if (isNullOrUndefined)
        bitrateValue = jsUndefined();
    else {
        bitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (bitrateValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "bitrate"_s, "VideoConfiguration"_s, "unsigned long long"_s);
        return ConversionResultException { };
    }
    auto bitrateConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bitrateValue);
    if (UNLIKELY(bitrateConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bitrate = bitrateConversionResult.releaseReturnValue();
    JSValue colorGamutValue;
    if (isNullOrUndefined)
        colorGamutValue = jsUndefined();
    else {
        colorGamutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorGamut"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!colorGamutValue.isUndefined()) {
        auto colorGamutConversionResult = convert<IDLEnumeration<ColorGamut>>(lexicalGlobalObject, colorGamutValue);
        if (UNLIKELY(colorGamutConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.colorGamut = colorGamutConversionResult.releaseReturnValue();
    }
    JSValue contentTypeValue;
    if (isNullOrUndefined)
        contentTypeValue = jsUndefined();
    else {
        contentTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "contentType"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (contentTypeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "contentType"_s, "VideoConfiguration"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto contentTypeConversionResult = convert<IDLDOMString>(lexicalGlobalObject, contentTypeValue);
    if (UNLIKELY(contentTypeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.contentType = contentTypeConversionResult.releaseReturnValue();
    JSValue framerateValue;
    if (isNullOrUndefined)
        framerateValue = jsUndefined();
    else {
        framerateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framerate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (framerateValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "framerate"_s, "VideoConfiguration"_s, "double"_s);
        return ConversionResultException { };
    }
    auto framerateConversionResult = convert<IDLDouble>(lexicalGlobalObject, framerateValue);
    if (UNLIKELY(framerateConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.framerate = framerateConversionResult.releaseReturnValue();
    JSValue hdrMetadataTypeValue;
    if (isNullOrUndefined)
        hdrMetadataTypeValue = jsUndefined();
    else {
        hdrMetadataTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hdrMetadataType"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!hdrMetadataTypeValue.isUndefined()) {
        auto hdrMetadataTypeConversionResult = convert<IDLEnumeration<HdrMetadataType>>(lexicalGlobalObject, hdrMetadataTypeValue);
        if (UNLIKELY(hdrMetadataTypeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.hdrMetadataType = hdrMetadataTypeConversionResult.releaseReturnValue();
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (heightValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "height"_s, "VideoConfiguration"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto heightConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, heightValue);
    if (UNLIKELY(heightConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.height = heightConversionResult.releaseReturnValue();
    JSValue transferFunctionValue;
    if (isNullOrUndefined)
        transferFunctionValue = jsUndefined();
    else {
        transferFunctionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transferFunction"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!transferFunctionValue.isUndefined()) {
        auto transferFunctionConversionResult = convert<IDLEnumeration<TransferFunction>>(lexicalGlobalObject, transferFunctionValue);
        if (UNLIKELY(transferFunctionConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.transferFunction = transferFunctionConversionResult.releaseReturnValue();
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (widthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "width"_s, "VideoConfiguration"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto widthConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, widthValue);
    if (UNLIKELY(widthConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.width = widthConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const VideoConfiguration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().mediaCapabilitiesExtensionsEnabled) {
        if (!IDLBoolean::isNullValue(dictionary.alphaChannel)) {
            auto alphaChannelValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.alphaChannel));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "alphaChannel"_s), alphaChannelValue);
        }
    }
    auto bitrateValue = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, dictionary.bitrate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrate"_s), bitrateValue);
    if (!IDLEnumeration<ColorGamut>::isNullValue(dictionary.colorGamut)) {
        auto colorGamutValue = toJS<IDLEnumeration<ColorGamut>>(lexicalGlobalObject, throwScope, IDLEnumeration<ColorGamut>::extractValueFromNullable(dictionary.colorGamut));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "colorGamut"_s), colorGamutValue);
    }
    auto contentTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.contentType);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "contentType"_s), contentTypeValue);
    auto framerateValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.framerate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "framerate"_s), framerateValue);
    if (!IDLEnumeration<HdrMetadataType>::isNullValue(dictionary.hdrMetadataType)) {
        auto hdrMetadataTypeValue = toJS<IDLEnumeration<HdrMetadataType>>(lexicalGlobalObject, throwScope, IDLEnumeration<HdrMetadataType>::extractValueFromNullable(dictionary.hdrMetadataType));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hdrMetadataType"_s), hdrMetadataTypeValue);
    }
    auto heightValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.height);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    if (!IDLEnumeration<TransferFunction>::isNullValue(dictionary.transferFunction)) {
        auto transferFunctionValue = toJS<IDLEnumeration<TransferFunction>>(lexicalGlobalObject, throwScope, IDLEnumeration<TransferFunction>::extractValueFromNullable(dictionary.transferFunction));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "transferFunction"_s), transferFunctionValue);
    }
    auto widthValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.width);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    return result;
}

} // namespace WebCore
